package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.mapper.ProjectDocMapper;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/28 14:43
 */
@Service("projectService")
public class ProjectDocServiceImpl extends BaseServiceImpl<ProjectDocMapper, ProjectDocEntity> implements IProjectDocService {

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ProjectDocMapper projectDocMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void archiveFiles(List<ProjectDocVO> projectDocVOs, List<Long> attachIds) {
        List<ProjectDocEntity> saveEntities = BeanMapper.mapList(projectDocVOs, ProjectDocEntity.class);
        super.saveBatch(saveEntities);

        //更新对应附件的归档状态
        JSONObject param = new JSONObject();
        param.put("status", 1);
        param.put("attachIds", attachIds);
        CommonResponse<String> updateResp = attachmentApi.updateAttachArchiveStatus(param.toJSONString());
        if(!updateResp.isSuccess()) {
            throw new BusinessException("归档失败，更新附件归档状态失败！");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delArchiveDocs(List<Long> ids) {
        List<ProjectDocEntity> list = baseMapper.selectBatchIds(ids);
        baseMapper.deleteBatchIds(ids);

        List<Long> attachIds = list.stream().map(doc -> doc.getFileId()).collect(Collectors.toList());
        //更新对应附件的归档状态
        JSONObject param = new JSONObject();
        param.put("status", 0);
        param.put("attachIds", attachIds);
        CommonResponse<String> updateResp = attachmentApi.updateAttachArchiveStatus(param.toJSONString());
        if(!updateResp.isSuccess()) {
            throw new BusinessException("删除失败，更新附件归档状态失败！");
        }
    }

    @Override
    public IPage<ProjectDocEntity> queryPageList(Integer pageSize, Integer pageIndex, Long tenantId, List<Long> categoryIds, String searchText, List<Long> orgIds) {
        IPage<ProjectDocEntity> page = new Page<>();
        long total = projectDocMapper.count(tenantId, categoryIds, searchText, orgIds);
        page.setSize(pageSize);
        page.setCurrent(pageIndex);

        if(total == 0) {
            return page;
        }
        List<ProjectDocEntity> records= projectDocMapper.pageList(pageSize, (pageIndex < 1 ? 0 : pageIndex - 1) * pageSize, tenantId, categoryIds, searchText, orgIds);
        page.setTotal(total);
        page.setRecords(records);
        return page;
    }

}
