package com.ejianc.business.doc.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.doc.bean.KbmCategoryAccessEntity;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
/**
 * 知识分类
 * 
 * @author generator
 * 
 */
 @TableName("ejc_doc_kbm_category")
public class KbmCategoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="category_name")
    private String categoryName; // 分类名称
    @TableField(value="access")
    private Integer access; // 访问权限，0-默认，1-自定义
    @TableField(value="upload")
    private Integer upload; // 上传权限，0-不允许，1-默认，2-自定义
    @TableField(value = "enabled")
    private String enabled; // 启停用，1启用0停用
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_id")
    private Long parentId; // 父id
    @TableField(value="parent_name")
    private String parentName; // 父名称
    @TableField(value="inner_code")
    private String innerCode; // 内置编码
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="kbmCategoryAccessService",pidName = "categoryId")
    private List<KbmCategoryAccessEntity> kbmCategoryAccessVos = new ArrayList<>(); // 知识分类访问权限
    @TableField(exist=false)
    @SubEntity(serviceName="kbmCategoryUploadService",pidName = "categoryId")
    private List<KbmCategoryUploadEntity> kbmCategoryUploadVos = new ArrayList<>(); // 知识分类上传权限
    

    /**
     * 分类名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 分类名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 访问权限，0-默认，1-自定义
     */
    public Integer getAccess() {
        return access;
    }

    /**
     * 访问权限，0-默认，1-自定义
     */
    public void setAccess(Integer access) {
        this.access = access;
    }
    /**
     * 上传权限，0-不允许，1-默认，2-自定义
     */
    public Integer getUpload() {
        return upload;
    }

    /**
     * 上传权限，0-不允许，1-默认，2-自定义
     */
    public void setUpload(Integer upload) {
        this.upload = upload;
    }

    public String getEnabled() {
        return enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 父名称
     */
    public String getParentName() {
        return parentName;
    }

    /**
     * 父名称
     */
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
    /**
     * 内置编码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 内置编码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public List<KbmCategoryAccessEntity> getKbmCategoryAccessVos() {
        return kbmCategoryAccessVos;
    }

    public void setKbmCategoryAccessVos(List<KbmCategoryAccessEntity> kbmCategoryAccessVos) {
        this.kbmCategoryAccessVos = kbmCategoryAccessVos;
    }

    public List<KbmCategoryUploadEntity> getKbmCategoryUploadVos() {
        return kbmCategoryUploadVos;
    }

    public void setKbmCategoryUploadVos(List<KbmCategoryUploadEntity> kbmCategoryUploadVos) {
        this.kbmCategoryUploadVos = kbmCategoryUploadVos;
    }
}
