/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.vo.KbmCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"kbmCategory"})
public class KbmCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKbmCategoryService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KbmCategoryVO> saveOrUpdate(@RequestBody KbmCategoryVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KbmCategoryVO> queryDetail(Long id) {
        KbmCategoryEntity entity = (KbmCategoryEntity)((Object)this.service.selectById(id));
        KbmCategoryVO vo = (KbmCategoryVO)BeanMapper.map((Object)((Object)entity), KbmCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KbmCategoryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/enabled"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam boolean enable) {
        KbmCategoryEntity entity = (KbmCategoryEntity)((Object)this.service.selectById(id));
        if (enable) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
            List editList = this.service.queryList(param, false);
            List<KbmCategoryVO> parents = this.service.findParentsById(id);
            for (KbmCategoryVO vo : parents) {
                if (vo.getId().equals(id)) continue;
                if (!"0".equals(vo.getEnabled())) break;
                editList.add(BeanMapper.map((Object)vo, KbmCategoryEntity.class));
            }
            for (KbmCategoryEntity en : editList) {
                en.setEnabled("1");
            }
            this.service.saveOrUpdateBatch(editList, editList.size(), false);
            return CommonResponse.success((String)"\u542f\u7528\u6210\u529f\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
        List editList = this.service.queryList(param, false);
        for (KbmCategoryEntity en : editList) {
            en.setEnabled("0");
        }
        this.service.saveOrUpdateBatch(editList, editList.size(), false);
        return CommonResponse.success((String)"\u505c\u7528\u6210\u529f\uff01");
    }
}

