/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.mapper.KbmCategoryMapper;
import com.ejianc.business.doc.service.IKbmCategoryAccessService;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;
import com.ejianc.business.doc.vo.KbmCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="kbmCategoryService")
public class KbmCategoryServiceImpl
extends BaseServiceImpl<KbmCategoryMapper, KbmCategoryEntity>
implements IKbmCategoryService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IKbmCategoryAccessService accessService;
    @Autowired
    private IKbmCategoryUploadService uploadService;
    @Autowired
    private KbmCategoryMapper kbmCategoryMapper;

    @Override
    public CommonResponse<KbmCategoryVO> saveOrUpdate(KbmCategoryVO saveorUpdateVO) {
        KbmCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            KbmCategoryEntity kbmCategoryEntity = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(saveorUpdateVO.getId()));
            entity = (KbmCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, KbmCategoryEntity.class));
            Integer access = entity.getAccess();
            Integer upload = entity.getUpload();
            if (kbmCategoryEntity.getAccess() != access) {
                if (access == 0) {
                    this.accessService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                } else if (access == 1) {
                    // empty if block
                }
                if (upload == 1) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                }
            }
            if (kbmCategoryEntity.getUpload() != upload) {
                if (upload == 0) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                } else if (upload == 1) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                    QueryParam param = new QueryParam();
                    param.getParams().put("category_id", new Parameter("eq", (Object)entity.getId()));
                    param.getParams().put("dr", new Parameter("eq", (Object)0));
                    List accessEntities = this.accessService.queryList(param, false);
                    List kbmCategoryUploadEntities = BeanMapper.mapList((Iterable)accessEntities, KbmCategoryUploadEntity.class);
                    for (KbmCategoryUploadEntity ku : kbmCategoryUploadEntities) {
                        ku.setId(null);
                    }
                    this.uploadService.saveBatch(kbmCategoryUploadEntities);
                } else if (upload == 2) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                }
            }
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        String orgName = this.sessionManager.getUserContext().getOrgName();
        entity = (KbmCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, KbmCategoryEntity.class));
        entity.setOrgId(orgId);
        entity.setOrgName(orgName);
        entity.setId(IdWorker.getId());
        entity.setEnabled("1");
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            KbmCategoryEntity uniqueBean = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(entity.getParentId()));
            String[] split = uniqueBean.getInnerCode().split("|");
            if (split.length >= 3) {
                throw new BusinessException("\u77e5\u8bc6\u5206\u7c7b\u7ed3\u6784\u6700\u591a\u4e09\u5c42");
            }
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public List<KbmCategoryVO> findParentsById(Long id) {
        KbmCategoryEntity entity = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(id));
        if (entity != null) {
            List<KbmCategoryVO> result = this.kbmCategoryMapper.queryParentsById(entity.getInnerCode());
            return result;
        }
        return null;
    }
}

