package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;
import com.ejianc.business.doc.vo.KbmCategoryAccessVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.doc.mapper.KbmCategoryAccessMapper;
import com.ejianc.business.doc.bean.KbmCategoryAccessEntity;
import com.ejianc.business.doc.service.IKbmCategoryAccessService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 知识分类访问权限
 *
 * @author generator
 */
@Service("kbmCategoryAccessService")
public class KbmCategoryAccessServiceImpl extends BaseServiceImpl<KbmCategoryAccessMapper, KbmCategoryAccessEntity> implements IKbmCategoryAccessService {

    @Autowired
    private IKbmCategoryService kbmCategoryService;
    @Autowired
    private IKbmCategoryUploadService uploadService;

    @Override
    public CommonResponse<String> saveKbmCategoryRole(List<KbmCategoryAccessVO> relationList) {
        List<KbmCategoryAccessEntity> addList = new ArrayList<>();
        //1、判重
        QueryWrapper<KbmCategoryAccessEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
        queryWrapper.eq("dr", 0);
        List<KbmCategoryAccessEntity> list = this.list(queryWrapper);
        Map<Long, KbmCategoryAccessEntity> map = new HashMap<>();
        if (list != null && list.size() > 0) {
            for (KbmCategoryAccessEntity relation : list) {
                map.put(relation.getRoleId(), relation);
            }
        }
        String message = "";
        Map<Long, String> orgMap = new HashMap<>();
        for (KbmCategoryAccessVO vo : relationList) {
            if (map.get(vo.getRoleId()) == null) {
                if (orgMap.get(vo.getRoleOrgId()) != null) {
                    vo.setRoleOrgName(orgMap.get(vo.getRoleOrgId()));
                } else {
                    String orgName = vo.getRoleOrgId().toString();
                    if (vo.getRoleOrgId() != null) {
                        try {
                            JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getRoleOrgId().toString(), "idm-org");
                            if (jArray != null && jArray.size() > 0) {
                                JSONObject json = (JSONObject) jArray.get(0);
                                orgName = json.get("name").toString();
                            }
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                    }
                    vo.setRoleOrgName(orgName);
                    orgMap.put(vo.getRoleOrgId(), orgName);
                }
                addList.add(BeanMapper.map(vo, KbmCategoryAccessEntity.class));
            } else {
                if (message.length() > 0) {
                    message += ("、" + vo.getRoleName());
                } else {
                    message += vo.getRoleName();
                }
            }
        }

        //2、保存
        if (addList.size() > 0) {
            //2.5、如果上传权限也是默认，也要新增
            KbmCategoryEntity kbmCategoryEntity = kbmCategoryService.selectById(relationList.get(0).getCategoryId());
            if (kbmCategoryEntity.getUpload().equals("1")) {
                List<KbmCategoryUploadEntity> uploadEntitys = BeanMapper.mapList(addList, KbmCategoryUploadEntity.class);
                uploadService.saveOrUpdateBatch(uploadEntitys, uploadEntitys.size(), false);
            }

            this.saveOrUpdateBatch(addList, addList.size(), false);
            if (addList.size() != relationList.size()) {
                //有重复数据
                return CommonResponse.success("添加成功,其中以下角色：" + message + "已存在");
            }
        } else {
            return CommonResponse.success("选择的角色都已在该分类下，请重新选择");
        }
        return CommonResponse.success("添加成功");
    }

    @Override
    public CommonResponse<String> deleteKbmCategoryRole(List<KbmCategoryAccessVO> relationList) {
        List<Long> ids = new ArrayList<>();
        for (KbmCategoryAccessVO vo : relationList) {
            ids.add(vo.getId());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        param.getParams().put("dr", new Parameter("eq", 0));
        List<KbmCategoryAccessEntity> accessEntities = this.queryList(param, false);
        KbmCategoryEntity kbmCategoryEntity = kbmCategoryService.selectById(accessEntities.get(0).getCategoryId());
        //上传是默认
        if (kbmCategoryEntity.getUpload().equals("1")) {
            List<Long> uploadRoleIds = new ArrayList<>();//角色
            for (KbmCategoryAccessEntity kca : accessEntities) {
                uploadRoleIds.add(kca.getRoleId());
            }
            uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>()
                    .eq("categoryId", accessEntities.get(0).getCategoryId())
                    .in("roleId", uploadRoleIds));
        }
        this.removeByIds(ids, false);
        return CommonResponse.success("删除成功");
    }
}
