package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.doc.bean.KbmCategoryAccessEntity;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.service.IKbmCategoryAccessService;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;
import com.ejianc.business.doc.vo.KbmCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.doc.mapper.KbmCategoryMapper;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.service.IKbmCategoryService;

import java.util.List;

/**
 * 知识分类
 *
 * @author generator
 */
@Service("kbmCategoryService")
public class KbmCategoryServiceImpl extends BaseServiceImpl<KbmCategoryMapper, KbmCategoryEntity> implements IKbmCategoryService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IKbmCategoryAccessService accessService;
    @Autowired
    private IKbmCategoryUploadService uploadService;
    @Autowired
    private KbmCategoryMapper kbmCategoryMapper;

    @Override
    public CommonResponse<KbmCategoryVO> saveOrUpdate(KbmCategoryVO saveorUpdateVO) {

        KbmCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            KbmCategoryEntity kbmCategoryEntity = kbmCategoryMapper.selectById(saveorUpdateVO.getId());
            entity = BeanMapper.map(saveorUpdateVO, KbmCategoryEntity.class);
            String access = entity.getAccess();
            String upload = entity.getUpload();
            // 访问权限，0-默认，1-自定义
            if (kbmCategoryEntity.getAccess() != access) {//修改了访问权限
                if (access.equals("0")) {
                    //删除访问权限表数据
                    accessService.remove(new QueryWrapper<KbmCategoryAccessEntity>().eq("category_id", entity.getId()));
                } else if (access.equals("1")) {

                }
                if (upload.equals("1")) {
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                }
            }
            // 上传权限，0-不允许，1-默认，2-自定义
            if (kbmCategoryEntity.getUpload() != upload) {//修改了上传权限
                if (upload.equals("0")) {
                    //删除上传权限表数据
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                } else if (upload.equals("1")) {
                    //和访问权限保持一致
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                    QueryParam param = new QueryParam();
                    param.getParams().put("category_id", new Parameter(QueryParam.EQ, entity.getId()));
                    param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
                    List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(param, false);
                    List<KbmCategoryUploadEntity> kbmCategoryUploadEntities = BeanMapper.mapList(accessEntities, KbmCategoryUploadEntity.class);
                    for (KbmCategoryUploadEntity ku : kbmCategoryUploadEntities) {
                        ku.setId(null);
                    }
                    uploadService.saveBatch(kbmCategoryUploadEntities);
                } else if (upload.equals("2")) {
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                }
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            Long orgId = InvocationInfoProxy.getOrgId();
            String orgName = sessionManager.getUserContext().getOrgName();
            entity = BeanMapper.map(saveorUpdateVO, KbmCategoryEntity.class);
            entity.setOrgId(orgId);
            entity.setOrgName(orgName);
            entity.setId(IdWorker.getId());
            entity.setEnabled("1");
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                KbmCategoryEntity uniqueBean = kbmCategoryMapper.selectById(entity.getParentId());
                String[] split = uniqueBean.getInnerCode().split("|");
                if (split.length >= 3) {
                    throw new BusinessException("知识分类结构最多三层");
                }
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public List<KbmCategoryVO> findParentsById(Long id) {
        KbmCategoryEntity entity = kbmCategoryMapper.selectById(id);
        if(entity != null) {
            List<KbmCategoryVO> result = kbmCategoryMapper.queryParentsById(entity.getInnerCode());
            return result;
        }
        return null;
    }
}
