package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.KbmCategoryAccessEntity;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.service.IKbmCategoryAccessService;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.vo.KbmCategoryUploadVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.doc.mapper.KbmCategoryUploadMapper;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 知识分类上传权限
 *
 * @author generator
 */
@Service("kbmCategoryUploadService")
public class KbmCategoryUploadServiceImpl extends BaseServiceImpl<KbmCategoryUploadMapper, KbmCategoryUploadEntity> implements IKbmCategoryUploadService {
    @Autowired
    private IKbmCategoryService kbmCategoryService;
    @Autowired
    private IKbmCategoryAccessService accessService;

    @Override
    public CommonResponse<String> saveKbmCategoryRole(List<KbmCategoryUploadVO> relationList) {
        List<KbmCategoryUploadEntity> addList = new ArrayList<>();
        //1、判重
        QueryWrapper<KbmCategoryUploadEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
        queryWrapper.eq("dr", 0);
        List<KbmCategoryUploadEntity> list = this.list(queryWrapper);
        Map<Long, KbmCategoryUploadEntity> map = new HashMap<>();
        if (list != null && list.size() > 0) {
            for (KbmCategoryUploadEntity relation : list) {
                map.put(relation.getRoleId(), relation);
            }
        }
        String message = "";
        Map<Long, String> orgMap = new HashMap<>();
        for (KbmCategoryUploadVO vo : relationList) {
            if (map.get(vo.getRoleId()) == null) {
                if (orgMap.get(vo.getRoleOrgId()) != null) {
                    vo.setRoleOrgName(orgMap.get(vo.getRoleOrgId()));
                } else {
                    String orgName = vo.getRoleOrgId().toString();
                    if (vo.getRoleOrgId() != null) {
                        try {
                            JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getRoleOrgId().toString(), "idm-org");
                            if (jArray != null && jArray.size() > 0) {
                                JSONObject json = (JSONObject) jArray.get(0);
                                orgName = json.get("name").toString();
                            }
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                    }
                    vo.setRoleOrgName(orgName);
                    orgMap.put(vo.getRoleOrgId(), orgName);
                }
                addList.add(BeanMapper.map(vo, KbmCategoryUploadEntity.class));
            } else {
                if (message.length() > 0) {
                    message += ("、" + vo.getRoleName());
                } else {
                    message += vo.getRoleName();
                }
            }
        }

        //2、保存
        if (addList.size() > 0) {
            //2.5、如果上传权限也是默认,并且新增的角色没有浏览权限
            KbmCategoryEntity kbmCategoryEntity = kbmCategoryService.selectById(relationList.get(0).getCategoryId());
            if (kbmCategoryEntity.getUpload().equals("1")) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("category_id", new Parameter("eq", relationList.get(0).getCategoryId()));
                queryParam.getParams().put("dr", new Parameter("eq", 0));
                List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(queryParam, false);
                List<Long> roleIds = new ArrayList<>();
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    roleIds.add(ka.getRoleId());
                }
                List<KbmCategoryAccessEntity> accessAddList = new ArrayList<>();
                for (KbmCategoryUploadEntity ku : addList) {
                    if (!roleIds.contains(ku.getRoleId())) {
                        accessAddList.add(BeanMapper.map(ku, KbmCategoryAccessEntity.class));
                    }
                }
                if (accessAddList.size() > 0) {
                    accessService.saveOrUpdateBatch(accessAddList, accessAddList.size(), false);
                }
            }

            this.saveOrUpdateBatch(addList, addList.size(), false);
            if (addList.size() != relationList.size()) {
                //有重复数据
                return CommonResponse.success("添加成功,其中以下角色：" + message + "已存在");
            }
        } else {
            return CommonResponse.success("选择的角色都已在该分类下，请重新选择");
        }
        return CommonResponse.success("添加成功");
    }

    @Override
    public CommonResponse<String> deleteKbmCategoryRole(List<KbmCategoryUploadVO> relationList) {
        List<Long> ids = new ArrayList<>();
        for (KbmCategoryUploadVO vo : relationList) {
            ids.add(vo.getId());
        }

        this.removeByIds(ids, false);
        return CommonResponse.success("删除成功");
    }
}
