package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.mapper.DocCategoryMapper;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 文档分类
 * 
 * @author generator
 * 
 */
@Service("docCategoryService")
public class DocCategoryServiceImpl extends BaseServiceImpl<DocCategoryMapper, DocCategoryEntity> implements IDocCategoryService{

	@Autowired
	private DocCategoryMapper docCategoryMapper;
	
	@Override
	public List<DocCategoryVO> findParentsById(Long cateId) {
		DocCategoryEntity entity = docCategoryMapper.selectById(cateId);
		if(entity != null) {
			List<DocCategoryVO> result = docCategoryMapper.queryParentsById(entity.getInnerCode());
			return result;
		}
		return null;
	}

	@Override
	public List<DocCategoryEntity> findChildrenByPid(Long categoryId) {
		DocCategoryEntity entity = docCategoryMapper.selectById(categoryId);
		QueryWrapper<DocCategoryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
		queryWrapper.likeRight("inner_code", entity.getInnerCode());

		return baseMapper.selectList(queryWrapper);
	}
}
