package com.ejianc.business.doc.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/12/14 9:32
 */
@RestController
@RequestMapping(value = "/api/projectDoc/")
public class ProjectDocApi {

    @Autowired
    private IProjectDocService projectDocService;

    @PostMapping(value = "delByFileIds")
    public CommonResponse<String> delProjectDocsByFileIds(@RequestBody List<Long> fileIds) {
        if(CollectionUtils.isNotEmpty(fileIds)) {
            QueryParam query = new QueryParam();
            query.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
            query.getParams().put("fileId", new Parameter(QueryParam.IN, fileIds));

            List<ProjectDocEntity> docs = projectDocService.queryList(query, false);
            if(CollectionUtils.isNotEmpty(docs)) {
                projectDocService.delArchiveDocs(docs.stream().map(doc -> doc.getId()).collect(Collectors.toList()), false);
            }
        }

        return CommonResponse.success("操作成功！");
    }

}
