package com.ejianc.business.doc.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.bean.KbmCollectEntity;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.service.IKbmCollectService;
import com.ejianc.business.doc.vo.KbmCollectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 知识库收藏夹
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("kbmCollect")
public class KbmCollectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKbmCollectService kbmCollectService;

    @Autowired
    private IKbmCollectDetailService kbmCollectDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KbmCollectVO> saveOrUpdate(@RequestBody KbmCollectVO saveorUpdateVO) {
    	KbmCollectEntity entity = BeanMapper.map(saveorUpdateVO, KbmCollectEntity.class);
        kbmCollectService.saveOrUpdate(entity);
    	KbmCollectVO vo = BeanMapper.map(entity, KbmCollectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmCollectVO> queryDetail(Long id) {
    	KbmCollectVO vo =  kbmCollectService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(Long id) {
        kbmCollectService.delete(id);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KbmCollectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

        IPage<KbmCollectEntity> page = kbmCollectService.queryPage(param,false);
        IPage<KbmCollectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<KbmCollectVO> collectVOList = BeanMapper.mapList(page.getRecords(), KbmCollectVO.class);
        if(CollectionUtils.isNotEmpty(collectVOList)){
            for(KbmCollectVO kbmCollectVO : collectVOList){
                LambdaQueryWrapper<KbmCollectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(KbmCollectDetailEntity::getKbmId, kbmCollectVO.getId());
                List<KbmCollectDetailEntity> entityList = kbmCollectDetailService.list(queryWrapper);
                kbmCollectVO.setDetailNum(CollectionUtils.isNotEmpty(entityList) ? entityList.size() : 0);
            }
        }
  		pageData.setRecords(collectVOList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryListNormal 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListNormal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KbmCollectEntity>> queryListNormal() {
        List<KbmCollectEntity>  collectVOList = kbmCollectService.queryListNormal();
        return CommonResponse.success("查询列表数据成功！", collectVOList);
    }

    /**
     * @Description collectKbm 收藏
     * @param collectId
     * @param kbmId
     */
    @RequestMapping(value = "/collectKbm", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> collectKbm(Long collectId, Long kbmId) {
        kbmCollectDetailService.collectKbm(collectId, kbmId);
        return CommonResponse.success("查询详情数据成功！");
    }


    /**
     * @Description cancelCollectKbm 取消收藏
     * @param kbmId
     */
    @RequestMapping(value = "/cancelCollectKbm", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> cancelCollectKbm(Long kbmId) {
        kbmCollectDetailService.cancelCollectKbm(kbmId);
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @Description queryMyCltNum 查询我的收藏个数
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Integer>
     */
    @RequestMapping(value = "/queryMyCltNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> queryMyCltNum() {
        LambdaQueryWrapper<KbmCollectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(KbmCollectDetailEntity::getCreateUserId, InvocationInfoProxy.getUserid());
        List<KbmCollectDetailEntity> list = kbmCollectDetailService.list(queryWrapper);
        return CommonResponse.success("查询列表数据成功！", CollectionUtils.isNotEmpty(list) ? list.size() : 0);
    }

}
