package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.doc.bean.KbmCollectEntity;
import com.ejianc.business.doc.mapper.KbmCollectMapper;
import com.ejianc.business.doc.service.IKbmCollectService;
import com.ejianc.business.doc.vo.KbmCollectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 知识库收藏夹
 *
 * @author generator
 *
 */
@Service("kbmCollectService")
public class KbmCollectServiceImpl extends BaseServiceImpl<KbmCollectMapper, KbmCollectEntity> implements IKbmCollectService{

    @Override
    public KbmCollectVO queryDetail(Long id) {
       KbmCollectEntity kbmCollectEntity =  selectById(id);
       return BeanMapper.map(kbmCollectEntity, KbmCollectVO.class);
    }

    @Override
    public void delete(Long id) {
        super.removeById(id, false);
    }

    @Override
    public List<KbmCollectEntity> queryListNormal() {
        LambdaQueryWrapper<KbmCollectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(KbmCollectEntity::getCreateUserId, InvocationInfoProxy.getUserid());
        return list(queryWrapper);
    }
}
