package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.bean.KbmRecordEntity;
import com.ejianc.business.doc.enums.KbmBillStateEnum;
import com.ejianc.business.doc.enums.KbmRecordTypeEnum;
import com.ejianc.business.doc.enums.KbmSourceEnum;
import com.ejianc.business.doc.mapper.KbmMapper;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.service.IKbmRecordService;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.business.doc.vo.KbmEsVO;
import com.ejianc.business.doc.vo.KbmVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 知识内容
 *
 * @author generator
 *
 */
@Service("kbmService")
public class KbmServiceImpl extends BaseServiceImpl<KbmMapper, KbmEntity> implements IKbmService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final static String INDEX_NAME = "ejc_kbm_es";

    private final static Integer QUERY_TIMEOUT = 60;

    @Autowired
    private IKbmRecordService kbmRecordService;

    @Autowired
    private IKbmCollectDetailService kbmCollectDetailService;

    @Autowired
    private IKbmCategoryService kbmCategoryService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IUserApi userApi;

    @Autowired(required=false)
    private RestHighLevelClient client;

    @Override
    public KbmVO saveOrUpdate(KbmVO kbmVO) {
        KbmEntity entity;
        KbmVO newVO;
        kbmVO.setCreateUserName(getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
        if(kbmVO.getCategoryId() != null){
           KbmCategoryEntity categoryEntity =  kbmCategoryService.getById(kbmVO.getCategoryId());
           kbmVO.setCategoryInnerCode(categoryEntity.getInnerCode());
           kbmVO.setCategoryName(categoryEntity.getCategoryName());
        }
        if(KbmSourceEnum.企业文件.getCode().equals(kbmVO.getSource()) ){
            kbmVO.setBillState(KbmBillStateEnum.已发布.getCode());
            entity = BeanMapper.map(kbmVO, KbmEntity.class);
            saveOrUpdate(entity, false);
            newVO =  insertOrUpdateEs(entity.getId());
        }else {
            kbmVO.setBillState(KbmBillStateEnum.暂存.getCode());
            entity = BeanMapper.map(kbmVO, KbmEntity.class);
            saveOrUpdate(entity, false);
            newVO =  fullFileData(entity.getId());
        }
        entity.setFileNum(newVO.getFileNum());
        saveOrUpdate(entity, false);
        return newVO;
    }

    @Override
    public void delete(List<Long> idList) {
        if(CollectionUtils.isEmpty(idList)){
            throw new BusinessException("所选Id为空");
        }
        removeByIds(idList, false);
        deleteEs(idList);
        //删除日志表
        LambdaQueryWrapper<KbmRecordEntity> wrapper = new LambdaQueryWrapper();
        wrapper.in(KbmRecordEntity::getKbmId, idList);
        kbmRecordService.remove(wrapper, false);
    }

    @Override
    public KbmVO push(Long id) {
        KbmEntity kbmEntity = selectById(id);
        kbmEntity.setBillState(KbmBillStateEnum.已发布.getCode());
        saveOrUpdate(kbmEntity, false);
        return insertOrUpdateEs(id);
    }

    @Override
    public KbmVO back(Long id) {
        KbmEntity kbmEntity = selectById(id);
        KbmVO newVO = fullFileData(id);
        kbmEntity.setBillState(KbmBillStateEnum.暂存.getCode());
        kbmEntity.setFileNum(newVO.getFileNum());
        saveOrUpdate(kbmEntity, false);
        List<Long> pkList = new ArrayList<>();
        pkList.add(id);
        deleteEs(pkList);
        return newVO;
    }

    @Override
    public KbmVO scanDetailCenter(Long id) {
        KbmEntity kbmEntity = selectById(id);
        if(kbmEntity == null){
            throw new BusinessException("单据已不存在！");
        }
        CommonResponse<Boolean> response = kbmCategoryService.kbmAccess(InvocationInfoProxy.getUserid(), kbmEntity.getCategoryId());
        if(!response.isSuccess() || !response.getData()){
            throw new BusinessException("无该单据访问权限！");
        }
        addScanNum(kbmEntity);

        KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
        kbmRecordEntity.setKbmId(id);
        kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
        kbmRecordEntity.setCreateUserName(getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
        kbmRecordEntity.setType(KbmRecordTypeEnum.查看文件.getCode());
        kbmRecordService.save(kbmRecordEntity);

        return fullCollectState(BeanMapper.map(kbmEntity, KbmVO.class));
    }

    private KbmVO fullCollectState(KbmVO kbmVO) {
        LambdaQueryWrapper<KbmCollectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(KbmCollectDetailEntity::getKbmId, kbmVO.getId());
        queryWrapper.eq(KbmCollectDetailEntity::getCreateUserId, InvocationInfoProxy.getUserid());
        List<KbmCollectDetailEntity> collectDetailEntities = kbmCollectDetailService.list(queryWrapper);
        kbmVO.setCollectState(CollectionUtils.isEmpty(collectDetailEntities) ? 0 : 1);
        return kbmVO;
    }

    @Override
    public void scanFile(Long kbmId, String fileId) {
        Long fileIdLong = Long.valueOf(fileId);
        CommonResponse<AttachmentVO> response = attachmentApi.queryAttachmentDetail(fileIdLong);
        if(response.isSuccess() && response.getData() != null){
            AttachmentVO attachmentVO = response.getData();
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(kbmId);
            kbmRecordEntity.setFileId(fileIdLong);
            kbmRecordEntity.setFileName(attachmentVO.getFileName());
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.浏览附件.getCode());
            kbmRecordService.save(kbmRecordEntity);
        }
    }

    @Override
    public void batchDownloadFile(Long kbmId, String fileIds) {
        String[] fileIdArr = fileIds.split(",");
        for(String fileIdStr : fileIdArr) {
            downloadFile(kbmId, fileIdStr);
        }
    }

    @Override
    public void downloadFile(Long kbmId, String fileId) {
        Long fileIdLong = Long.valueOf(fileId);
        CommonResponse<AttachmentVO> response = attachmentApi.queryAttachmentDetail(fileIdLong);
        if (response.isSuccess() && response.getData() != null) {
            AttachmentVO attachmentVO = response.getData();
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(kbmId);
            kbmRecordEntity.setFileId(fileIdLong);
            kbmRecordEntity.setFileName(attachmentVO.getFileName());
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.下载.getCode());
            kbmRecordService.save(kbmRecordEntity);
        }
    }

    @Override
    public void uploadFile(Long kbmId) {
        if (null != kbmId) {
            KbmVO newVO;
            KbmEntity kbmEntity = selectById(kbmId);
            if(KbmSourceEnum.企业文件.getCode().equals(kbmEntity.getSource()) ){
                newVO =  insertOrUpdateEs(kbmEntity.getId());
            }else{
                newVO =  fullFileData(kbmEntity.getId());
            }
            kbmEntity.setFileNum(newVO.getFileNum());
            saveOrUpdate(kbmEntity, false);
        }
    }

    @Override
    public void deleteFile(Long kbmId) {
        if (null != kbmId) {
            KbmVO newVO;
            KbmEntity kbmEntity = selectById(kbmId);
            if(KbmSourceEnum.企业文件.getCode().equals(kbmEntity.getSource()) ){
                newVO =  insertOrUpdateEs(kbmEntity.getId());
            }else{
                newVO =  fullFileData(kbmEntity.getId());
            }
            kbmEntity.setFileNum(newVO.getFileNum());
            saveOrUpdate(kbmEntity, false);
        }
    }

    @Override
    public void updateColletNum(Long kbmId, boolean isAdd) {
        KbmEntity kbmEntity = selectById(kbmId);
        BigDecimal collectNum = kbmEntity.getCollectNum();
        if(isAdd){
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(kbmId);
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.收藏.getCode());
            kbmRecordService.save(kbmRecordEntity);
            kbmEntity.setCollectNum(null != collectNum ? collectNum.add(BigDecimal.ONE) : BigDecimal.ONE);
        }else{
            kbmEntity.setCollectNum(collectNum.subtract(BigDecimal.ONE));
        }
        saveOrUpdate(kbmEntity);
        insertOrUpdateEs(kbmEntity.getId());
    }

    @Override
    public KbmEsVO queryListEs(Map<String, String> params) {
        KbmEsVO kbmEsVO = new KbmEsVO();
        IPage<KbmVO> page = new Page<>();
        List<Long> categoryList = new ArrayList<>(); //构造<分类，数量>用的分类主键集合
        Integer pageSize = Integer.valueOf(params.get("pageSize"));
        Integer pageNumber = Integer.valueOf(params.get("pageIndex"));
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        Integer queryType = params.get("queryType") != null ? Integer.valueOf(params.get("queryType")) : -1; //1-搜索 2-点分类查询
        Integer filterType = params.get("filterType") != null ? Integer.valueOf(params.get("filterType")) : -1;
        String searchText = params.get("searchText");
        List<Long> longList = new ArrayList<>();
        if(2 == queryType){
            if(params.get("categoryId") != null ){
                String categoryIdStr =  params.get("categoryId");
                if(categoryIdStr.contains(",")){
                    String[] arr = categoryIdStr.split(",");
                    for(String str : arr){
                        longList.add(Long.valueOf(str));
                    }
                }else{
                    CommonResponse<List<Long>> response =  kbmCategoryService.userFindChildrenId(Long.valueOf(categoryIdStr));
                    if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                        longList = response.getData();
                    }
                }
                boolQuery.must(QueryBuilders.termsQuery("categoryId", longList));
            }
        }else{
            CommonResponse<List<Long>> response =  kbmCategoryService.userAccessQueryList(InvocationInfoProxy.getUserid());
            if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                longList = response.getData();
                boolQuery.must(QueryBuilders.termsQuery("categoryId", longList));
            }
        }

        if(StringUtils.isNotBlank(searchText)){
            if(0 == filterType){
                QueryBuilder qb1 = QueryBuilders.matchQuery("title", searchText);
                QueryBuilder qb2 = QueryBuilders.matchQuery("fileName", searchText);
                QueryBuilder qb3 = QueryBuilders.matchQuery("createUserName", searchText);
                QueryBuilder qb4 = QueryBuilders.matchQuery("kbmDescribe", searchText);
                boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4));
            }else if(1 == filterType){
                boolQuery.must(QueryBuilders.matchQuery("title", searchText));
            }else if(2 == filterType){
                boolQuery.must(QueryBuilders.matchQuery("createUserName", searchText));
            }else if(3 == filterType){
                boolQuery.must(QueryBuilders.matchQuery("fileName", searchText));
            }
        }

        sourceBuilder.from(pageNumber <= 0 ? 0:(pageNumber-1)*pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
//		sourceBuilder.sort("code", SortOrder.ASC);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        try {
            page = kbmEsPage(searchRequest);
        } catch (IOException e) {
            try { //重试一次
                page = kbmEsPage(searchRequest);
            } catch (IOException e1) {
                logger.error(e1.getMessage());
                throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG："+e1.getMessage());
            }
        }
        page.setCurrent(pageNumber);
        kbmEsVO.setPage(page);

        fullCategoryData(kbmEsVO, longList, queryType);
        return kbmEsVO;
    }

    private void fullCategoryData(KbmEsVO kbmEsVO, List<Long> longList,  Integer queryType){
        IPage<KbmVO> page = kbmEsVO.getPage();
        List<KbmVO> kbmVOList = page.getRecords();
        if(1 == queryType){
            longList = kbmVOList.stream().map(KbmVO::getCategoryId).collect(Collectors.toList());
        }

        Map<Long, Integer> map = new HashMap<>();
        for(Long pk : longList){
            if(!map.containsKey(pk)){
                map.put(pk, 0);
            }
        }

        for(KbmVO kbmVO : kbmVOList){
            if(map.containsKey(kbmVO.getCategoryId())){
                map.put(kbmVO.getCategoryId(), map.get(kbmVO.getCategoryId()) + 1);
            }
        }

        CommonResponse<JSONObject> response = kbmCategoryService.accessToTreeList(map);
        if (response.isSuccess()) {
            kbmEsVO.setCategoryData(response.getData());
        }
    }

    private IPage<KbmVO> kbmEsPage(SearchRequest searchRequest) throws IOException {
        IPage<KbmVO> page = new Page<>();
        List<KbmVO> list = new ArrayList<>();
        SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            KbmVO kbmVO = JSON.parseObject(sourceAsString, KbmVO.class);
            kbmVO.setId(Long.valueOf(hit.getId()));
            list.add(kbmVO);
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    private void addScanNum(KbmEntity kbmEntity){
        BigDecimal scanNum = kbmEntity.getScanNum();
        kbmEntity.setScanNum(null != scanNum ? scanNum.add(BigDecimal.ONE) : BigDecimal.ONE);
        saveOrUpdate(kbmEntity, false);
        insertOrUpdateEs(kbmEntity.getId());
    }

    private String getUserNameById(String userId){
        String[] arr = new String[]{userId};
        CommonResponse<List<UserVO>> response = userApi.queryListByIds(arr);
        if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
            return response.getData().get(0).getUserName();
        }
        return null;
    }

    private KbmVO fullFileData(Long id){
        KbmEntity kbmEntity = selectById(id);
        KbmVO kbmVO = BeanMapper.map(kbmEntity, KbmVO.class);
        CommonResponse<List<AttachmentVO>> response =  attachmentApi.queryListBySourceId(id, null, null, null);
        if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
            List<AttachmentVO> attachmentVOList = response.getData();
            List<String> nameList = attachmentVOList.stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
            kbmVO.setFileNum(new BigDecimal(attachmentVOList.size()));
            kbmVO.setFileName(StringUtils.join(nameList, "@"));
        }
        return  kbmVO;
    }

    private KbmVO insertOrUpdateEs(Long id){
        KbmVO kbmVO =  fullFileData(id);
        BulkRequest bulkRequest = new BulkRequest();
        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put("tenantId", InvocationInfoProxy.getTenantid());
        dataMap.put("categoryId", kbmVO.getCategoryId());
        dataMap.put("categoryInnerCode", kbmVO.getCategoryInnerCode());
        dataMap.put("title", kbmVO.getTitle());
        dataMap.put("createUserName", kbmVO.getCreateUserName());
        dataMap.put("categoryName", kbmVO.getCategoryName());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        dataMap.put("createTime", format.format(kbmVO.getCreateTime()));
        dataMap.put("kbmDescribe", kbmVO.getKbmDescribe());
        dataMap.put("fileName", kbmVO.getFileName());
        dataMap.put("scanNum", kbmVO.getScanNum());
        dataMap.put("collectNum", kbmVO.getCollectNum());
        dataMap.put("fileNum", kbmVO.getFileNum());

        IndexRequest indexRequest = new IndexRequest(INDEX_NAME);
        indexRequest.id(String.valueOf(kbmVO.getId()));
        indexRequest.source(dataMap, XContentType.JSON);
        bulkRequest.add(indexRequest);

        try {
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            logger.error(e.getMessage());
        }

        return kbmVO;
    }

    private void deleteEs(List<Long> idList){
        DeleteRequest deleteRequest = new DeleteRequest(INDEX_NAME);
        for(Long id : idList){
            deleteRequest.id(String.valueOf(id));
            try {
                client.delete(deleteRequest, RequestOptions.DEFAULT);
            } catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }
}
