/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.bean.KbmCollectEntity;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.mapper.KbmCollectDetailMapper;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.service.IKbmCollectService;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="kbmCollectDetailService")
public class KbmCollectDetailServiceImpl
extends BaseServiceImpl<KbmCollectDetailMapper, KbmCollectDetailEntity>
implements IKbmCollectDetailService {
    @Autowired
    private IKbmCollectService kbmCollectService;
    @Autowired
    private IKbmService kbmService;

    @Override
    public void collectKbm(Long collectId, Long kbmId) {
        KbmCollectEntity collectEntity = (KbmCollectEntity)((Object)this.kbmCollectService.selectById(collectId));
        collectEntity.setLastTime(new Date());
        this.kbmCollectService.saveOrUpdate((Object)collectEntity, false);
        this.kbmService.updateColletNum(kbmId, true);
        KbmEntity kbmEntity = (KbmEntity)((Object)this.kbmService.selectById(kbmId));
        KbmCollectDetailEntity detailEntity = new KbmCollectDetailEntity();
        this.copyVO(detailEntity, kbmEntity);
        detailEntity.setCollectId(collectId);
        detailEntity.setCreateUserId(InvocationInfoProxy.getUserid());
        this.save((Object)detailEntity);
    }

    @Override
    public void cancelCollectKbm(Long kbmId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(KbmCollectDetailEntity::getKbmId, (Object)kbmId);
        updateWrapper.eq(KbmCollectDetailEntity::getCreateUserId, (Object)InvocationInfoProxy.getUserid());
        this.remove((Wrapper)updateWrapper);
        this.kbmService.updateColletNum(kbmId, false);
    }

    private void copyVO(KbmCollectDetailEntity detailEntity, KbmEntity kbmEntity) {
        detailEntity.setKbmId(kbmEntity.getId());
        detailEntity.setOrgId(kbmEntity.getOrgId());
        detailEntity.setOrgName(kbmEntity.getOrgName());
        detailEntity.setCategoryId(kbmEntity.getCategoryId());
        detailEntity.setCategoryName(kbmEntity.getCategoryName());
        detailEntity.setTitle(kbmEntity.getTitle());
        detailEntity.setKbmDescribe(kbmEntity.getKbmDescribe());
        detailEntity.setSource(kbmEntity.getSource());
        detailEntity.setScanNum(kbmEntity.getScanNum());
        detailEntity.setCollectNum(kbmEntity.getCollectNum());
        detailEntity.setFileNum(kbmEntity.getFileNum());
    }
}

