/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.doc.bean.KbmCategoryAccessEntity;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.mapper.KbmCategoryMapper;
import com.ejianc.business.doc.service.IKbmCategoryAccessService;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;
import com.ejianc.business.doc.vo.KbmCategoryVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="kbmCategoryService")
public class KbmCategoryServiceImpl
extends BaseServiceImpl<KbmCategoryMapper, KbmCategoryEntity>
implements IKbmCategoryService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IKbmCategoryAccessService accessService;
    @Autowired
    private IKbmCategoryUploadService uploadService;
    @Autowired
    private KbmCategoryMapper kbmCategoryMapper;
    @Autowired
    private IRoleApi roleApi;

    @Override
    public CommonResponse<KbmCategoryVO> saveOrUpdate(KbmCategoryVO saveorUpdateVO) {
        KbmCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            String access = saveorUpdateVO.getAccess();
            String upload = saveorUpdateVO.getUpload();
            KbmCategoryEntity kbmCategoryEntity = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(saveorUpdateVO.getId()));
            entity = (KbmCategoryEntity)((Object)BeanMapper.map((Object)((Object)kbmCategoryEntity), KbmCategoryEntity.class));
            if (!kbmCategoryEntity.getAccess().equals(access)) {
                if (access.equals("0")) {
                    this.accessService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                } else if (access.equals("1")) {
                    // empty if block
                }
                if (upload.equals("1")) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                }
            }
            if (!kbmCategoryEntity.getUpload().equals(upload)) {
                if (upload.equals("0")) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                } else if (upload.equals("1")) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                    QueryParam param = new QueryParam();
                    param.getParams().put("category_id", new Parameter("eq", (Object)entity.getId()));
                    param.getParams().put("dr", new Parameter("eq", (Object)0));
                    List accessEntities = this.accessService.queryList(param, false);
                    List kbmCategoryUploadEntities = BeanMapper.mapList((Iterable)accessEntities, KbmCategoryUploadEntity.class);
                    for (KbmCategoryUploadEntity ku : kbmCategoryUploadEntities) {
                        ku.setId(null);
                    }
                    this.uploadService.saveBatch(kbmCategoryUploadEntities);
                } else if (upload.equals("2")) {
                    this.uploadService.remove((Wrapper)new QueryWrapper().eq((Object)"category_id", (Object)entity.getId()));
                }
            }
            entity.setCategoryName(saveorUpdateVO.getCategoryName());
            entity.setAccess(saveorUpdateVO.getAccess());
            entity.setUpload(saveorUpdateVO.getUpload());
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        String orgName = this.sessionManager.getUserContext().getOrgName();
        entity = (KbmCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, KbmCategoryEntity.class));
        entity.setOrgId(orgId);
        entity.setOrgName(orgName);
        entity.setId(IdWorker.getId());
        entity.setEnabled("1");
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            KbmCategoryEntity uniqueBean = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(entity.getParentId()));
            String[] split = uniqueBean.getInnerCode().split("\\|");
            if (split.length >= 3) {
                throw new BusinessException("\u77e5\u8bc6\u5206\u7c7b\u7ed3\u6784\u6700\u591a\u4e09\u5c42");
            }
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public List<KbmCategoryVO> findParentsById(Long id) {
        KbmCategoryEntity entity = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(id));
        if (entity != null) {
            List<KbmCategoryVO> result = this.kbmCategoryMapper.queryParentsById(entity.getInnerCode());
            return result;
        }
        return null;
    }

    @Override
    public CommonResponse<JSONObject> userTreeList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        List list = super.queryList(param, false);
        JSONObject jsonObject = new JSONObject();
        if (list == null || list.size() < 1) {
            jsonObject.put("data", (Object)list);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
        }
        ArrayList<Long> allList = new ArrayList<Long>();
        for (KbmCategoryEntity kc : list) {
            if (!kc.getAccess().equals("0")) continue;
            allList.add(kc.getId());
        }
        List userOrgIds = new ArrayList();
        CommonResponse commonResponse = this.roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        userOrgIds = (List)commonResponse.getData();
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter("eq", (Object)0));
            qp.getParams().put("role_id", new Parameter("in", userOrgIds));
            List accessEntities = this.accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                HashSet<Long> categoryIds = new HashSet<Long>();
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }
        List<KbmCategoryVO> kbmCategoryVOS = this.supplementTree(list, allList, 0);
        List resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<List<Long>> userFindChildrenId(Long id) {
        KbmCategoryEntity entity = (KbmCategoryEntity)((Object)this.kbmCategoryMapper.selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List editList = super.queryList(param, false);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        List userOrgIds = new ArrayList();
        CommonResponse commonResponse = this.roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        userOrgIds = (List)commonResponse.getData();
        HashSet<Long> categoryIds = new HashSet<Long>();
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter("eq", (Object)0));
            qp.getParams().put("role_id", new Parameter("in", userOrgIds));
            List accessEntities = this.accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
            }
        }
        for (KbmCategoryEntity kc : editList) {
            if (kc.getAccess().equals("0")) {
                list.add(kc.getId());
                continue;
            }
            if (!categoryIds.contains(kc.getId())) continue;
            list.add(kc.getId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @Override
    public CommonResponse<JSONObject> userUploadTreeList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        List list = super.queryList(param, false);
        JSONObject jsonObject = new JSONObject();
        if (list == null || list.size() < 1) {
            jsonObject.put("data", (Object)list);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
        }
        ArrayList<Long> allList = new ArrayList<Long>();
        List userOrgIds = new ArrayList();
        CommonResponse commonResponse = this.roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        userOrgIds = (List)commonResponse.getData();
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter("eq", (Object)0));
            qp.getParams().put("role_id", new Parameter("in", userOrgIds));
            List uploadEntities = this.uploadService.queryList(qp, false);
            if (uploadEntities != null && uploadEntities.size() > 0) {
                HashSet<Long> categoryIds = new HashSet<Long>();
                for (KbmCategoryUploadEntity ka : uploadEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }
        List<KbmCategoryVO> kbmCategoryVOS = this.supplementTree(list, allList, 1);
        List resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<JSONObject> adminTreeList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        List list = super.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<List<Long>> adminFindChildrenId(Long id) {
        KbmCategoryEntity entity = (KbmCategoryEntity)((Object)super.selectById((Serializable)id));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List editList = super.queryList(param, false);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        for (KbmCategoryEntity en : editList) {
            list.add(en.getId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @Override
    public CommonResponse<Boolean> kbmAccess(Long userId, Long categoryId) {
        KbmCategoryEntity kbmCategoryEntity = (KbmCategoryEntity)((Object)super.selectById((Serializable)categoryId));
        if (kbmCategoryEntity.getAccess().equals("0")) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u6210\u529f\uff01", (Object)true);
        }
        QueryParam param = new QueryParam();
        param.getParams().put("category_id", new Parameter("eq", (Object)categoryId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List accessEntities = this.accessService.queryList(param, false);
        if (accessEntities == null || accessEntities.size() < 1) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u6210\u529f\uff01", (Object)false);
        }
        if (userId == null || userId <= 0L) {
            userId = InvocationInfoProxy.getUserid();
        }
        List userOrgIds = new ArrayList();
        CommonResponse commonResponse = this.roleApi.queryRoleIdsByUserId(userId);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        userOrgIds = (List)commonResponse.getData();
        for (KbmCategoryAccessEntity kca : accessEntities) {
            if (!userOrgIds.contains(kca.getRoleId())) continue;
            return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u6210\u529f\uff01", (Object)true);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u6210\u529f\uff01", (Object)false);
    }

    @Override
    public CommonResponse<List<Long>> userAccessQueryList(Long userId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        List list = super.queryList(param, false);
        ArrayList<Long> allList = new ArrayList<Long>();
        if (list == null || list.size() < 1) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", allList);
        }
        for (KbmCategoryEntity kc : list) {
            if (!kc.getAccess().equals("0")) continue;
            allList.add(kc.getId());
        }
        if (userId == null || userId <= 0L) {
            userId = InvocationInfoProxy.getUserid();
        }
        List userOrgIds = new ArrayList();
        CommonResponse commonResponse = this.roleApi.queryRoleIdsByUserId(userId);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        userOrgIds = (List)commonResponse.getData();
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter("eq", (Object)0));
            qp.getParams().put("role_id", new Parameter("in", userOrgIds));
            List accessEntities = this.accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                HashSet<Long> categoryIds = new HashSet<Long>();
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", allList);
    }

    @Override
    public CommonResponse<JSONObject> accessToTreeList(Map<Long, Integer> accessMap) {
        JSONObject jsonObject = new JSONObject();
        if (accessMap == null || accessMap.size() < 1) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        List list = super.queryList(param, false);
        List<KbmCategoryVO> kbmCategoryVOS = this.supplementTree(list, accessMap);
        List resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        jsonObject.put("data", this.addFileNum(treeData));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<JSONObject> allAccessToTreeList(Map<Long, Integer> map) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)"1"));
        List list = super.queryList(param, false);
        JSONObject jsonObject = new JSONObject();
        if (list == null || list.size() < 1) {
            jsonObject.put("data", (Object)list);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
        }
        ArrayList<Long> allList = new ArrayList<Long>();
        for (KbmCategoryEntity kc : list) {
            if (!kc.getAccess().equals("0")) continue;
            allList.add(kc.getId());
        }
        List userOrgIds = new ArrayList();
        CommonResponse commonResponse = this.roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        userOrgIds = (List)commonResponse.getData();
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter("eq", (Object)0));
            qp.getParams().put("role_id", new Parameter("in", userOrgIds));
            List accessEntities = this.accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                HashSet<Long> categoryIds = new HashSet<Long>();
                Iterator iterator = accessEntities.iterator();
                while (iterator.hasNext()) {
                    KbmCategoryAccessEntity ka = (KbmCategoryAccessEntity)((Object)iterator.next());
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }
        List<KbmCategoryVO> kbmCategoryVOS = this.supplementTree(list, allList, 0);
        for (KbmCategoryVO categoryVO : kbmCategoryVOS) {
            categoryVO.setFileNum(map.containsKey(categoryVO.getId()) ? map.get(categoryVO.getId()) : Integer.valueOf(0));
        }
        List resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        jsonObject.put("data", this.addFileNum(ResultAsTree.createTreeData((List)resultMapList)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<Map<String, Object>> addFileNum(List<Map<String, Object>> treeData) {
        for (Map<String, Object> map : treeData) {
            List children = (List)map.get("children");
            if (children == null) continue;
            Map<String, Object> map2 = this.sumFile(map);
        }
        return treeData;
    }

    private Map<String, Object> sumFile(Map<String, Object> map) {
        List children = (List)map.get("children");
        Integer fileNum = (Integer)map.get("fileNum");
        for (Map cmap : children) {
            List children1 = (List)cmap.get("children");
            if (children1 == null) {
                fileNum = fileNum + (Integer)cmap.get("fileNum");
                continue;
            }
            Map<String, Object> newmap = this.sumFile(cmap);
            cmap.put("fileNum", newmap.get("fileNum"));
            fileNum = fileNum + (Integer)newmap.get("fileNum");
        }
        map.put("fileNum", fileNum);
        return map;
    }

    private List<KbmCategoryVO> supplementTree(List<KbmCategoryEntity> list, Map<Long, Integer> accessMap) {
        KbmCategoryVO kbmCategoryVO;
        ArrayList<KbmCategoryVO> lastVO = new ArrayList<KbmCategoryVO>();
        if (accessMap == null || accessMap.size() < 1) {
            return lastVO;
        }
        List vos = BeanMapper.mapList(list, KbmCategoryVO.class);
        HashMap<Long, KbmCategoryVO> voMap = new HashMap<Long, KbmCategoryVO>();
        for (KbmCategoryVO kc : vos) {
            voMap.put(kc.getId(), kc);
        }
        HashSet<Long> supplementids = new HashSet<Long>();
        for (Map.Entry<Long, Integer> entry : accessMap.entrySet()) {
            Long id = entry.getKey();
            kbmCategoryVO = (KbmCategoryVO)voMap.get(id);
            String[] split = kbmCategoryVO.getInnerCode().split("\\|");
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; ++i) {
                    supplementids.add(Long.parseLong(split[i]));
                }
            }
            kbmCategoryVO.setUserAccess("1");
            kbmCategoryVO.setFileNum(entry.getValue());
            lastVO.add(kbmCategoryVO);
        }
        for (Long supplementid : supplementids) {
            ArrayList<Long> ids = new ArrayList<Long>(accessMap.keySet());
            if (ids.contains(supplementid)) continue;
            kbmCategoryVO = (KbmCategoryVO)voMap.get(supplementid);
            kbmCategoryVO.setUserAccess("0");
            kbmCategoryVO.setFileNum(Integer.valueOf(0));
            lastVO.add(kbmCategoryVO);
        }
        return lastVO;
    }

    private List<KbmCategoryVO> supplementTree(List<KbmCategoryEntity> list, List<Long> ids, int treeType) {
        KbmCategoryVO kbmCategoryVO;
        ArrayList<KbmCategoryVO> lastVO = new ArrayList<KbmCategoryVO>();
        if (ids == null || ids.size() < 1) {
            return lastVO;
        }
        List vos = BeanMapper.mapList(list, KbmCategoryVO.class);
        HashMap<Long, KbmCategoryVO> voMap = new HashMap<Long, KbmCategoryVO>();
        for (KbmCategoryVO kc : vos) {
            voMap.put(kc.getId(), kc);
        }
        HashSet<Long> supplementids = new HashSet<Long>();
        for (Long id : ids) {
            kbmCategoryVO = (KbmCategoryVO)voMap.get(id);
            String[] split = kbmCategoryVO.getInnerCode().split("\\|");
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; ++i) {
                    supplementids.add(Long.parseLong(split[i]));
                }
            }
            if (treeType == 0) {
                kbmCategoryVO.setUserAccess("1");
            } else {
                kbmCategoryVO.setUserUpload("1");
            }
            lastVO.add(kbmCategoryVO);
        }
        for (Long supplementid : supplementids) {
            if (ids.contains(supplementid)) continue;
            kbmCategoryVO = (KbmCategoryVO)voMap.get(supplementid);
            if (treeType == 0) {
                kbmCategoryVO.setUserAccess("0");
            } else {
                kbmCategoryVO.setUserUpload("0");
            }
            lastVO.add(kbmCategoryVO);
        }
        return lastVO;
    }
}

