package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.doc.bean.KbmCategoryAccessEntity;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.mapper.KbmCategoryMapper;
import com.ejianc.business.doc.service.IKbmCategoryAccessService;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;
import com.ejianc.business.doc.vo.KbmCategoryVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 知识分类
 *
 * @author generator
 */
@Service("kbmCategoryService")
public class KbmCategoryServiceImpl extends BaseServiceImpl<KbmCategoryMapper, KbmCategoryEntity> implements IKbmCategoryService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IKbmCategoryAccessService accessService;
    @Autowired
    private IKbmCategoryUploadService uploadService;
    @Autowired
    private KbmCategoryMapper kbmCategoryMapper;
    @Autowired
    private IRoleApi roleApi;

    @Override
    public CommonResponse<KbmCategoryVO> saveOrUpdate(KbmCategoryVO saveorUpdateVO) {

        KbmCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            String access = saveorUpdateVO.getAccess();
            String upload = saveorUpdateVO.getUpload();

            KbmCategoryEntity kbmCategoryEntity = kbmCategoryMapper.selectById(saveorUpdateVO.getId());
            entity = BeanMapper.map(kbmCategoryEntity, KbmCategoryEntity.class);

            // 访问权限，0-默认，1-自定义
            if (!kbmCategoryEntity.getAccess().equals(access)) {//修改了访问权限
                if (access.equals("0")) {
                    //删除访问权限表数据
                    accessService.remove(new QueryWrapper<KbmCategoryAccessEntity>().eq("category_id", entity.getId()));
                } else if (access.equals("1")) {

                }
                if (upload.equals("1")) {
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                }
            }
            // 上传权限，0-不允许，1-默认，2-自定义
            if (!kbmCategoryEntity.getUpload().equals(upload)) {//修改了上传权限
                if (upload.equals("0")) {
                    //删除上传权限表数据
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                } else if (upload.equals("1")) {
                    //和访问权限保持一致
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                    QueryParam param = new QueryParam();
                    param.getParams().put("category_id", new Parameter(QueryParam.EQ, entity.getId()));
                    param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
                    List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(param, false);
                    List<KbmCategoryUploadEntity> kbmCategoryUploadEntities = BeanMapper.mapList(accessEntities, KbmCategoryUploadEntity.class);
                    for (KbmCategoryUploadEntity ku : kbmCategoryUploadEntities) {
                        ku.setId(null);
                    }
                    uploadService.saveBatch(kbmCategoryUploadEntities);
                } else if (upload.equals("2")) {
                    uploadService.remove(new QueryWrapper<KbmCategoryUploadEntity>().eq("category_id", entity.getId()));
                }
            }
            entity.setCategoryName(saveorUpdateVO.getCategoryName());
            entity.setAccess(saveorUpdateVO.getAccess());
            entity.setUpload(saveorUpdateVO.getUpload());
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            Long orgId = InvocationInfoProxy.getOrgId();
            String orgName = sessionManager.getUserContext().getOrgName();
            entity = BeanMapper.map(saveorUpdateVO, KbmCategoryEntity.class);
            entity.setOrgId(orgId);
            entity.setOrgName(orgName);
            entity.setId(IdWorker.getId());
            entity.setEnabled("1");
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                KbmCategoryEntity uniqueBean = kbmCategoryMapper.selectById(entity.getParentId());
                String[] split = uniqueBean.getInnerCode().split("\\|");
                if (split.length >= 3) {
                    throw new BusinessException("知识分类结构最多三层");
                }
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public List<KbmCategoryVO> findParentsById(Long id) {
        KbmCategoryEntity entity = kbmCategoryMapper.selectById(id);
        if (entity != null) {
            List<KbmCategoryVO> result = kbmCategoryMapper.queryParentsById(entity.getInnerCode());
            return result;
        }
        return null;
    }

    @Override
    public CommonResponse<JSONObject> userTreeList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 启用 */
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));

        List<KbmCategoryEntity> list = super.queryList(param, false);
        JSONObject jsonObject = new JSONObject();
        if (list == null || list.size() < 1) {
            jsonObject.put("data", list);
            return CommonResponse.success("查询列表数据成功！", jsonObject);
        }
        //访问权限为默认
        List<Long> allList = new ArrayList<>();
        for (KbmCategoryEntity kc : list) {
            if (kc.getAccess().equals("0")) {
                allList.add(kc.getId());
            }
        }

        List<Long> userOrgIds = new ArrayList<>();
        CommonResponse<List<Long>> commonResponse = roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (commonResponse.isSuccess()) {
            userOrgIds = commonResponse.getData();
        } else {
            throw new BusinessException(commonResponse.getMsg());
        }
        //访问权限为自定义
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            qp.getParams().put("role_id", new Parameter(QueryParam.IN, userOrgIds));
            List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                Set<Long> categoryIds = new HashSet<>();
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }

        //allList是所有有权限的分类主键集合(包括默认和自定义)
        List<KbmCategoryVO> kbmCategoryVOS = supplementTree(list, allList, 0);
        List<Map> resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    @Override
    public CommonResponse<List<Long>> userFindChildrenId(Long id) {
        KbmCategoryEntity entity = kbmCategoryMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<KbmCategoryEntity> editList = super.queryList(param, false);

        List<Long> list = new ArrayList<>();
        list.add(id);

        List<Long> userOrgIds = new ArrayList<>();
        CommonResponse<List<Long>> commonResponse = roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (commonResponse.isSuccess()) {
            userOrgIds = commonResponse.getData();
        } else {
            throw new BusinessException(commonResponse.getMsg());
        }
        //访问权限为自定义
        Set<Long> categoryIds = new HashSet<>();
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            qp.getParams().put("role_id", new Parameter(QueryParam.IN, userOrgIds));
            List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
            }
        }
        for (KbmCategoryEntity kc : editList) {
            if (kc.getAccess().equals("0")) {//默认
                list.add(kc.getId());
            } else {
                if (categoryIds.contains(kc.getId())) {
                    list.add(kc.getId());
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", list);
    }

    @Override
    public CommonResponse<JSONObject> userUploadTreeList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 启用 */
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));

        List<KbmCategoryEntity> list = super.queryList(param, false);
        JSONObject jsonObject = new JSONObject();
        if (list == null || list.size() < 1) {
            jsonObject.put("data", list);
            return CommonResponse.success("查询列表数据成功！", jsonObject);
        }
        //访问权限为默认
        List<Long> allList = new ArrayList<>();

        List<Long> userOrgIds = new ArrayList<>();
        CommonResponse<List<Long>> commonResponse = roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (commonResponse.isSuccess()) {
            userOrgIds = commonResponse.getData();
        } else {
            throw new BusinessException(commonResponse.getMsg());
        }
        //上传权限
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            qp.getParams().put("role_id", new Parameter(QueryParam.IN, userOrgIds));
            List<KbmCategoryUploadEntity> uploadEntities = uploadService.queryList(qp, false);
            if (uploadEntities != null && uploadEntities.size() > 0) {
                Set<Long> categoryIds = new HashSet<>();
                for (KbmCategoryUploadEntity ka : uploadEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }

        //allList是所有有权限的分类主键集合(包括默认和自定义)
        List<KbmCategoryVO> kbmCategoryVOS = supplementTree(list, allList, 1);
        List<Map> resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    @Override
    public CommonResponse<JSONObject> adminTreeList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 启用 */
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));

        List<KbmCategoryEntity> list = super.queryList(param, false);

        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    @Override
    public CommonResponse<List<Long>> adminFindChildrenId(Long id) {
        KbmCategoryEntity entity = super.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<KbmCategoryEntity> editList = super.queryList(param, false);
        List<Long> list = new ArrayList<>();
        list.add(id);
        for (KbmCategoryEntity en : editList) {
            list.add(en.getId());
        }
        return CommonResponse.success("查询详情数据成功！", list);
    }

    @Override
    public CommonResponse<Boolean> kbmAccess(Long userId, Long categoryId) {
        KbmCategoryEntity kbmCategoryEntity = super.selectById(categoryId);
        if (kbmCategoryEntity.getAccess().equals("0")) {
            return CommonResponse.success("查询用户权限成功！", true);
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("category_id", new Parameter(QueryParam.EQ, categoryId));
            param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(param, false);
            if (accessEntities == null || accessEntities.size() < 1) {
                return CommonResponse.success("查询用户权限成功！", false);
            }
            if (userId == null || userId <= 0) {
                userId = InvocationInfoProxy.getUserid();
            }
            List<Long> userOrgIds = new ArrayList<>();
            CommonResponse<List<Long>> commonResponse = roleApi.queryRoleIdsByUserId(userId);
            if (commonResponse.isSuccess()) {
                userOrgIds = commonResponse.getData();
            } else {
                throw new BusinessException(commonResponse.getMsg());
            }
            for (KbmCategoryAccessEntity kca : accessEntities) {
                if (userOrgIds.contains(kca.getRoleId())) {
                    return CommonResponse.success("查询用户权限成功！", true);
                }
            }
            return CommonResponse.success("查询用户权限成功！", false);
        }
    }

    @Override
    public CommonResponse<List<Long>> userAccessQueryList(Long userId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 启用 */
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));

        List<KbmCategoryEntity> list = super.queryList(param, false);
        //访问权限为默认
        List<Long> allList = new ArrayList<>();
        if (list == null || list.size() < 1) {
            return CommonResponse.success("查询数据成功！", allList);
        }
        for (KbmCategoryEntity kc : list) {
            if (kc.getAccess().equals("0")) {
                allList.add(kc.getId());
            }
        }
        if (userId == null || userId <= 0) {
            userId = InvocationInfoProxy.getUserid();
        }
        List<Long> userOrgIds = new ArrayList<>();
        CommonResponse<List<Long>> commonResponse = roleApi.queryRoleIdsByUserId(userId);
        if (commonResponse.isSuccess()) {
            userOrgIds = commonResponse.getData();
        } else {
            throw new BusinessException(commonResponse.getMsg());
        }
        //访问权限为自定义
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            qp.getParams().put("role_id", new Parameter(QueryParam.IN, userOrgIds));
            List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                Set<Long> categoryIds = new HashSet<>();
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }
        return CommonResponse.success("查询数据成功！", allList);
    }

    @Override
    public CommonResponse<JSONObject> accessToTreeList(Map<Long, Integer> accessMap) {
        JSONObject jsonObject = new JSONObject();
        if (accessMap == null || accessMap.size() < 1) {
            return CommonResponse.success("查询数据成功！", jsonObject);
        }
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 启用 */
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));

        List<KbmCategoryEntity> list = super.queryList(param, false);
        List<KbmCategoryVO> kbmCategoryVOS = supplementTree(list, accessMap);
        List<Map> resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
        jsonObject.put("data", addFileNum(treeData));
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    @Override
    public CommonResponse<JSONObject> allAccessToTreeList(Map<Long, Integer> map) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 启用 */
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, "1"));

        List<KbmCategoryEntity> list = super.queryList(param, false);
        JSONObject jsonObject = new JSONObject();
        if (list == null || list.size() < 1) {
            jsonObject.put("data", list);
            return CommonResponse.success("查询列表数据成功！", jsonObject);
        }
        //访问权限为默认
        List<Long> allList = new ArrayList<>();
        for (KbmCategoryEntity kc : list) {
            if (kc.getAccess().equals("0")) {
                allList.add(kc.getId());
            }
        }

        List<Long> userOrgIds = new ArrayList<>();
        CommonResponse<List<Long>> commonResponse = roleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (commonResponse.isSuccess()) {
            userOrgIds = commonResponse.getData();
        } else {
            throw new BusinessException(commonResponse.getMsg());
        }
        //访问权限为自定义
        if (userOrgIds != null && userOrgIds.size() > 0) {
            QueryParam qp = new QueryParam();
            qp.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            qp.getParams().put("role_id", new Parameter(QueryParam.IN, userOrgIds));
            List<KbmCategoryAccessEntity> accessEntities = accessService.queryList(qp, false);
            if (accessEntities != null && accessEntities.size() > 0) {
                Set<Long> categoryIds = new HashSet<>();
                for (KbmCategoryAccessEntity ka : accessEntities) {
                    categoryIds.add(ka.getCategoryId());
                }
                allList.addAll(categoryIds);
            }
        }

        //allList是所有有权限的分类主键集合(包括默认和自定义)
        List<KbmCategoryVO> kbmCategoryVOS = supplementTree(list, allList, 0);
        for(KbmCategoryVO categoryVO : kbmCategoryVOS){
            categoryVO.setFileNum(map.containsKey(categoryVO.getId()) ? map.get(categoryVO.getId()) : 0);
        }
        List<Map> resultMapList = BeanMapper.mapList(kbmCategoryVOS, Map.class);
        jsonObject.put("data", addFileNum(ResultAsTree.createTreeData(resultMapList)));
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    private List<Map<String, Object>> addFileNum(List<Map<String, Object>> treeData) {
        for (Map<String, Object> map : treeData) {
            List<Map<String, Object>> children = (List<Map<String, Object>>) map.get("children");
            if (children != null) {
                map = sumFile(map);
            }
        }
        return treeData;
    }

    private Map<String, Object> sumFile(Map<String, Object> map) {
        List<Map<String, Object>> children = (List<Map<String, Object>>) map.get("children");
        Integer fileNum = (Integer) map.get("fileNum");
        for (Map<String, Object> cmap : children) {
            List<Map<String, Object>> children1 = (List<Map<String, Object>>) cmap.get("children");
            if (children1 == null) {
                fileNum = fileNum + (Integer) cmap.get("fileNum");
            } else {
                Map<String, Object> newmap = sumFile(cmap);
                cmap.put("fileNum", newmap.get("fileNum"));
                fileNum = fileNum + (Integer) newmap.get("fileNum");
            }
        }
        map.put("fileNum", fileNum);
        return map;
    }

    /**
     * 补全结构树
     *
     * @param list
     * @return
     */
    private List<KbmCategoryVO> supplementTree(List<KbmCategoryEntity> list, Map<Long, Integer> accessMap) {
        List<KbmCategoryVO> lastVO = new ArrayList<>();
        if (accessMap == null || accessMap.size() < 1) {
            return lastVO;
        }
        List<KbmCategoryVO> vos = BeanMapper.mapList(list, KbmCategoryVO.class);
        Map<Long, KbmCategoryVO> voMap = new HashMap<>();
        for (KbmCategoryVO kc : vos) {
            voMap.put(kc.getId(), kc);
        }

        Set<Long> supplementids = new HashSet<>();
        for (Map.Entry<Long, Integer> entry : accessMap.entrySet()) {
            Long id = entry.getKey();
            KbmCategoryVO kbmCategoryVO = voMap.get(id);

            //查询所有上级的主键
            String[] split = kbmCategoryVO.getInnerCode().split("\\|");
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; i++) {
                    supplementids.add(Long.parseLong(split[i]));
                }
            }
            kbmCategoryVO.setUserAccess("1");
            kbmCategoryVO.setFileNum(entry.getValue());
            lastVO.add(kbmCategoryVO);
        }

        // 将补充的也加上
        for (Long supplementid : supplementids) {
            List<Long> ids = new ArrayList<Long>(accessMap.keySet());
            if (!ids.contains(supplementid)) {
                KbmCategoryVO kbmCategoryVO = voMap.get(supplementid);

                kbmCategoryVO.setUserAccess("0");
                kbmCategoryVO.setFileNum(0);
                lastVO.add(kbmCategoryVO);
            }
        }
        return lastVO;
    }

    /**
     * 补全结构树
     *
     * @param list
     * @param ids
     * @return
     */
    private List<KbmCategoryVO> supplementTree(List<KbmCategoryEntity> list, List<Long> ids, int treeType) {
        List<KbmCategoryVO> lastVO = new ArrayList<>();
        if (ids == null || ids.size() < 1) {
            return lastVO;
        }
        List<KbmCategoryVO> vos = BeanMapper.mapList(list, KbmCategoryVO.class);
        Map<Long, KbmCategoryVO> voMap = new HashMap<>();
        for (KbmCategoryVO kc : vos) {
            voMap.put(kc.getId(), kc);
        }

        Set<Long> supplementids = new HashSet<>();
        for (Long id : ids) {
            KbmCategoryVO kbmCategoryVO = voMap.get(id);

            //查询所有上级的主键
            String[] split = kbmCategoryVO.getInnerCode().split("\\|");
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; i++) {
                    supplementids.add(Long.parseLong(split[i]));
                }
            }

            // 权限下的分类
            if (treeType == 0) {
                kbmCategoryVO.setUserAccess("1");
            } else {
                kbmCategoryVO.setUserUpload("1");
            }
            lastVO.add(kbmCategoryVO);
        }

        // 将补充的也加上
        for (Long supplementid : supplementids) {
            if (!ids.contains(supplementid)) {
                KbmCategoryVO kbmCategoryVO = voMap.get(supplementid);
                // 补充的分类
                if (treeType == 0) {
                    kbmCategoryVO.setUserAccess("0");
                } else {
                    kbmCategoryVO.setUserUpload("0");
                }
                lastVO.add(kbmCategoryVO);
            }
        }
        return lastVO;
    }
}
