/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.MyFavoriteEntity;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.bean.ViewLogEntity;
import com.ejianc.business.doc.service.IDocCategoryRoleRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.service.IMyFavoriteService;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.service.IViewLogService;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.business.doc.vo.DocCategoryVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import sun.misc.BASE64Encoder;

@Controller
@RequestMapping(value={"docCategory"})
public class DocCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDocCategoryService service;
    @Autowired
    private IDocCategoryRoleRelationService relationService;
    @Autowired
    private IProjectDocService projectDocService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMyFavoriteService myFavoriteService;
    @Autowired
    private IViewLogService viewLogService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DocCategoryVO> saveOrUpdate(@RequestBody DocCategoryVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            DocCategoryEntity uniqueBean = (DocCategoryEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            uniqueBean.setCategoryName(saveorUpdateVO.getCategoryName());
            uniqueBean.setNum(saveorUpdateVO.getNum());
            uniqueBean.setRequired(saveorUpdateVO.getRequired());
            this.service.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        DocCategoryEntity entity = (DocCategoryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DocCategoryEntity.class));
        entity.setId(IdWorker.getId());
        entity.setEnabled("1");
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            DocCategoryEntity uniqueBean = (DocCategoryEntity)((Object)this.service.selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocCategoryVO> queryDetail(Long id) {
        DocCategoryEntity entity = (DocCategoryEntity)((Object)this.service.selectById(id));
        DocCategoryVO vo = (DocCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), DocCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocCategoryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/enabled"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam boolean enable) {
        DocCategoryEntity entity = (DocCategoryEntity)((Object)this.service.selectById(id));
        if (enable) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
            List editList = this.service.queryList(param, false);
            List<DocCategoryVO> parents = this.service.findParentsById(id);
            for (DocCategoryVO vo : parents) {
                if (vo.getId().equals(id)) continue;
                if (!"0".equals(vo.getEnabled())) break;
                editList.add(BeanMapper.map((Object)((Object)vo), DocCategoryEntity.class));
            }
            for (DocCategoryEntity en : editList) {
                en.setEnabled("1");
            }
            this.service.saveOrUpdateBatch(editList, editList.size(), false);
            return CommonResponse.success((String)"\u542f\u7528\u6210\u529f\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
        List editList = this.service.queryList(param, false);
        for (DocCategoryEntity en : editList) {
            en.setEnabled("0");
        }
        this.service.saveOrUpdateBatch(editList, editList.size(), false);
        return CommonResponse.success((String)"\u505c\u7528\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getListByUserId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getListByUserId(@RequestParam(required=false) Long userId) {
        return this.relationService.getListByUserId(userId);
    }

    @GetMapping(value={"/categoryTreeRef"})
    @ResponseBody
    public List<Map<String, Object>> categoryTreeRef(@RequestParam(value="searchText", required=false) String searchText) {
        Long userId = InvocationInfoProxy.getUserid();
        List<DocCategoryEntity> categoryEntities = this.relationService.getAllByUserId(userId, searchText);
        List resultMapList = BeanMapper.mapList(categoryEntities, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"/queryRoleList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DocCategoryRoleRelationVO>> queryRoleList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.relationService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DocCategoryRoleRelationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveDocCategoryRole"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveDocCategoryRole(@RequestBody List<DocCategoryRoleRelationVO> relationList) {
        return this.relationService.saveDocCategoryRole(relationList);
    }

    @RequestMapping(value={"/deleteDocCategoryRole"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteDocCategoryRole(@RequestBody List<DocCategoryRoleRelationVO> relationList) {
        return this.relationService.deleteDocCategoryRole(relationList);
    }

    @RequestMapping(value={"/folders"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray folders(@RequestParam(required=false, value="id") String id) {
        CommonResponse<JSONObject> response = this.relationService.getListByUserId(InvocationInfoProxy.getUserid());
        JSONArray res = new JSONArray();
        if (response.isSuccess()) {
            List data = (List)((JSONObject)response.getData()).get((Object)"data");
            data.forEach(m -> {
                JSONObject fo = new JSONObject();
                fo.putIfAbsent((Object)"id", m.get("id"));
                fo.putIfAbsent((Object)"value", m.get("categoryName"));
                fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)((Date)m.get("createTime"))));
                fo.putIfAbsent((Object)"size", (Object)0);
                QueryParam param = new QueryParam();
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                param.getParams().put("fileId", new Parameter("eq", m.get("id")));
                List favoriteEntities = this.myFavoriteService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)favoriteEntities)) {
                    fo.putIfAbsent((Object)"star", (Object)true);
                }
                fo.putIfAbsent((Object)"type", (Object)"folder");
                if (m.get("children") != null) {
                    List<JSONObject> r = this.getData((ArrayList)m.get("children"));
                    fo.putIfAbsent((Object)"data", r);
                }
                res.add((Object)fo);
            });
        }
        return res;
    }

    private List<JSONObject> getData(ArrayList children) {
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (int i = 0; i < children.size(); ++i) {
            JSONObject d = new JSONObject();
            HashMap m = (HashMap)children.get(i);
            d.putIfAbsent((Object)"id", m.get("id"));
            d.putIfAbsent((Object)"value", m.get("categoryName"));
            d.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)((Date)m.get("createTime"))));
            d.putIfAbsent((Object)"size", (Object)0);
            d.putIfAbsent((Object)"type", (Object)"folder");
            QueryParam param = new QueryParam();
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            param.getParams().put("fileId", new Parameter("eq", m.get("id")));
            List favoriteEntities = this.myFavoriteService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)favoriteEntities)) {
                d.putIfAbsent((Object)"star", (Object)true);
            }
            if (m.get("children") != null) {
                List<JSONObject> res = this.getData((ArrayList)m.get("children"));
                d.putIfAbsent((Object)"data", res);
            }
            data.add(d);
        }
        return data;
    }

    @RequestMapping(value={"/files"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray files(@RequestParam(required=false, value="id") String id, @RequestParam(required=false, value="source") String source) {
        if ("/".equals(id)) {
            if ("trash".equals(source)) {
                return new JSONArray();
            }
            if ("favorite".equals(source)) {
                JSONArray favorite = new JSONArray();
                QueryParam param = new QueryParam();
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                List favoriteEntities = this.myFavoriteService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)favoriteEntities)) {
                    favoriteEntities.forEach(f -> {
                        if ("folder".equals(f.getFileType())) {
                            DocCategoryEntity m = (DocCategoryEntity)((Object)((Object)this.service.selectById(f.getFileId())));
                            JSONObject fo = new JSONObject();
                            fo.putIfAbsent((Object)"id", (Object)m.getId());
                            fo.putIfAbsent((Object)"value", (Object)m.getCategoryName());
                            fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)m.getCreateTime()));
                            fo.putIfAbsent((Object)"size", (Object)0);
                            fo.putIfAbsent((Object)"star", (Object)true);
                            fo.putIfAbsent((Object)"type", (Object)"folder");
                            favorite.add((Object)fo);
                        } else {
                            CommonResponse response = this.attachmentApi.queryDetail(f.getFileId() + "");
                            if (response.isSuccess()) {
                                AttachmentVO m = (AttachmentVO)response.getData();
                                JSONObject fo = new JSONObject();
                                fo.putIfAbsent((Object)"id", (Object)m.getId());
                                fo.putIfAbsent((Object)"value", (Object)m.getFileName());
                                fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)m.getCreateTime()));
                                fo.putIfAbsent((Object)"size", (Object)m.getFileSize());
                                fo.putIfAbsent((Object)"filePath", (Object)m.getFilePath());
                                fo.putIfAbsent((Object)"star", (Object)true);
                                String[] type = m.getFileName().split("\\.");
                                fo.putIfAbsent((Object)"type", (Object)this.getType(type[1]));
                                favorite.add((Object)fo);
                            }
                        }
                    });
                }
                return favorite;
            }
            if ("recent".equals(source)) {
                JSONArray recent = new JSONArray();
                QueryParam param = new QueryParam();
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                param.getOrderMap().put("createTime", "desc");
                param.setPageSize(20);
                IPage viewLogEntityIPage = this.viewLogService.queryPage(param, false);
                List favoriteEntities = viewLogEntityIPage.getRecords();
                if (ListUtil.isNotEmpty((List)favoriteEntities)) {
                    favoriteEntities.forEach(f -> {
                        if ("folder".equals(f.getFileType())) {
                            DocCategoryEntity m = (DocCategoryEntity)((Object)((Object)this.service.selectById(f.getFileId())));
                            JSONObject fo = new JSONObject();
                            fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)m.getCreateTime()));
                            fo.putIfAbsent((Object)"id", (Object)m.getId());
                            fo.putIfAbsent((Object)"size", (Object)0);
                            fo.putIfAbsent((Object)"value", (Object)m.getCategoryName());
                            QueryParam p = new QueryParam();
                            p.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                            p.getParams().put("fileId", new Parameter("eq", (Object)m.getId()));
                            List fav = this.myFavoriteService.queryList(p, false);
                            if (ListUtil.isNotEmpty((List)fav)) {
                                fo.putIfAbsent((Object)"star", (Object)true);
                            }
                            fo.putIfAbsent((Object)"type", (Object)"folder");
                            recent.add((Object)fo);
                        } else {
                            CommonResponse response = this.attachmentApi.queryDetail(f.getFileId() + "");
                            if (response.isSuccess()) {
                                AttachmentVO m = (AttachmentVO)response.getData();
                                JSONObject fo = new JSONObject();
                                fo.putIfAbsent((Object)"id", (Object)m.getId());
                                fo.putIfAbsent((Object)"value", (Object)m.getFileName());
                                fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)m.getCreateTime()));
                                fo.putIfAbsent((Object)"filePath", (Object)m.getFilePath());
                                fo.putIfAbsent((Object)"size", (Object)m.getFileSize());
                                QueryParam p = new QueryParam();
                                p.getParams().put("fileId", new Parameter("eq", (Object)m.getId()));
                                p.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                                List fav = this.myFavoriteService.queryList(p, false);
                                if (ListUtil.isNotEmpty((List)fav)) {
                                    fo.putIfAbsent((Object)"star", (Object)true);
                                }
                                String[] type = m.getFileName().split("\\.");
                                fo.putIfAbsent((Object)"type", (Object)this.getType(type[1]));
                                recent.add((Object)fo);
                            }
                        }
                    });
                }
                return recent;
            }
            return this.folders(id);
        }
        QueryParam queryParam = new QueryParam();
        Long categoryId = Long.valueOf(id);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getFuzzyFields().add("fileName");
        queryParam.getFuzzyFields().add("superviseUserName");
        queryParam.getOrderMap().put("superviseTime", "desc");
        queryParam.getParams().put("docCategoryId", new Parameter("eq", (Object)id));
        List fileList = this.projectDocService.queryList(queryParam, false);
        List<DocCategoryEntity> folders = this.service.findDirectChildrenByPid(categoryId);
        JSONArray res = new JSONArray();
        if (ListUtil.isNotEmpty(folders)) {
            folders.forEach(m -> {
                JSONObject fo = new JSONObject();
                fo.putIfAbsent((Object)"id", (Object)m.getId());
                fo.putIfAbsent((Object)"value", (Object)m.getCategoryName());
                fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)m.getCreateTime()));
                fo.putIfAbsent((Object)"size", (Object)0);
                QueryParam param = new QueryParam();
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                param.getParams().put("fileId", new Parameter("eq", (Object)m.getId()));
                List favoriteEntities = this.myFavoriteService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)favoriteEntities)) {
                    fo.putIfAbsent((Object)"star", (Object)true);
                }
                fo.putIfAbsent((Object)"type", (Object)"folder");
                res.add((Object)fo);
            });
        }
        if (ListUtil.isNotEmpty((List)fileList)) {
            fileList.forEach(m -> {
                JSONObject fo = new JSONObject();
                fo.putIfAbsent((Object)"id", (Object)m.getFileId());
                fo.putIfAbsent((Object)"value", (Object)m.getFileName());
                fo.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)m.getCreateTime()));
                fo.putIfAbsent((Object)"size", (Object)m.getFileSize());
                fo.putIfAbsent((Object)"filePath", (Object)m.getFilePath());
                QueryParam param = new QueryParam();
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                param.getParams().put("fileId", new Parameter("eq", (Object)m.getFileId()));
                List favoriteEntities = this.myFavoriteService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)favoriteEntities)) {
                    fo.putIfAbsent((Object)"star", (Object)true);
                }
                fo.putIfAbsent((Object)"type", (Object)this.getType(m.getFileType()));
                res.add((Object)fo);
            });
        }
        ViewLogEntity viewLogEntity = new ViewLogEntity();
        viewLogEntity.setFileId(Long.parseLong(id));
        viewLogEntity.setFileType("folder");
        this.viewLogService.saveOrUpdate((Object)viewLogEntity, false);
        return res;
    }

    private String getType(String fileName) {
        String type;
        if ("txt".equals(fileName.toLowerCase())) {
            type = "code";
        } else if ("xls".equals(fileName.toLowerCase()) || "xlsx".equals(fileName.toLowerCase()) || "bat".equals(fileName.toLowerCase()) || "doc".equals(fileName.toLowerCase()) || "docx".equals(fileName.toLowerCase()) || "zip".equals(fileName.toLowerCase()) || "csv".equals(fileName.toLowerCase()) || "exe".equals(fileName.toLowerCase()) || "jar".equals(fileName.toLowerCase()) || "log".equals(fileName.toLowerCase()) || "msi".equals(fileName.toLowerCase()) || "iso".equals(fileName.toLowerCase()) || "pdf".equals(fileName.toLowerCase()) || "rar".equals(fileName.toLowerCase()) || "swf".equals(fileName.toLowerCase()) || "ppt".equals(fileName.toLowerCase()) || "pptx".equals(fileName.toLowerCase())) {
            type = "document";
        } else if ("mp3".equals(fileName.toLowerCase()) || "wma".equals(fileName.toLowerCase()) || "aac".equals(fileName.toLowerCase())) {
            type = "audio";
        } else if ("3gp".equals(fileName.toLowerCase()) || "mp4".equals(fileName.toLowerCase()) || "avi".equals(fileName.toLowerCase()) || "mkv".equals(fileName.toLowerCase()) || "rm".equals(fileName.toLowerCase()) || "rmvb".equals(fileName.toLowerCase()) || "mov".equals(fileName.toLowerCase()) || "mod".equals(fileName.toLowerCase()) || "wmv".equals(fileName.toLowerCase()) || "ogg".equals(fileName.toLowerCase())) {
            type = "video";
        } else if ("jpg".equals(fileName.toLowerCase()) || "png".equals(fileName.toLowerCase()) || "gif".equals(fileName.toLowerCase()) || "jpeg".equals(fileName.toLowerCase()) || "bmp".equals(fileName.toLowerCase())) {
            type = "image";
        } else {
            this.logger.info("\u672a\u77e5\u683c\u5f0f\uff1a{}", (Object)fileName);
            type = "unknown";
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/preview", "/direct"})
    public void preview(@RequestParam(required=false, value="id") String id, HttpServletResponse httpServletResponse) {
        CommonResponse response = this.attachmentApi.queryDetail(id);
        if (response.isSuccess()) {
            AttachmentVO file = (AttachmentVO)response.getData();
            HttpURLConnection httpUrl = null;
            URL url = null;
            OutputStream os = null;
            InputStream inputStream = null;
            try {
                int count;
                url = new URL(file.getTruePath());
                httpUrl = (HttpURLConnection)url.openConnection();
                httpUrl.connect();
                inputStream = httpUrl.getInputStream();
                os = httpServletResponse.getOutputStream();
                byte[] buffer = new byte[8192];
                while ((count = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, count);
                    os.flush();
                }
            }
            catch (IOException | ClassCastException exception) {
            }
            finally {
                try {
                    httpUrl.disconnect();
                    inputStream.close();
                    os.close();
                }
                catch (IOException | NullPointerException exception) {}
            }
        }
    }

    @RequestMapping(value={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject upload(@RequestParam(value="id") String id, HttpServletRequest request) {
        JSONObject resFile = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MultipartFile> fileList = new ArrayList<MultipartFile>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile mf = (MultipartFile)entity.getValue();
            String originalFilename = mf.getOriginalFilename();
            if (mf.getSize() == 0L) {
                this.logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFilename.replaceAll("00.", "");
            fileList.add(mf);
        }
        for (MultipartFile file : fileList) {
            String contentType = file.getContentType();
            byte[] imageBytes = new byte[]{};
            try {
                imageBytes = file.getBytes();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BASE64Encoder base64Encoder = new BASE64Encoder();
            String base64EncoderImg = "data:" + contentType + ";base64," + base64Encoder.encode(imageBytes);
            base64EncoderImg = base64EncoderImg.replaceAll("[\\s*\t\n\r]", "");
            AttachmentRequestVO attachmentRequestVO = new AttachmentRequestVO();
            attachmentRequestVO.setBillType("BT201201000000001");
            attachmentRequestVO.setSourceType("projectDocMgr");
            attachmentRequestVO.setSourceId(id);
            attachmentRequestVO.setFileList(Collections.singletonList(base64EncoderImg));
            CommonResponse att = this.attachmentApi.uploadForBase64(attachmentRequestVO);
            if (!att.isSuccess()) continue;
            List list = (List)att.getData();
            AttachmentVO attachmentVO = (AttachmentVO)list.get(0);
            resFile.putIfAbsent((Object)"id", (Object)attachmentVO.getId());
            resFile.putIfAbsent((Object)"value", (Object)attachmentVO.getFileName());
            resFile.putIfAbsent((Object)"filePath", (Object)attachmentVO.getFilePath());
            resFile.putIfAbsent((Object)"date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)attachmentVO.getCreateTime()));
            resFile.putIfAbsent((Object)"size", (Object)attachmentVO.getFileSize());
            resFile.putIfAbsent((Object)"type", (Object)this.getType(attachmentVO.getFileName().split("\\.")[1]));
            ProjectDocEntity docEntity = new ProjectDocEntity();
            docEntity.setDocCategoryId(Long.valueOf(id));
            docEntity.setDocSource("1");
            docEntity.setFileId(attachmentVO.getId());
            docEntity.setFileName(attachmentVO.getFileName());
            docEntity.setFilePath(attachmentVO.getFilePath());
            docEntity.setFileSize(attachmentVO.getFileSize());
            docEntity.setFileType(attachmentVO.getFileName().split("\\.")[1]);
            docEntity.setOnlinePath(attachmentVO.getOnlinePath());
            docEntity.setOrgId(InvocationInfoProxy.getOrgId());
            docEntity.setSuperviseTime(new Date());
            docEntity.setSuperviseUserId(InvocationInfoProxy.getUserid());
            docEntity.setSuperviseUserName(InvocationInfoProxy.getUsercode());
            this.projectDocService.saveOrUpdate((Object)docEntity, false);
        }
        return resFile;
    }

    @RequestMapping(value={"info"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject info() {
        JSONObject info = new JSONObject();
        JSONObject features = new JSONObject();
        JSONObject meta = new JSONObject();
        meta.putIfAbsent((Object)"audio", (Object)true);
        meta.putIfAbsent((Object)"image", (Object)true);
        features.putIfAbsent((Object)"meta", (Object)meta);
        JSONObject preview = new JSONObject();
        preview.putIfAbsent((Object)"code", (Object)true);
        preview.putIfAbsent((Object)"document", (Object)true);
        preview.putIfAbsent((Object)"image", (Object)true);
        features.putIfAbsent((Object)"preview", (Object)preview);
        JSONObject stats = new JSONObject();
        stats.putIfAbsent((Object)"free", (Object)102400000);
        stats.putIfAbsent((Object)"total", (Object)102400000);
        stats.putIfAbsent((Object)"used", (Object)51200000);
        info.putIfAbsent((Object)"stats", (Object)stats);
        info.putIfAbsent((Object)"features", (Object)features);
        return info;
    }

    @RequestMapping(value={"meta"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject meta(@RequestParam(value="id") String id) {
        CommonResponse response = this.attachmentApi.queryDetail(id);
        JSONObject info = new JSONObject();
        if (response.isSuccess()) {
            AttachmentVO file = (AttachmentVO)response.getData();
            info.putIfAbsent((Object)"\u521b\u5efa\u4eba", (Object)file.getCreateUserName());
        }
        return info;
    }

    @RequestMapping(value={"comments"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray comments(@RequestParam(value="id") String id) {
        return new JSONArray();
    }

    @RequestMapping(value={"tags"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray tags(@RequestParam(value="id") String id) {
        CommonResponse response = this.attachmentApi.queryDetail(id);
        JSONObject info = new JSONObject();
        if (response.isSuccess()) {
            AttachmentVO file = (AttachmentVO)response.getData();
            ViewLogEntity viewLogEntity = new ViewLogEntity();
            viewLogEntity.setFileId(file.getId());
            viewLogEntity.setFileType(this.getType(file.getFileName().split("\\.")[1]));
            this.viewLogService.saveOrUpdate((Object)viewLogEntity, false);
            info.putIfAbsent((Object)"\u521b\u5efa\u4eba", (Object)file.getCreateUserName());
        }
        return new JSONArray();
    }

    @RequestMapping(value={"users/all"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray usersAll() {
        return new JSONArray();
    }

    @RequestMapping(value={"tags/all"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray tagsAll() {
        return new JSONArray();
    }

    @RequestMapping(value={"getPreviewUrl"}, method={RequestMethod.GET})
    @ResponseBody
    public AttachmentVO getPreviewUrl(@RequestParam(value="id") String id) {
        CommonResponse response = this.attachmentApi.queryDetail(id);
        if (response.isSuccess()) {
            AttachmentVO file = (AttachmentVO)response.getData();
            return file;
        }
        return null;
    }

    @RequestMapping(value={"favorite"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject favorite1(@RequestParam(value="id") String id, @RequestParam(value="type") String type) {
        MyFavoriteEntity entity = new MyFavoriteEntity();
        entity.setFileId(Long.parseLong(id));
        entity.setFileType(type);
        this.myFavoriteService.saveOrUpdate((Object)entity, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putIfAbsent((Object)"id", (Object)id);
        jsonObject.putIfAbsent((Object)"error", (Object)"");
        jsonObject.putIfAbsent((Object)"invalid", (Object)false);
        return jsonObject;
    }

    @RequestMapping(value={"favorite"}, method={RequestMethod.DELETE})
    @ResponseBody
    public JSONObject favorite(@RequestParam(value="id") String id) {
        QueryParam param = new QueryParam();
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        param.getParams().put("fileId", new Parameter("eq", (Object)id));
        List favoriteEntities = this.myFavoriteService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)favoriteEntities)) {
            favoriteEntities.forEach(f -> this.myFavoriteService.removeById(f.getId()));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.putIfAbsent((Object)"id", (Object)id);
        jsonObject.putIfAbsent((Object)"error", (Object)"");
        jsonObject.putIfAbsent((Object)"invalid", (Object)false);
        return jsonObject;
    }
}

