package com.ejianc.business.doc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.DocCategoryRoleRelationEntity;
import com.ejianc.business.doc.mapper.DocCategoryRoleRelationMapper;
import com.ejianc.business.doc.service.IDocCategoryRoleRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import redis.clients.jedis.Jedis;

/**
 * 文档分类角色关系
 * 
 * @author generator
 * 
 */
@Service("docCategoryRoleRelationService")
public class DocCategoryRoleRelationServiceImpl extends BaseServiceImpl<DocCategoryRoleRelationMapper, DocCategoryRoleRelationEntity> implements IDocCategoryRoleRelationService{

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private DocCategoryRoleRelationMapper docCategoryMapper;
	@Autowired
	private IDocCategoryService docCategoryService;
	@Autowired
	private CacheManager cacheManager;
	//当前用户的角色KEY
	private final static String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";
	
	
	@Override
	public CommonResponse<String> saveDocCategoryRole(List<DocCategoryRoleRelationVO> relationList) {
		List<DocCategoryRoleRelationEntity> addList = new ArrayList<>();
		String roleName = "";
		//1、判重
		QueryWrapper<DocCategoryRoleRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
		queryWrapper.eq("dr", 0);
		List<DocCategoryRoleRelationEntity> list = this.list(queryWrapper);
		Map<Long,DocCategoryRoleRelationEntity> map = new HashMap<>();
		if(list!=null&&list.size()>0){
			for(DocCategoryRoleRelationEntity relation : list){
				map.put(relation.getRoleId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
		}
		String message = "";
		Map<Long,String> orgMap = new HashMap<>();
		for(DocCategoryRoleRelationVO vo : relationList){
			if(map.get(vo.getRoleId())==null){
				if(orgMap.get(vo.getRoleOrgId())!=null){
					vo.setRoleOrgName(orgMap.get(vo.getRoleOrgId()));
				}else{
					String orgName = vo.getRoleOrgId().toString();
					if(vo.getRoleOrgId()!=null){
						try {
							JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getRoleOrgId().toString(), "idm-org");
							if(jArray!=null&&jArray.size()>0){
								JSONObject json = (JSONObject) jArray.get(0);
								orgName = json.get("name").toString();
							}
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					vo.setRoleOrgName(orgName);
					orgMap.put(vo.getRoleOrgId(), orgName);
				}
				addList.add(BeanMapper.map(vo, DocCategoryRoleRelationEntity.class));
			}else{
				if(message.length()>0){
					message += ("、"+vo.getRoleName());
				}else{
					message += vo.getRoleName();
				}
			}
		}
		//2、保存
		if(addList.size()>0){
			this.saveOrUpdateBatch(addList, addList.size(), false);
			for(DocCategoryRoleRelationEntity relation : addList){
				map.put(relation.getRoleId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
			DocCategoryEntity categoryEntity = docCategoryService.getById(relationList.get(0).getCategoryId());
			categoryEntity.setRoleName(roleName);
			docCategoryService.saveOrUpdate(categoryEntity, false);
			if(addList.size()!=relationList.size()){
				//有重复数据
				return CommonResponse.success("添加成功,其中以下角色："+message+"已存在");
			}
		}else{
			return CommonResponse.success("选择的角色都已在该分类下，请重新选择");
		}
		
		//
		return CommonResponse.success("添加成功");
	}

	@Override
	public CommonResponse<String> deleteDocCategoryRole(List<DocCategoryRoleRelationVO> relationList) {
		List<Long> ids = new ArrayList<>();
		for(DocCategoryRoleRelationVO vo : relationList){
			ids.add(vo.getId());
		}
		this.removeByIds(ids, false);

		String roleName = "";
		QueryWrapper<DocCategoryRoleRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
		queryWrapper.eq("dr", 0);
		List<DocCategoryRoleRelationEntity> list = this.list(queryWrapper);
		if(list!=null&&list.size()>0){
			for(DocCategoryRoleRelationEntity relation : list){
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
		}

		DocCategoryEntity categoryEntity = docCategoryService.getById(relationList.get(0).getCategoryId());
		categoryEntity.setRoleName(roleName);
		docCategoryService.saveOrUpdate(categoryEntity, false);
		return CommonResponse.success("删除成功");
	}

	@SuppressWarnings("rawtypes")
	@Override
	public CommonResponse<JSONObject> getListByUserId(Long userId) {
		if(userId == null)
			userId = InvocationInfoProxy.getUserid();
		JSONObject jsonObject = new JSONObject();
		//获取当前用户的角色
		List<Long> roleList = this.getUserRoleCache(userId);
		if(ListUtil.isNotEmpty(roleList)){
			//获取有角色权限的分类
			QueryWrapper<DocCategoryRoleRelationEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.in("role_id", roleList);
			queryWrapper.eq("dr", 0);
			List<DocCategoryRoleRelationEntity> list = this.list(queryWrapper);
			if(list!=null&&list.size()>0){
				List<Long> categoryIds = new ArrayList<>();
				for(DocCategoryRoleRelationEntity entity : list){
					categoryIds.add(entity.getCategoryId());
				}
				QueryWrapper<DocCategoryEntity> wrapper = new QueryWrapper<>();
				wrapper.eq("dr", 0);
//			wrapper.in("id", categoryIds);
				//查询分类的本下数据
				wrapper.and(war -> {
					categoryIds.forEach(e -> {
						if(categoryIds.indexOf(e)==categoryIds.size()-1){
							war.like("inner_code", e);
						}else{
							war.like("inner_code", e).or();
						}
					});
					return war;
				});
				List<DocCategoryEntity> docCategoryList = docCategoryService.list(wrapper);
				List<Map> resultMapList = BeanMapper.mapList(docCategoryList, Map.class);
				jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
			}else{
				jsonObject.put("data", null);
			}
		}else{
			jsonObject.put("data", null);
		}

		return CommonResponse.success("查询列表数据成功！",jsonObject);
	}

	@Override
	public List<DocCategoryEntity> getAllByUserId(Long userId, String searchText) {
		List<DocCategoryEntity> docCategoryList = new ArrayList<>();
		//获取当前用户的角色
		List<Long> roleList = this.getUserRoleCache(userId);
		if(ListUtil.isNotEmpty(roleList)){
			//获取有角色权限的分类
			QueryWrapper<DocCategoryRoleRelationEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.in("role_id", roleList);
			queryWrapper.eq("dr", 0);
			List<DocCategoryRoleRelationEntity> list = this.list(queryWrapper);
			if(CollectionUtils.isNotEmpty(list)){
				List<Long> categoryIds = new ArrayList<>();
				for(DocCategoryRoleRelationEntity entity : list){
					categoryIds.add(entity.getCategoryId());
				}
				QueryWrapper<DocCategoryEntity> wrapper = new QueryWrapper<>();
				wrapper.eq("dr", 0);
//			wrapper.in("id", categoryIds);
				//查询分类的本下数据
				StringBuffer sb = new StringBuffer();
				wrapper.and(war -> {
					categoryIds.forEach(e -> {
						if(categoryIds.indexOf(e)==categoryIds.size()-1){
							war.like("inner_code", e);
							sb.append("inner_code like %" + e +"%");
						}else{
							war.like("inner_code", e).or();
							sb.append("inner_code like %" + e +"% or");
						}
					});
					return war;
				});
				if(StringUtils.isNotBlank(searchText)) {
					wrapper.like("category_name", searchText);
				}
				logger.info("SQL语句->{}", sb.toString());
				docCategoryList = docCategoryService.list(wrapper);
			}
		}
		return docCategoryList;
	}

	public List<Long> getUserRoleCache(Long userId) {
		List<Long> resultList = new ArrayList<Long>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		String key = CURRENTUSER_ROLE_KEY + userId + "-" + tenantId;
		Set<String> roleIds = cacheManager.execute(new CacheManager.JedisAction<Set<String>>() {
			@Override
			public Set<String> action(Jedis jedis) {
				return jedis.smembers(key);
			}
		});
		if(roleIds != null && !roleIds.isEmpty()) {
			for(String roleId:roleIds) {
				resultList.add(Long.parseLong(roleId));
			}
		}
		return resultList;
	}
}
