package com.ejianc.business.doc.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ResultAsTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.vo.KbmCategoryVO;

/**
 * 知识分类
 *
 * @author generator
 */
@Controller
@RequestMapping("kbmCategory")
public class KbmCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKbmCategoryService service;
    @Autowired
    private IKbmService kbmService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KbmCategoryVO> saveOrUpdate(@RequestBody KbmCategoryVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmCategoryVO> queryDetail(Long id) {
        KbmCategoryEntity entity = service.selectById(id);
        KbmCategoryVO vo = BeanMapper.map(entity, KbmCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KbmCategoryVO> vos) {
        // todo 批量删除之前要判断分类下有没有数据
        List<Long> ids = vos.stream().map(KbmCategoryVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<KbmEntity> lambdaQueryWrapper=new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(KbmEntity::getCategoryId,ids);
        List<KbmEntity> list = kbmService.list(lambdaQueryWrapper);
        if(list!=null&&list.size()>0){
            throw new BusinessException("该分类下存在文件，不能删除！");
        }
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("id","asc");
        List<KbmCategoryEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * @param id：分类id；enable：将要启停用的状态，启用true停用false
     * @Description 启停用
     */
    @RequestMapping(value = "/enabled", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam boolean enable) {
        KbmCategoryEntity entity = service.selectById(id);
        //父级停用所有子级停用；父级开启所有子级开启；子级开启一个,父级开启；子级全部停用，父级停用
        if (enable) {
            //启用
            //1、查询所有下级
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
            List<KbmCategoryEntity> editList = service.queryList(param, false);
            //2、子级开启一个,父级开启
            List<KbmCategoryVO> parents = service.findParentsById(id);
            for (KbmCategoryVO vo : parents) {
                if (!vo.getId().equals(id)) {//去除本级
                    //寻找到上级启用的节点为止
                    if ("0".equals(vo.getEnabled())) {
                        editList.add(BeanMapper.map(vo, KbmCategoryEntity.class));
                    } else {
                        break;
                    }
                }
            }
            for (KbmCategoryEntity en : editList) {
                en.setEnabled("1");
            }
            service.saveOrUpdateBatch(editList, editList.size(), false);
            return CommonResponse.success("启用成功！");
        } else {
            //停用
            //1、父级停用所有子级停用
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
            List<KbmCategoryEntity> editList = service.queryList(param, false);
            for (KbmCategoryEntity en : editList) {
                en.setEnabled("0");
            }
            service.saveOrUpdateBatch(editList, editList.size(), false);
            //2、子级全部停用，父级停用---需求不合理，注掉
            /*if(entity.getPid()!=null){
                //获取父级的详细信息，
            	KbmCategoryEntity pentity = service.selectById(entity.getPid());
            	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, pentity.getInnerCode()));
                List<KbmCategoryEntity> pEditList = service.queryList(param,false);
                boolean flag = true;
                for (KbmCategoryEntity en : editList) {
                	if(!en.getId().equals(entity.getPid())){//非父节点本身
                		//若其子节点中存在启用的节点，则不需要停用父节点
                		if("1".equals(en.getEnabled())){
                			flag = false;
                		}
                	}
    			}
                if(flag){
                	//子级全部停用，停用父级
                	pentity.setEnabled("0");
                	service.saveOrUpdate(pentity, false);
                }
            }*/
            return CommonResponse.success("停用成功！");
        }
    }
    /*********************权限树查询start*********************/
    /**
     * @param param
     * @Description queryList 管理员分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/adminTreeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> adminTreeList(@RequestBody QueryParam param) {
        return service.adminTreeList(param);
    }

    /**
     * @param param
     * @Description queryList 用户访问权限分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/userAccessTreeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> userTreeList(@RequestBody QueryParam param) {
        return service.userTreeList(param);
    }

    /**
     * 管理员查询本下分类
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/adminFindChildrenId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> adminFindChildrenId(Long id) {
        return service.adminFindChildrenId(id);
    }

    /**
     * 用户权限查询本下分类
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/userFindChildrenId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> userFindChildrenId(Long id) {
        return service.userFindChildrenId(id);
    }

    /**
     * @param param
     * @Description queryList 用户上传权限
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/userUploadTreeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> userUploadTreeList(@RequestBody QueryParam param) {
        return service.userUploadTreeList(param);
    }

    /**
     * 根据用户主键和分类主键，判断有无访问权限  返回：true/false
     *
     * @param userId
     * @param categoryId
     * @return
     */
    @RequestMapping(value = "/kbmAccess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> kbmAccess(Long userId, Long categoryId) {
        return service.kbmAccess(userId, categoryId);
    }

    /**
     * 查询用户访问权限，不构造树
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/userAccessQueryList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> userAccessQueryList(Long userId) {
        return service.userAccessQueryList(userId);
    }

    /**
     * 根据分类主键和对应的文件夹数量构建树形
     *
     * @param accessMap<分类主键，文件数量>
     * @return
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/accessToTreeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> accessToTreeList(@RequestBody Map<Long, Integer> accessMap) {
        return service.accessToTreeList(accessMap);
    }

    /*********************权限树查询end*********************/

}
