/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.DocCategoryBillTypeRelationEntity;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.DocCategoryRoleRelationEntity;
import com.ejianc.business.doc.mapper.DocCategoryRoleRelationMapper;
import com.ejianc.business.doc.service.IDocCategoryBillTypeRelationService;
import com.ejianc.business.doc.service.IDocCategoryRoleRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service(value="docCategoryRoleRelationService")
public class DocCategoryRoleRelationServiceImpl
extends BaseServiceImpl<DocCategoryRoleRelationMapper, DocCategoryRoleRelationEntity>
implements IDocCategoryRoleRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DocCategoryRoleRelationMapper docCategoryMapper;
    @Autowired
    private IDocCategoryService docCategoryService;
    @Autowired
    private CacheManager cacheManager;
    private static final String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";
    @Autowired
    private IDocCategoryBillTypeRelationService billTypeRelationService;

    @Override
    public CommonResponse<String> saveDocCategoryRole(List<DocCategoryRoleRelationVO> relationList) {
        ArrayList<Object> addList = new ArrayList<Object>();
        String roleName = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"category_id", (Object)relationList.get(0).getCategoryId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        HashMap<Long, DocCategoryRoleRelationEntity> map = new HashMap<Long, DocCategoryRoleRelationEntity>();
        if (list != null && list.size() > 0) {
            for (DocCategoryRoleRelationEntity relation : list) {
                map.put(relation.getRoleId(), relation);
                if (roleName.length() > 0) {
                    roleName = roleName + "\u3001" + relation.getRoleName();
                    continue;
                }
                roleName = roleName + relation.getRoleName();
            }
        }
        String message = "";
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        for (DocCategoryRoleRelationVO docCategoryRoleRelationVO : relationList) {
            if (map.get(docCategoryRoleRelationVO.getRoleId()) == null) {
                if (orgMap.get(docCategoryRoleRelationVO.getRoleOrgId()) != null) {
                    docCategoryRoleRelationVO.setRoleOrgName((String)orgMap.get(docCategoryRoleRelationVO.getRoleOrgId()));
                } else {
                    String orgName = docCategoryRoleRelationVO.getRoleOrgId().toString();
                    if (docCategoryRoleRelationVO.getRoleOrgId() != null) {
                        try {
                            JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)docCategoryRoleRelationVO.getRoleOrgId().toString(), (String)"idm-org");
                            if (jArray != null && jArray.size() > 0) {
                                JSONObject json = (JSONObject)jArray.get(0);
                                orgName = json.get((Object)"name").toString();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    docCategoryRoleRelationVO.setRoleOrgName(orgName);
                    orgMap.put(docCategoryRoleRelationVO.getRoleOrgId(), orgName);
                }
                addList.add(BeanMapper.map((Object)((Object)docCategoryRoleRelationVO), DocCategoryRoleRelationEntity.class));
                continue;
            }
            if (message.length() > 0) {
                message = message + "\u3001" + docCategoryRoleRelationVO.getRoleName();
                continue;
            }
            message = message + docCategoryRoleRelationVO.getRoleName();
        }
        if (addList.size() > 0) {
            this.saveOrUpdateBatch(addList, addList.size(), false);
            for (DocCategoryRoleRelationEntity docCategoryRoleRelationEntity : addList) {
                map.put(docCategoryRoleRelationEntity.getRoleId(), docCategoryRoleRelationEntity);
                if (roleName.length() > 0) {
                    roleName = roleName + "\u3001" + docCategoryRoleRelationEntity.getRoleName();
                    continue;
                }
                roleName = roleName + docCategoryRoleRelationEntity.getRoleName();
            }
            DocCategoryEntity categoryEntity = (DocCategoryEntity)((Object)this.docCategoryService.getById(relationList.get(0).getCategoryId()));
            categoryEntity.setRoleName(roleName);
            this.docCategoryService.saveOrUpdate((Object)categoryEntity, false);
            if (addList.size() != relationList.size()) {
                return CommonResponse.success((String)("\u6dfb\u52a0\u6210\u529f,\u5176\u4e2d\u4ee5\u4e0b\u89d2\u8272\uff1a" + message + "\u5df2\u5b58\u5728"));
            }
        } else {
            return CommonResponse.success((String)"\u9009\u62e9\u7684\u89d2\u8272\u90fd\u5df2\u5728\u8be5\u5206\u7c7b\u4e0b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        return CommonResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public CommonResponse<String> deleteDocCategoryRole(List<DocCategoryRoleRelationVO> relationList) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DocCategoryRoleRelationVO vo : relationList) {
            ids.add(vo.getId());
        }
        this.removeByIds(ids, false);
        String roleName = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"category_id", (Object)relationList.get(0).getCategoryId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            for (DocCategoryRoleRelationEntity relation : list) {
                if (roleName.length() > 0) {
                    roleName = roleName + "\u3001" + relation.getRoleName();
                    continue;
                }
                roleName = roleName + relation.getRoleName();
            }
        }
        DocCategoryEntity categoryEntity = (DocCategoryEntity)((Object)this.docCategoryService.getById(relationList.get(0).getCategoryId()));
        categoryEntity.setRoleName(roleName);
        this.docCategoryService.saveOrUpdate((Object)categoryEntity, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public CommonResponse<JSONObject> getListByUserId(Long userId) {
        if (userId == null) {
            userId = InvocationInfoProxy.getUserid();
        }
        JSONObject jsonObject = new JSONObject();
        List<Long> roleList = this.getUserRoleCache(userId);
        if (ListUtil.isNotEmpty(roleList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"role_id", roleList);
            queryWrapper.eq((Object)"dr", (Object)0);
            List list = this.list((Wrapper)queryWrapper);
            if (list != null && list.size() > 0) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                for (DocCategoryRoleRelationEntity entity : list) {
                    categoryIds.add(entity.getCategoryId());
                }
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"dr", (Object)0);
                wrapper.and(war -> {
                    categoryIds.forEach(e -> {
                        if (categoryIds.indexOf(e) == categoryIds.size() - 1) {
                            war.like((Object)"inner_code", e);
                        } else {
                            ((QueryWrapper)war.like((Object)"inner_code", e)).or();
                        }
                    });
                    return war;
                });
                List docCategoryList = this.docCategoryService.list((Wrapper)wrapper);
                List resultMapList = BeanMapper.mapList((Iterable)docCategoryList, Map.class);
                jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
            } else {
                jsonObject.put("data", null);
            }
        } else {
            jsonObject.put("data", null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public List<DocCategoryEntity> getAllByUserId(Long userId, String searchText) {
        List<DocCategoryEntity> docCategoryList = new ArrayList<DocCategoryEntity>();
        List<Long> roleList = this.getUserRoleCache(userId);
        if (ListUtil.isNotEmpty(roleList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"role_id", roleList);
            queryWrapper.eq((Object)"dr", (Object)0);
            List list = this.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                for (DocCategoryRoleRelationEntity entity : list) {
                    categoryIds.add(entity.getCategoryId());
                }
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"dr", (Object)0);
                StringBuffer sb = new StringBuffer();
                wrapper.and(war -> {
                    categoryIds.forEach(e -> {
                        if (categoryIds.indexOf(e) == categoryIds.size() - 1) {
                            war.like((Object)"inner_code", e);
                            sb.append("inner_code like %" + e + "%");
                        } else {
                            ((QueryWrapper)war.like((Object)"inner_code", e)).or();
                            sb.append("inner_code like %" + e + "% or");
                        }
                    });
                    return war;
                });
                if (StringUtils.isNotBlank((String)searchText)) {
                    wrapper.like((Object)"category_name", (Object)searchText);
                }
                this.logger.info("SQL\u8bed\u53e5->{}", (Object)sb.toString());
                docCategoryList = this.docCategoryService.list((Wrapper)wrapper);
            }
        }
        return docCategoryList;
    }

    @Override
    public List<DocCategoryEntity> getAllByBillType(String billTypeCode, String searchText) {
        List<DocCategoryEntity> docCategoryList = new ArrayList<DocCategoryEntity>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_type_code", (Object)billTypeCode);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.billTypeRelationService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            for (DocCategoryBillTypeRelationEntity entity : list) {
                categoryIds.add(entity.getCategoryId());
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"dr", (Object)0);
            StringBuffer sb = new StringBuffer();
            wrapper.and(war -> {
                categoryIds.forEach(e -> {
                    if (categoryIds.indexOf(e) == categoryIds.size() - 1) {
                        war.apply(e + " like concat(inner_code, '%')", new Object[0]);
                    } else {
                        ((QueryWrapper)war.like((Object)"inner_code", e)).or();
                        sb.append("inner_code like %" + e + "% or");
                    }
                });
                return war;
            });
            if (StringUtils.isNotBlank((String)searchText)) {
                wrapper.like((Object)"category_name", (Object)searchText);
            }
            this.logger.info("SQL\u8bed\u53e5->{}", (Object)sb.toString());
            docCategoryList = this.docCategoryService.list((Wrapper)wrapper);
        }
        return docCategoryList;
    }

    public List<Long> getUserRoleCache(Long userId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        final String key = CURRENTUSER_ROLE_KEY + userId + "-" + tenantId;
        Set roleIds = (Set)this.cacheManager.execute((CacheManager.JedisAction)new CacheManager.JedisAction<Set<String>>(){

            public Set<String> action(Jedis jedis) {
                return jedis.smembers(key);
            }
        });
        if (roleIds != null && !roleIds.isEmpty()) {
            for (String roleId : roleIds) {
                resultList.add(Long.parseLong(roleId));
            }
        }
        return resultList;
    }
}

