package com.ejianc.business.doc.controller;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.doc.bean.KbmCategoryUploadEntity;
import com.ejianc.business.doc.service.IKbmCategoryUploadService;
import com.ejianc.business.doc.vo.KbmCategoryUploadVO;

/**
 * 知识分类上传权限
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("kbmCategoryUpload")
public class KbmCategoryUploadController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IKbmCategoryUploadService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KbmCategoryUploadVO> saveOrUpdate(@RequestBody KbmCategoryUploadVO saveorUpdateVO) {
    	KbmCategoryUploadEntity entity = BeanMapper.map(saveorUpdateVO, KbmCategoryUploadEntity.class);
    	service.saveOrUpdate(entity, false);
    	KbmCategoryUploadVO vo = BeanMapper.map(entity, KbmCategoryUploadVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmCategoryUploadVO> queryDetail(Long id) {
    	KbmCategoryUploadEntity entity = service.selectById(id);
    	KbmCategoryUploadVO vo = BeanMapper.map(entity, KbmCategoryUploadVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KbmCategoryUploadVO> vos) {
        service.removeByIds(vos.stream().map(KbmCategoryUploadVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KbmCategoryUploadVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<KbmCategoryUploadEntity> page = service.queryPage(param,false);
        IPage<KbmCategoryUploadVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KbmCategoryUploadVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /*********************角色start*********************/
    /**
     * @Description queryList 查询角色列表信息
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryRoleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KbmCategoryUploadVO>> queryRoleList(@RequestBody QueryParam param) {

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<KbmCategoryUploadEntity> page = service.queryPage(param,false);

        IPage<KbmCategoryUploadVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KbmCategoryUploadVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 保存套餐角色关系
     *
     *
     *
     * @return
     */
    @RequestMapping(value = "/saveKbmCategoryRole", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveKbmCategoryRole(@RequestBody List<KbmCategoryUploadVO> relationList) {
        return service.saveKbmCategoryRole(relationList);
    }

    /**
     * 删除授权角色
     *
     *
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/deleteKbmCategoryRole", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteKbmCategoryRole(@RequestBody List<KbmCategoryUploadVO> relationList) {
        return service.deleteKbmCategoryRole(relationList);
    }
    /*********************角色end*********************/
}
