package com.ejianc.business.doc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.vo.KbmCollectDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 收藏夹详情
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("kbmCollectDetail")
public class KbmCollectDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKbmCollectDetailService kbmCollectDetailService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KbmCollectDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

        IPage<KbmCollectDetailEntity> page= kbmCollectDetailService.queryPage(param,false);
        IPage<KbmCollectDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<KbmCollectDetailVO> collectVOList = BeanMapper.mapList(page.getRecords(), KbmCollectDetailVO.class);
        pageData.setRecords(collectVOList);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
