package com.ejianc.business.doc.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.business.doc.bean.*;
import com.ejianc.business.doc.service.*;
import com.ejianc.business.doc.vo.DocCategoryBillTypeRelationVO;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import sun.misc.BASE64Encoder;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.business.doc.vo.DocCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 文档分类
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("docCategory")
public class DocCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDocCategoryService service; 
    @Autowired
    private IDocCategoryRoleRelationService relationService;
	@Autowired
	private IProjectDocService projectDocService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IMyFavoriteService myFavoriteService;
	@Autowired
	private IViewLogService viewLogService;

	@Autowired
	private IDocCategoryBillTypeRelationService billTypeRelationService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DocCategoryVO> saveOrUpdate(@RequestBody DocCategoryVO saveorUpdateVO) {
		if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
			DocCategoryEntity uniqueBean = service.selectById(saveorUpdateVO.getId());
			uniqueBean.setCategoryName(saveorUpdateVO.getCategoryName());
			uniqueBean.setNum(saveorUpdateVO.getNum());
			uniqueBean.setRequired(saveorUpdateVO.getRequired());
			service.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功！");
		}else{
	    	DocCategoryEntity entity = BeanMapper.map(saveorUpdateVO, DocCategoryEntity.class);
	    	entity.setId(IdWorker.getId());
	    	entity.setEnabled("1");
			if(entity.getParentId() != null && entity.getParentId() > 0) {
				DocCategoryEntity uniqueBean = service.selectById(entity.getParentId());
				entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
			} else {
				entity.setInnerCode(entity.getId().toString());
			}
			service.saveOrUpdate(entity, false);
	    	return CommonResponse.success("保存成功！");
		}
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocCategoryVO> queryDetail(Long id) {
    	DocCategoryEntity entity = service.selectById(id);
    	DocCategoryVO vo = BeanMapper.map(entity, DocCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocCategoryVO> vos) {
        service.removeByIds(vos.stream().map(DocCategoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询分类树
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
    	List<DocCategoryEntity> list = service.queryList(param,false);

		List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }

    /**
     * @Description 启停用
     * @param id：分类id；enable：将要启停用的状态，启用true停用false
     */
    @RequestMapping(value = "/enabled", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam boolean enable) {
    	DocCategoryEntity entity = service.selectById(id);
    	//父级停用所有子级停用；父级开启所有子级开启；子级开启一个,父级开启；子级全部停用，父级停用
    	if(enable){
    		//启用
    		//1、查询所有下级
    		QueryParam param = new QueryParam();
        	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
            List<DocCategoryEntity> editList = service.queryList(param,false);
            //2、子级开启一个,父级开启
            List<DocCategoryVO> parents = service.findParentsById(id);
            for(DocCategoryVO vo : parents){
            	if(!vo.getId().equals(id)){//去除本级
            		//寻找到上级启用的节点为止
            		if("0".equals(vo.getEnabled())){
            			editList.add(BeanMapper.map(vo, DocCategoryEntity.class));
            		}else{
            			break;
            		}
            	}
            }
            for (DocCategoryEntity en : editList) {
            	en.setEnabled("1");
			}
            service.saveOrUpdateBatch(editList, editList.size(), false);
            return CommonResponse.success("启用成功！");
    	}else{
    		//停用
    		//1、父级停用所有子级停用
    		QueryParam param = new QueryParam();
        	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
            List<DocCategoryEntity> editList = service.queryList(param,false);
            for (DocCategoryEntity en : editList) {
            	en.setEnabled("0");
			}
            service.saveOrUpdateBatch(editList, editList.size(), false);
            //2、子级全部停用，父级停用---需求不合理，注掉
            /*if(entity.getPid()!=null){
                //获取父级的详细信息，
            	DocCategoryEntity pentity = service.selectById(entity.getPid());
            	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, pentity.getInnerCode()));
                List<DocCategoryEntity> pEditList = service.queryList(param,false);
                boolean flag = true;
                for (DocCategoryEntity en : editList) {
                	if(!en.getId().equals(entity.getPid())){//非父节点本身
                		//若其子节点中存在启用的节点，则不需要停用父节点
                		if("1".equals(en.getEnabled())){
                			flag = false;
                		}
                	}
    			}
                if(flag){
                	//子级全部停用，停用父级
                	pentity.setEnabled("0");
                	service.saveOrUpdate(pentity, false);
                }
            }*/
            return CommonResponse.success("停用成功！");
    	}
    }
    
    /**
     * @Description getListByUserId 查询详情
     * @param id
     */
    @RequestMapping(value = "/getListByUserId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getListByUserId(@RequestParam(required = false) Long userId) {
        return relationService.getListByUserId(userId);
    }

    @GetMapping(value = "/categoryTreeRef")
	@ResponseBody
	public List<Map<String, Object>> categoryTreeRef(@RequestParam(value = "searchText", required = false) String searchText) {
    	Long userId = InvocationInfoProxy.getUserid();
		List<DocCategoryEntity> categoryEntities = relationService.getAllByUserId(userId, searchText);
		List<Map> resultMapList = BeanMapper.mapList(categoryEntities, Map.class);
		return ResultAsTree.createTreeData(resultMapList);
	}

    /*********************角色start*********************/
    /**
     * @Description queryList 查询角色列表信息
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
	@RequestMapping(value = "/queryRoleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DocCategoryRoleRelationVO>> queryRoleList(@RequestBody QueryParam param) {
		
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	IPage<DocCategoryRoleRelationEntity> page = relationService.queryPage(param,false);
    	
    	IPage<DocCategoryRoleRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocCategoryRoleRelationVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

	/**
	 * 保存套餐角色关系
	 * 
	 * 
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveDocCategoryRole", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveDocCategoryRole(@RequestBody List<DocCategoryRoleRelationVO> relationList) {
		return relationService.saveDocCategoryRole(relationList);
	}

	/**
	 * 删除授权角色
	 * 
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/deleteDocCategoryRole", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteDocCategoryRole(@RequestBody List<DocCategoryRoleRelationVO> relationList) {
		return relationService.deleteDocCategoryRole(relationList);
	}
    /*********************角色end*********************/


    /**
	 * 查询分类文件夹 从根目录/查询
     * */
	@RequestMapping(value = "/folders", method = RequestMethod.GET)
	@ResponseBody
	public JSONArray folders(@RequestParam(required = false,value = "id") String id) {
		CommonResponse<JSONObject> response = relationService.getListByUserId(InvocationInfoProxy.getUserid());
		JSONArray res = new JSONArray();
		if(response.isSuccess() && response.getData().get("data")!=null){
			List<Map<String, Object>> data = (List<Map<String, Object>>)response.getData().get("data");
			data.forEach(m->{
				JSONObject fo = new JSONObject();
				fo.putIfAbsent("id",m.get("id"));
				fo.putIfAbsent("value",m.get("categoryName"));
				fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",(Date)m.get("createTime")));
				fo.putIfAbsent("size",0);

				QueryParam param = new QueryParam();
				param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
				param.getParams().put("fileId",new Parameter(QueryParam.EQ,m.get("id")));
				List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
				if(ListUtil.isNotEmpty(favoriteEntities)){
					fo.putIfAbsent("star",true);
				}
				fo.putIfAbsent("type","folder");
				if(m.get("children")!=null){
					List<JSONObject> r = getData((ArrayList)m.get("children"));
					fo.putIfAbsent("data",r);
				}
				res.add(fo);
			});
		}
		return res;
	}

	private List<JSONObject> getData(ArrayList children){
		List<JSONObject> data = new ArrayList<>();
		for (int i = 0; i < children.size(); i++) {
			JSONObject d = new JSONObject();
			HashMap m = (HashMap)children.get(i);
			d.putIfAbsent("id",m.get("id"));
			d.putIfAbsent("value",m.get("categoryName"));
			d.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",(Date)m.get("createTime")));
			d.putIfAbsent("size",0);
			d.putIfAbsent("type","folder");
			QueryParam param = new QueryParam();
			param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
			param.getParams().put("fileId",new Parameter(QueryParam.EQ,m.get("id")));
			List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
			if(ListUtil.isNotEmpty(favoriteEntities)){
				d.putIfAbsent("star",true);
			}
			if(m.get("children")!=null){
				List<JSONObject> res = getData((ArrayList)m.get("children"));
				d.putIfAbsent("data",res);
			}
			data.add(d);
		}
		return data;
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/6/3 根据文件夹id 查询其下文件夹和文件
	 * @Description files
	 * @Param [id] 文件夹id
	 * @Return com.alibaba.fastjson.JSONArray
	 */
	@RequestMapping(value = "/files", method = RequestMethod.GET)
	@ResponseBody
	public JSONArray files(@RequestParam(required = false,value = "id") String id,@RequestParam(required = false,value = "source") String source) {
		if("/".equals(id)){
			if("trash".equals(source)){
				return new JSONArray();
			}
			if("favorite".equals(source)){
				JSONArray favorite = new JSONArray();
				QueryParam param = new QueryParam();
				param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
				List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
				if(ListUtil.isNotEmpty(favoriteEntities)){
					favoriteEntities.forEach(f->{
						if("folder".equals(f.getFileType())){//文件夹
							DocCategoryEntity m = service.selectById(f.getFileId());
							JSONObject fo = new JSONObject();
							fo.putIfAbsent("id",m.getId());
							fo.putIfAbsent("value",m.getCategoryName());
							fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",m.getCreateTime()));
							fo.putIfAbsent("size",0);
							fo.putIfAbsent("star",true);
							fo.putIfAbsent("type","folder");
							favorite.add(fo);
						}else {//文件
							CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(f.getFileId()+"");
							if(response.isSuccess()){
								AttachmentVO m = response.getData();
								JSONObject fo = new JSONObject();
								fo.putIfAbsent("id",m.getId());
								fo.putIfAbsent("value",m.getFileName());
								fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",m.getCreateTime()));
								fo.putIfAbsent("size",m.getFileSize());
								fo.putIfAbsent("filePath",m.getFilePath());
								fo.putIfAbsent("star",true);
								String type[] = m.getFileName().split("\\.") ;
								fo.putIfAbsent("type",getType(type[1]));
								favorite.add(fo);
							}
						}
					});
				}
				return favorite;
			}
			if("recent".equals(source)){
				JSONArray recent = new JSONArray();
				QueryParam param = new QueryParam();
				param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
				param.getOrderMap().put("createTime",QueryParam.DESC);
				param.setPageSize(20);
				IPage<ViewLogEntity> viewLogEntityIPage = viewLogService.queryPage(param,false);
				List<ViewLogEntity> favoriteEntities = viewLogEntityIPage.getRecords();
				if(ListUtil.isNotEmpty(favoriteEntities)){
					favoriteEntities.forEach(f->{
						if("folder".equals(f.getFileType())){//文件夹
							DocCategoryEntity m = service.selectById(f.getFileId());
							JSONObject fo = new JSONObject();
							fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",m.getCreateTime()));
							fo.putIfAbsent("id",m.getId());
							fo.putIfAbsent("size",0);
							fo.putIfAbsent("value",m.getCategoryName());

							QueryParam p = new QueryParam();
							p.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
							p.getParams().put("fileId",new Parameter(QueryParam.EQ,m.getId()));
							List<MyFavoriteEntity> fav = myFavoriteService.queryList(p,false);
							if(ListUtil.isNotEmpty(fav)){
								fo.putIfAbsent("star",true);
							}

							fo.putIfAbsent("type","folder");
							recent.add(fo);
						}else {//文件
							CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(f.getFileId()+"");
							if(response.isSuccess()){
								AttachmentVO m = response.getData();
								JSONObject fo = new JSONObject();
								fo.putIfAbsent("id",m.getId());
								fo.putIfAbsent("value",m.getFileName());
								fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",m.getCreateTime()));
								fo.putIfAbsent("filePath",m.getFilePath());
								fo.putIfAbsent("size",m.getFileSize());
								QueryParam p = new QueryParam();
								p.getParams().put("fileId",new Parameter(QueryParam.EQ,m.getId()));
								p.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
								List<MyFavoriteEntity> fav = myFavoriteService.queryList(p,false);
								if(ListUtil.isNotEmpty(fav)){
									fo.putIfAbsent("star",true);
								}
								String type[] = m.getFileName().split("\\.") ;
								fo.putIfAbsent("type",getType(type[1]));
								recent.add(fo);
							}
						}
					});
				}
				return recent;
			}
			return folders(id);
		}

		QueryParam queryParam = new QueryParam();
		Long categoryId = Long.valueOf(id);

		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getFuzzyFields().add("fileName");
		queryParam.getFuzzyFields().add("superviseUserName");
		queryParam.getOrderMap().put("superviseTime", QueryParam.DESC); //按归档时间倒序排列
		queryParam.getParams().put("docCategoryId", new Parameter(QueryParam.EQ, id));
		/** 查询文件夹下的文件 */
		List<ProjectDocEntity> fileList = projectDocService.queryList(queryParam,false);
		/** 查询文件夹下的文件夹 */
		List<DocCategoryEntity> folders = service.findDirectChildrenByPid(categoryId);
		JSONArray res = new JSONArray();
		if(ListUtil.isNotEmpty(folders)){
			folders.forEach(m->{
				JSONObject fo = new JSONObject();
				fo.putIfAbsent("id",m.getId());
				fo.putIfAbsent("value",m.getCategoryName());
				fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",m.getCreateTime()));
				fo.putIfAbsent("size",0);
				QueryParam param = new QueryParam();
				param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
				param.getParams().put("fileId",new Parameter(QueryParam.EQ,m.getId()));
				List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
				if(ListUtil.isNotEmpty(favoriteEntities)){
					fo.putIfAbsent("star",true);
				}
				fo.putIfAbsent("type","folder");
				res.add(fo);
			});
		}
		if(ListUtil.isNotEmpty(fileList)){
			fileList.forEach(m->{
				JSONObject fo = new JSONObject();
				fo.putIfAbsent("id",m.getFileId());
				fo.putIfAbsent("value",m.getFileName());
				fo.putIfAbsent("date",DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",m.getCreateTime()));
				fo.putIfAbsent("size",m.getFileSize());
				fo.putIfAbsent("filePath",m.getFilePath());

				QueryParam param = new QueryParam();
				param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
				param.getParams().put("fileId",new Parameter(QueryParam.EQ,m.getFileId()));
				List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
				if(ListUtil.isNotEmpty(favoriteEntities)){
					fo.putIfAbsent("star",true);
				}

				fo.putIfAbsent("type",getType(m.getFileType()));
				res.add(fo);
			});
		}
		/** 保存浏览历史 */
		ViewLogEntity viewLogEntity = new ViewLogEntity();
		viewLogEntity.setFileId(Long.parseLong(id));
		viewLogEntity.setFileType("folder");
		viewLogService.saveOrUpdate(viewLogEntity,false);
		/** 保存浏览历史 */

		return res;
	}

	private String getType(String fileName){
		String type ;
		if("txt".equals(fileName.toLowerCase())){
			type = "code";
		}else if("xls".equals(fileName.toLowerCase()) ||
				"xlsx".equals(fileName.toLowerCase()) ||
				"bat".equals(fileName.toLowerCase()) ||
				"doc".equals(fileName.toLowerCase())  ||
				"docx".equals(fileName.toLowerCase()) ||
				"zip".equals(fileName.toLowerCase()) ||
				"csv".equals(fileName.toLowerCase())  ||
				"exe".equals(fileName.toLowerCase())  ||
				"jar".equals(fileName.toLowerCase())  ||
				"log".equals(fileName.toLowerCase())  ||
				"msi".equals(fileName.toLowerCase())  ||
				"iso".equals(fileName.toLowerCase())  ||
				"pdf".equals(fileName.toLowerCase())  ||
				"rar".equals(fileName.toLowerCase())  ||
				"swf".equals(fileName.toLowerCase())  ||
				"ppt".equals(fileName.toLowerCase())  ||
				"pptx".equals(fileName.toLowerCase())
		){
			type = "document";
		}else if(
				"mp3".equals(fileName.toLowerCase()) ||
				"wma".equals(fileName.toLowerCase())  ||
				"aac".equals(fileName.toLowerCase())
		){
			type = "audio";
		}else if(
				"3gp".equals(fileName.toLowerCase()) ||
				"mp4".equals(fileName.toLowerCase()) ||
				"avi".equals(fileName.toLowerCase()) ||
				"mkv".equals(fileName.toLowerCase())  ||
				"rm".equals(fileName.toLowerCase())  ||
				"rmvb".equals(fileName.toLowerCase())  ||
				"mov".equals(fileName.toLowerCase())  ||
				"mod".equals(fileName.toLowerCase())  ||
				"wmv".equals(fileName.toLowerCase())  ||
				"ogg".equals(fileName.toLowerCase())
		){
			type = "video";
		}else if(
				"jpg".equals(fileName.toLowerCase()) ||
				"png".equals(fileName.toLowerCase()) ||
				"gif".equals(fileName.toLowerCase()) ||
				"jpeg".equals(fileName.toLowerCase())||
				"bmp".equals(fileName.toLowerCase())
		){
			type = "image";
		}else {
			logger.info("未知格式：{}",fileName);
			type = "unknown";
		}
		return type;
	}

	/**
	 * 预览数据
	* */
	@RequestMapping(value = {"/preview","/direct"})
	public void preview(@RequestParam(required = false,value = "id") String id, HttpServletResponse httpServletResponse){
		CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(id);
		if(response.isSuccess()){
			AttachmentVO file = response.getData();
			HttpURLConnection httpUrl = null;
			URL url = null;
			OutputStream os = null;
			InputStream inputStream = null;
			try {
				url = new URL(file.getTruePath());
				httpUrl = (HttpURLConnection) url.openConnection();
				httpUrl.connect();
				inputStream = httpUrl.getInputStream();
				os = httpServletResponse.getOutputStream();
				int count ;
				byte[] buffer = new byte[1024 * 8];
				while ((count = inputStream.read(buffer)) != -1) {
					os.write(buffer, 0, count);
					os.flush();
				}
			} catch (IOException | ClassCastException e) {
			} finally {
				try {
					httpUrl.disconnect();
					inputStream.close();
					os.close();
				} catch (NullPointerException | IOException e) {
				}
			}
		}
	}

	@RequestMapping(value = "upload",method = RequestMethod.POST)
	@ResponseBody
	public JSONObject upload(@RequestParam("id") String id, HttpServletRequest request){
		JSONObject resFile = new JSONObject();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获取file框的
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		//文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		//文件类型判断
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			MultipartFile mf = entity.getValue();
			String originalFilename = mf.getOriginalFilename();
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			fileList.add(mf);
		}
		for (MultipartFile file:fileList){
			String contentType = file.getContentType();

			byte[] imageBytes = new byte[0];
			try {
				imageBytes = file.getBytes();
			} catch (IOException e) {
				e.printStackTrace();
			}

			BASE64Encoder base64Encoder =new BASE64Encoder();

			String base64EncoderImg = "data:" + contentType + ";base64," + base64Encoder.encode(imageBytes);

			base64EncoderImg = base64EncoderImg.replaceAll("[\\s*\t\n\r]", "");

			AttachmentRequestVO attachmentRequestVO = new AttachmentRequestVO();
			attachmentRequestVO.setBillType("BT201201000000001");
			attachmentRequestVO.setSourceType("projectDocMgr");
			attachmentRequestVO.setSourceId(id);
			attachmentRequestVO.setFileList(Collections.singletonList(base64EncoderImg));
			CommonResponse<List<AttachmentVO>> att = attachmentApi.uploadForBase64(attachmentRequestVO);
			if(att.isSuccess()){
				List<AttachmentVO> list = att.getData();
				AttachmentVO attachmentVO = list.get(0);
				resFile.putIfAbsent("id",attachmentVO.getId());
				resFile.putIfAbsent("value",attachmentVO.getFileName());
				resFile.putIfAbsent("filePath",attachmentVO.getFilePath());
				resFile.putIfAbsent("date", DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",attachmentVO.getCreateTime()));
				resFile.putIfAbsent("size",attachmentVO.getFileSize());
				resFile.putIfAbsent("type",getType(attachmentVO.getFileName().split("\\.")[1]));

				ProjectDocEntity docEntity = new ProjectDocEntity();
				docEntity.setDocCategoryId(Long.valueOf(id));
				docEntity.setDocSource("1");
				docEntity.setFileId(attachmentVO.getId());
				docEntity.setFileName(attachmentVO.getFileName());
				docEntity.setFilePath(attachmentVO.getFilePath());
				docEntity.setFileSize(attachmentVO.getFileSize());
				docEntity.setFileType(attachmentVO.getFileName().split("\\.")[1]);
				docEntity.setOnlinePath(attachmentVO.getOnlinePath());
				docEntity.setOrgId(InvocationInfoProxy.getOrgId());
				docEntity.setSuperviseTime(new Date());
				docEntity.setSuperviseUserId(InvocationInfoProxy.getUserid());
				docEntity.setSuperviseUserName(InvocationInfoProxy.getUsercode());
				projectDocService.saveOrUpdate(docEntity,false);
			}
		}
		return resFile;
	}

	@RequestMapping(value = "info",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject info(){
		JSONObject info = new JSONObject();
		JSONObject features = new JSONObject();
		JSONObject meta = new JSONObject();
		meta.putIfAbsent("audio",true);
		meta.putIfAbsent("image",true);
		features.putIfAbsent("meta",meta);
		JSONObject preview = new JSONObject();
		preview.putIfAbsent("code",true);
		preview.putIfAbsent("document",true);
		preview.putIfAbsent("image",true);
		features.putIfAbsent("preview",preview);

		JSONObject stats = new JSONObject();
		stats.putIfAbsent("free",102400000);
		stats.putIfAbsent("total",102400000);
		stats.putIfAbsent("used",51200000);

		info.putIfAbsent("stats",stats);
		info.putIfAbsent("features",features);

		return info;
	}

	/**
	 * 根据文件id查询文件或者图片的详细信息
	 * 返回值JSONObject中，key是信息标题名称，value是信息值
	 * 比如：
	 * "项目名称":"小牛山项目"
	 * "上传日期":"2021-02-21"
	 * */
	@RequestMapping(value = "meta",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject meta(@RequestParam("id") String id){
		CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(id);
		JSONObject info = new JSONObject();
		if(response.isSuccess()){
			AttachmentVO file = response.getData();
			info.putIfAbsent("创建人",file.getCreateUserName());
		}
		return info;
	}

	/**
	 * 查询文件评论列表
	 * */
	@RequestMapping(value = "comments",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray comments(@RequestParam("id") String id){
		return new JSONArray();
	}

	/**
	 * 查询文件标签列表
	 * */
	@RequestMapping(value = "tags",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray tags(@RequestParam("id") String id){
		CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(id);
		JSONObject info = new JSONObject();
		if(response.isSuccess()){
			AttachmentVO file = response.getData();
			/** 保存浏览历史 */
			ViewLogEntity viewLogEntity = new ViewLogEntity();
			viewLogEntity.setFileId(file.getId());
			viewLogEntity.setFileType(getType(file.getFileName().split("\\.")[1]));
			viewLogService.saveOrUpdate(viewLogEntity,false);
			/** 保存浏览历史 */
			info.putIfAbsent("创建人",file.getCreateUserName());
		}
		return new JSONArray();
	}

	/**
	 * 查询所有用户列表？具体用处不清楚
	 * */
	@RequestMapping(value = "users/all",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray usersAll(){
		return new JSONArray();
	}

	/**
	 * 查询所有标签？具体用处不清楚
	 * */
	@RequestMapping(value = "tags/all",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray tagsAll(){
		return new JSONArray();
	}

	@RequestMapping(value = "getPreviewUrl",method = RequestMethod.GET)
	@ResponseBody
	public AttachmentVO getPreviewUrl(@RequestParam("id") String id){
		CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(id);
		if(response.isSuccess()){
			AttachmentVO file = response.getData();
			return file;
		}
		return null;
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/6/8 收藏
	 * @Description favorite1
	 * @Param [id]
	 * @Return com.alibaba.fastjson.JSONObject
	 */
	@RequestMapping(value = "favorite",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject favorite1(@RequestParam("id") String id,@RequestParam("type") String type){
		MyFavoriteEntity entity = new MyFavoriteEntity();
		entity.setFileId(Long.parseLong(id));
		entity.setFileType(type);
		myFavoriteService.saveOrUpdate(entity,false);
		JSONObject jsonObject = new JSONObject();
		jsonObject.putIfAbsent("id",id);
		jsonObject.putIfAbsent("error","");
		jsonObject.putIfAbsent("invalid",false);
		return jsonObject;
	}

	@RequestMapping(value = "favorite",method = RequestMethod.DELETE)
	@ResponseBody
	public JSONObject favorite(@RequestParam("id") String id){
		QueryParam param = new QueryParam();
		param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
		param.getParams().put("fileId",new Parameter(QueryParam.EQ,id));
		List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
		if(ListUtil.isNotEmpty(favoriteEntities)){
			favoriteEntities.forEach(f->{
				myFavoriteService.removeById(f.getId());
			});
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.putIfAbsent("id",id);
		jsonObject.putIfAbsent("error","");
		jsonObject.putIfAbsent("invalid",false);
		return jsonObject;
	}

	/*********************角色start*********************/
	/**
	 * @Description queryList 查询角色列表信息
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryBillTypeList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<DocCategoryBillTypeRelationVO>> queryBillTypeList(@RequestBody QueryParam param) {

		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		IPage<DocCategoryBillTypeRelationEntity> page = billTypeRelationService.queryPage(param,false);

		IPage<DocCategoryBillTypeRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocCategoryBillTypeRelationVO.class));

		return CommonResponse.success("查询列表数据成功！",pageData);
	}

	/**
	 * 保存套餐角色关系
	 * @return
	 */
	@RequestMapping(value = "/saveDocCategoryBillType", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveDocCategoryBillType(@RequestBody List<DocCategoryBillTypeRelationVO> relationList) {
		return billTypeRelationService.saveDocCategoryBillType(relationList);
	}

	/**
	 * 删除授权单据类型
	 * @return
	 */
	@RequestMapping(value = "/deleteDocCategoryBillType", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteDocCategoryBillType(@RequestBody List<DocCategoryBillTypeRelationVO> relationList) {
		return billTypeRelationService.deleteDocCategoryBillType(relationList);
	}

	/**
	 * 根据billTypeId查找
	 * @param billTypeCode
	 * @return
	 */
	@RequestMapping(value = "/queryBillTypeIdList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<DocCategoryBillTypeRelationVO>> queryBillTypeIdList(@RequestParam("billTypeCode") String billTypeCode ) {
		List<DocCategoryBillTypeRelationEntity> list =billTypeRelationService.queryBillTypeIdList(billTypeCode);
		List<DocCategoryBillTypeRelationVO> voList = BeanMapper.mapList(list, DocCategoryBillTypeRelationVO.class);
		return CommonResponse.success("查询列表数据成功！",voList);
	}

	@GetMapping(value = "/categoryTreeBillTypeRef")
	@ResponseBody
	public List<Map<String, Object>> categoryTreeBillTypeRef(@RequestParam(value = "searchText", required = false) String searchText,@RequestParam(value = "condition", required = false) String condition) {
		String billTypeCode=null;
		if(StringUtils.isNotEmpty(condition)){
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			billTypeCode = (String) _con.get("billTypeCode");
		}
		List<DocCategoryEntity> categoryEntities = relationService.getAllByBillType(billTypeCode, searchText);
		List<Map> resultMapList = BeanMapper.mapList(categoryEntities, Map.class);
		return ResultAsTree.createTreeData(resultMapList);
	}
}
