package com.ejianc.business.doc.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.doc.api.result.KbmResult;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping(value = "/api/kbm")
public class KbmApi {

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IKbmService kbmService;

    @RequestMapping(value = "/queryKbmFileList", method = RequestMethod.GET)
    public CommonResponse<List<KbmResult>> queryKbmFileList() {
        List<KbmResult> kbmResultList = new ArrayList<>();

        QueryWrapper<KbmEntity> kbmWrapper = new QueryWrapper<>();
        kbmWrapper.ne("embedding_state", 1);
        kbmWrapper.orderByAsc("tenant_id");
        kbmWrapper.last(" limit 100 ");
        List<KbmEntity> kbmList = kbmService.list(kbmWrapper);
        if(kbmList != null && kbmList.size() > 0) {
            for(KbmEntity kbmEntity : kbmList) {
                CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(kbmEntity.getId(), null, null, null);
                if(attachmentResponse.isSuccess()) {
                    List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
                    if(attachmentVOList != null && attachmentVOList.size() > 0) {
                        for(AttachmentVO attachmentVO : attachmentVOList) {
                            KbmResult kbmResult = new KbmResult();
                            kbmResult.setKbmId(kbmEntity.getId());
                            kbmResult.setFileId(attachmentVO.getId());
                            kbmResult.setFileName(attachmentVO.getFileName());
                            kbmResult.setFilePath(attachmentVO.getFilePath());
                            kbmResult.setFileSize(attachmentVO.getFileSize());
                            kbmResult.setTenantId(kbmEntity.getTenantId());
                            kbmResultList.add(kbmResult);
                        }
                    }
                }
            }
        }
        return CommonResponse.success(kbmResultList);
    }

    @RequestMapping(value = "/updateKbmEmbeddingState", method = RequestMethod.POST)
    public CommonResponse<String> updateKbmEmbeddingState(@RequestBody List<Long> kbmIds) {
        if(kbmIds !=null && kbmIds.size() > 0) {
            for(Long kbmId : kbmIds){
                UpdateWrapper<KbmEntity> updateWrapper = new UpdateWrapper<>();
                updateWrapper.eq("id", kbmId);
                updateWrapper.set("embedding_state", 1);
                kbmService.update(updateWrapper);
            }
        }
        return CommonResponse.success();
    }
}
