/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.doc.api.result.KbmResult;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/kbm"})
public class KbmApi {
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IKbmService kbmService;

    @RequestMapping(value={"/queryKbmFileList"}, method={RequestMethod.GET})
    public CommonResponse<List<KbmResult>> queryKbmFileList() {
        ArrayList<KbmResult> kbmResultList = new ArrayList<KbmResult>();
        QueryWrapper kbmWrapper = new QueryWrapper();
        kbmWrapper.ne((Object)"embedding_state", (Object)1);
        kbmWrapper.orderByAsc((Object)"tenant_id");
        kbmWrapper.last(" limit 100 ");
        List kbmList = this.kbmService.list((Wrapper)kbmWrapper);
        if (kbmList != null && kbmList.size() > 0) {
            for (KbmEntity kbmEntity : kbmList) {
                List attachmentVOList;
                CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(kbmEntity.getId(), null, null, null);
                if (!attachmentResponse.isSuccess() || (attachmentVOList = (List)attachmentResponse.getData()) == null || attachmentVOList.size() <= 0) continue;
                for (AttachmentVO attachmentVO : attachmentVOList) {
                    KbmResult kbmResult = new KbmResult();
                    kbmResult.setKbmId(kbmEntity.getId());
                    kbmResult.setFileId(attachmentVO.getId());
                    kbmResult.setFileName(attachmentVO.getFileName());
                    kbmResult.setFilePath(attachmentVO.getFilePath());
                    kbmResult.setFileSize(attachmentVO.getFileSize());
                    kbmResult.setTenantId(kbmEntity.getTenantId());
                    kbmResultList.add(kbmResult);
                }
            }
        }
        return CommonResponse.success(kbmResultList);
    }

    @RequestMapping(value={"/updateKbmEmbeddingState"}, method={RequestMethod.POST})
    public CommonResponse<String> updateKbmEmbeddingState(@RequestBody List<Long> kbmIds) {
        if (kbmIds != null && kbmIds.size() > 0) {
            for (Long kbmId : kbmIds) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"id", (Object)kbmId);
                updateWrapper.set((Object)"embedding_state", (Object)1);
                this.kbmService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success();
    }
}

