/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.mapper.ProjectDocMapper;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectService")
public class ProjectDocServiceImpl
extends BaseServiceImpl<ProjectDocMapper, ProjectDocEntity>
implements IProjectDocService {
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ProjectDocMapper projectDocMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void archiveFiles(List<ProjectDocVO> projectDocVOs, List<Long> attachIds) {
        List saveEntities = BeanMapper.mapList(projectDocVOs, ProjectDocEntity.class);
        super.saveBatch((Collection)saveEntities);
        JSONObject param = new JSONObject();
        param.put("status", (Object)1);
        param.put("attachIds", attachIds);
        CommonResponse updateResp = this.attachmentApi.updateAttachArchiveStatus(param.toJSONString());
        if (!updateResp.isSuccess()) {
            throw new BusinessException("\u5f52\u6863\u5931\u8d25\uff0c\u66f4\u65b0\u9644\u4ef6\u5f52\u6863\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delArchiveDocs(List<Long> ids, boolean updateFileStatus) {
        List list = ((ProjectDocMapper)this.baseMapper).selectBatchIds(ids);
        ((ProjectDocMapper)this.baseMapper).deleteBatchIds(ids);
        List attachIds = list.stream().map(doc -> doc.getFileId()).collect(Collectors.toList());
        if (updateFileStatus) {
            JSONObject param = new JSONObject();
            param.put("status", (Object)0);
            param.put("attachIds", attachIds);
            CommonResponse updateResp = this.attachmentApi.updateAttachArchiveStatus(param.toJSONString());
            if (!updateResp.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u66f4\u65b0\u9644\u4ef6\u5f52\u6863\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    public IPage<ProjectDocEntity> queryPageList(Integer pageSize, Integer pageIndex, Long tenantId, List<Long> categoryIds, String searchText, String superviseTimeOrder, List<Long> orgIds) {
        Page page = new Page();
        long total = this.projectDocMapper.count(tenantId, categoryIds, searchText, orgIds);
        page.setSize((long)pageSize.intValue());
        page.setCurrent((long)pageIndex.intValue());
        if (total == 0L) {
            return page;
        }
        List<ProjectDocEntity> records = this.projectDocMapper.pageList(pageSize, (pageIndex < 1 ? 0 : pageIndex - 1) * pageSize, tenantId, categoryIds, searchText, superviseTimeOrder, orgIds);
        page.setTotal(total);
        page.setRecords(records);
        return page;
    }
}

