package com.ejianc.business.doc.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.doc.api.result.KbmResult;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping(value = "/api/kbm")
public class KbmApi {

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IKbmService kbmService;
    @Value("${oms.fileServerPath:null}")
    private String fileServerPath;

    @RequestMapping(value = "/queryKbmFileList", method = RequestMethod.GET)
    public CommonResponse<List<KbmResult>> queryKbmFileList() {
        List<KbmResult> kbmResultList = new ArrayList<>();

        QueryWrapper<KbmEntity> kbmWrapper = new QueryWrapper<>();
        kbmWrapper.eq("embedding_state", "no");
        kbmWrapper.orderByAsc("tenant_id");
        List<KbmEntity> kbmList = kbmService.list(kbmWrapper);
        if(kbmList != null && kbmList.size() > 0) {
            for(KbmEntity kbmEntity : kbmList) {
                boolean isContainDoc = false;
                CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(kbmEntity.getId(), null, null, null);
                if(attachmentResponse.isSuccess()) {
                    List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
                    if(attachmentVOList != null && attachmentVOList.size() > 0) {
                        for(AttachmentVO attachmentVO : attachmentVOList) {
                            if(StringUtils.isNotBlank(attachmentVO.getFilePath()) &&
                                    (attachmentVO.getFilePath().contains(".doc")
                                            || attachmentVO.getFilePath().contains(".docx")
                                            || attachmentVO.getFilePath().contains(".pdf")
                                            || attachmentVO.getFilePath().contains(".txt"))) {
                                isContainDoc = true;
                                KbmResult kbmResult = new KbmResult();
                                kbmResult.setKbmId(kbmEntity.getId());
                                kbmResult.setFileId(attachmentVO.getId());
                                kbmResult.setFileName(attachmentVO.getFileName());
                                kbmResult.setFilePath(fileServerPath+"/"+attachmentVO.getFilePath());
                                kbmResult.setFileSize(attachmentVO.getFileSize());
                                kbmResult.setTenantId(kbmEntity.getTenantId());
                                kbmResultList.add(kbmResult);
                            }
                        }
                    }
                }

                if(!isContainDoc) {
                    UpdateWrapper<KbmEntity> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("id", kbmEntity.getId());
                    updateWrapper.set("embedding_state", "yes");
                    kbmService.update(updateWrapper);
                }
            }
        }
        return CommonResponse.success(kbmResultList);
    }

    @RequestMapping(value = "/updateKbmEmbeddingState", method = RequestMethod.POST)
    public CommonResponse<String> updateKbmEmbeddingState(@RequestBody Long kbmId) {
        UpdateWrapper<KbmEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", kbmId);
        updateWrapper.set("embedding_state", "yes");
        kbmService.update(updateWrapper);
        return CommonResponse.success();
    }
}
