/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.doc.api.result.KbmResult;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/kbm"})
public class KbmApi {
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IKbmService kbmService;
    @Value(value="${oms.fileServerPath:null}")
    private String fileServerPath;

    @RequestMapping(value={"/queryKbmFileList"}, method={RequestMethod.GET})
    public CommonResponse<List<KbmResult>> queryKbmFileList() {
        ArrayList<KbmResult> kbmResultList = new ArrayList<KbmResult>();
        QueryWrapper kbmWrapper = new QueryWrapper();
        kbmWrapper.eq((Object)"embedding_state", (Object)"no");
        kbmWrapper.orderByAsc((Object)"tenant_id");
        List kbmList = this.kbmService.list((Wrapper)kbmWrapper);
        if (kbmList != null && kbmList.size() > 0) {
            for (KbmEntity kbmEntity : kbmList) {
                List attachmentVOList;
                boolean isContainDoc = false;
                CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(kbmEntity.getId(), null, null, null);
                if (attachmentResponse.isSuccess() && (attachmentVOList = (List)attachmentResponse.getData()) != null && attachmentVOList.size() > 0) {
                    for (AttachmentVO attachmentVO : attachmentVOList) {
                        if (!StringUtils.isNotBlank((String)attachmentVO.getFilePath()) || !attachmentVO.getFilePath().contains(".doc") && !attachmentVO.getFilePath().contains(".docx") && !attachmentVO.getFilePath().contains(".pdf") && !attachmentVO.getFilePath().contains(".txt")) continue;
                        isContainDoc = true;
                        KbmResult kbmResult = new KbmResult();
                        kbmResult.setKbmId(kbmEntity.getId());
                        kbmResult.setFileId(attachmentVO.getId());
                        kbmResult.setFileName(attachmentVO.getFileName());
                        kbmResult.setFilePath(this.fileServerPath + "/" + attachmentVO.getFilePath());
                        kbmResult.setFileSize(attachmentVO.getFileSize());
                        kbmResult.setTenantId(kbmEntity.getTenantId());
                        kbmResultList.add(kbmResult);
                    }
                }
                if (isContainDoc) continue;
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"id", (Object)kbmEntity.getId());
                updateWrapper.set((Object)"embedding_state", (Object)"yes");
                this.kbmService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success(kbmResultList);
    }

    @RequestMapping(value={"/updateKbmEmbeddingState"}, method={RequestMethod.POST})
    public CommonResponse<String> updateKbmEmbeddingState(@RequestBody Long kbmId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)kbmId);
        updateWrapper.set((Object)"embedding_state", (Object)"yes");
        this.kbmService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

