package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.DocCategoryBillTypeRelationEntity;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.DocCategoryRoleRelationEntity;
import com.ejianc.business.doc.mapper.DocCategoryBillTypeRelationMapper;
import com.ejianc.business.doc.mapper.DocCategoryRoleRelationMapper;
import com.ejianc.business.doc.service.IDocCategoryBillTypeRelationService;
import com.ejianc.business.doc.service.IDocCategoryRoleRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryBillTypeRelationVO;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

import java.util.*;

/**
 * 文档分类角色关系
 * 
 * @author generator
 * 
 */
@Service("docCategoryBillTypeRelationService")
public class DocCategoryBillTypeRelationServiceImpl extends BaseServiceImpl<DocCategoryBillTypeRelationMapper, DocCategoryBillTypeRelationEntity> implements IDocCategoryBillTypeRelationService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
	private IDocCategoryService docCategoryService;
	@Autowired
	private CacheManager cacheManager;
	//当前用户的角色KEY
	private final static String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";
	
	
	@Override
	public CommonResponse<String> saveDocCategoryBillType(List<DocCategoryBillTypeRelationVO> relationList) {
		List<DocCategoryBillTypeRelationEntity> addList = new ArrayList<>();
		String roleName = "";
		//1、判重
		QueryWrapper<DocCategoryBillTypeRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		queryWrapper.eq("dr", 0);
		List<DocCategoryBillTypeRelationEntity> list = this.list(queryWrapper);
		Map<Long,DocCategoryBillTypeRelationEntity> map = new HashMap<>();
		if(list!=null&&list.size()>0){
			for(DocCategoryBillTypeRelationEntity relation : list){
				map.put(relation.getBillTypeId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getBillTypeName());
				}else{
					roleName += relation.getBillTypeName();
				}
			}
		}
		String message = "";
		//2、保存
		for(DocCategoryBillTypeRelationVO vo : relationList){
			addList.add(BeanMapper.map(vo, DocCategoryBillTypeRelationEntity.class));
		}
		if(addList.size()>0){
			this.saveOrUpdateBatch(addList, addList.size(), false);
			for(DocCategoryBillTypeRelationEntity relation : addList){
				map.put(relation.getBillTypeId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getBillTypeName());
				}else{
					roleName += relation.getBillTypeName();
				}
			}
			DocCategoryEntity categoryEntity = docCategoryService.getById(relationList.get(0).getCategoryId());
			categoryEntity.setRoleName(roleName);
			docCategoryService.saveOrUpdate(categoryEntity, false);
			if(addList.size()!=relationList.size()){
				//有重复数据
				return CommonResponse.success("添加成功,其中以下角色："+message+"已存在");
			}
		}else{
			return CommonResponse.success("选择的角色都已在该分类下，请重新选择");
		}
		
		//
		return CommonResponse.success("添加成功");
	}

	@Override
	public CommonResponse<String> deleteDocCategoryBillType(List<DocCategoryBillTypeRelationVO> relationList) {
		List<Long> ids = new ArrayList<>();
		for(DocCategoryBillTypeRelationVO vo : relationList){
			ids.add(vo.getId());
		}
		this.removeByIds(ids, false);

		String roleName = "";
		QueryWrapper<DocCategoryBillTypeRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		queryWrapper.eq("dr", 0);
		List<DocCategoryBillTypeRelationEntity> list = this.list(queryWrapper);
		if(list!=null&&list.size()>0){
			for(DocCategoryBillTypeRelationEntity relation : list){
				if(roleName.length()>0){
					roleName += ("、"+relation.getBillTypeName());
				}else{
					roleName += relation.getBillTypeName();
				}
			}
		}

		DocCategoryEntity categoryEntity = docCategoryService.getById(relationList.get(0).getCategoryId());
		categoryEntity.setRoleName(roleName);
		docCategoryService.saveOrUpdate(categoryEntity, false);
		return CommonResponse.success("删除成功");
	}



	public List<Long> getUserRoleCache(Long userId) {
		List<Long> resultList = new ArrayList<Long>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		String key = CURRENTUSER_ROLE_KEY + userId + "-" + tenantId;
		Set<String> roleIds = cacheManager.execute(new CacheManager.JedisAction<Set<String>>() {
			@Override
			public Set<String> action(Jedis jedis) {
				return jedis.smembers(key);
			}
		});
		if(roleIds != null && !roleIds.isEmpty()) {
			for(String roleId:roleIds) {
				resultList.add(Long.parseLong(roleId));
			}
		}
		return resultList;
	}

	@Override
	public List<DocCategoryBillTypeRelationEntity> queryBillTypeIdList(String billTypeCode) {
		QueryWrapper<DocCategoryBillTypeRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("bill_type_code", billTypeCode);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		queryWrapper.eq("dr", 0);
		List<DocCategoryBillTypeRelationEntity> list = this.list(queryWrapper);
		return list;
	}

}
