/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.DocCategoryBillTypeRelationEntity;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.service.IDocCategoryBillTypeRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/docManage/"})
public class DocManageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectDocService projectDocService;
    @Autowired
    private IParamConfigApi configApi;
    @Autowired
    private IDocCategoryBillTypeRelationService billTypeRelationService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDocCategoryService iDocCategoryService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    private final String COMMON_REQ_URL = "/commonstate/queryBillDetail";
    @Autowired
    private IDocCategoryService docCategoryService;

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<ProjectDocVO>> pageList(@RequestBody Map<String, String> params) {
        QueryParam queryParam = new QueryParam();
        Integer pageSize = Integer.valueOf(params.get("pageSize"));
        Integer pageIndex = Integer.valueOf(params.get("pageIndex"));
        Long categoryId = Long.valueOf(params.get("categoryId"));
        String filterType = params.get("filterType");
        String searchText = null != params.get("searchText") ? params.get("searchText") : null;
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        HashMap<Long, String> categoryIdNameMap = new HashMap<Long, String>();
        if ("1".equals(filterType)) {
            List<DocCategoryEntity> categoryList = this.docCategoryService.findChildrenByPid(categoryId);
            categoryList.forEach(category -> {
                categoryIdNameMap.put(category.getId(), category.getCategoryName());
                categoryIds.add(category.getId());
            });
        } else {
            categoryIds.add(categoryId);
            DocCategoryEntity categoryEntity = (DocCategoryEntity)((Object)this.docCategoryService.getById(categoryId));
            categoryIdNameMap.put(categoryEntity.getId(), categoryEntity.getCategoryName());
        }
        Page respPage = new Page();
        CommonResponse orgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List orgVOList = (List)orgResp.getData();
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)orgVOList)) {
            respPage.setRecords(new ArrayList());
            respPage.setCurrent((long)queryParam.getPageIndex());
            respPage.setTotal(0L);
            respPage.setSize((long)queryParam.getPageSize());
            respPage.setPages(0L);
            return CommonResponse.success((Object)respPage);
        }
        LinkedHashMap orderMap = (LinkedHashMap)JSONObject.parseObject((String)params.get("orderMap"), (Type)new TypeReference<LinkedHashMap<String, Object>>(){}.getType(), (Feature[])new Feature[]{Feature.OrderedField});
        String superviseTimeOrder = null;
        for (String key : orderMap.keySet()) {
            superviseTimeOrder = (String)orderMap.get(key);
        }
        CommonResponse archiveConfig = this.configApi.getByCode("P-b14fSX0318");
        if (archiveConfig.isSuccess() && "\u5f00\u542f".equals(((ParamRegisterSetVO)archiveConfig.getData()).getValueData())) {
            CommonResponse attachmentResp;
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("categoryId", new Parameter("in", categoryIds));
            List relationEntities = this.billTypeRelationService.queryList(param, false);
            List<String> billTypeCodes = CollectionUtils.isEmpty((Collection)relationEntities) ? new ArrayList<String>() : relationEntities.stream().map(DocCategoryBillTypeRelationEntity::getBillTypeCode).collect(Collectors.toList());
            billTypeCodes.add("BT201201000000001");
            param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("docCategoryId", new Parameter("not_in", categoryIds));
            param.getParams().put("docSource", new Parameter("eq", (Object)"1"));
            List projectDocEntities = this.projectDocService.queryList(param, false);
            param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("billType", new Parameter("eq", (Object)"BT201201000000001"));
            param.getParams().put("sourceType", new Parameter("eq", (Object)"projectDocMgr"));
            param.setPageSize(100000);
            CommonResponse resp = this.attachmentApi.queryListPage(param);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("docCategoryId", new Parameter("in", categoryIds));
            param.getParams().put("docSource", new Parameter("eq", (Object)"1"));
            List finalProjectDocEntities = this.projectDocService.queryList(param, false);
            List attachmentVOList = ((Page)resp.getData()).getRecords();
            List<Object> withOutAttachIds = new ArrayList();
            if (ListUtil.isNotEmpty((List)projectDocEntities)) {
                withOutAttachIds = projectDocEntities.stream().map(ProjectDocEntity::getFileId).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOList)) {
                Map<Long, AttachmentVO> attachmentVOMap = attachmentVOList.stream().collect(Collectors.toMap(AttachmentVO::getId, attachmentVO -> attachmentVO));
                finalProjectDocEntities.forEach(projectDocEntity -> {
                    AttachmentVO cfr_ignored_0 = (AttachmentVO)attachmentVOMap.remove(projectDocEntity.getFileId());
                });
                withOutAttachIds.addAll(attachmentVOMap.keySet());
            }
            param = new QueryParam();
            param.setPageSize(pageSize.intValue());
            param.setPageIndex(pageIndex.intValue());
            if (StringUtils.isNotBlank((String)searchText)) {
                param.setSearchText(searchText);
                param.getFuzzyFields().add("fileName");
                param.getFuzzyFields().add("uploadUserName");
            }
            if (StringUtils.isNotBlank((String)superviseTimeOrder)) {
                param.getOrderMap().put("createTime", superviseTimeOrder);
            }
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("billType", new Parameter("in", billTypeCodes));
            param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            if (ListUtil.isNotEmpty(withOutAttachIds)) {
                param.getParams().put("id", new Parameter("not_in", withOutAttachIds));
            }
            if (!(attachmentResp = this.attachmentApi.queryListPage(param)).isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            IPage pageData = (IPage)attachmentResp.getData();
            if (CollectionUtils.isEmpty((Collection)pageData.getRecords())) {
                respPage.setRecords(new ArrayList());
                respPage.setCurrent((long)queryParam.getPageIndex());
                respPage.setSize((long)queryParam.getPageSize());
                respPage.setTotal(0L);
                respPage.setPages(0L);
                return CommonResponse.success((Object)respPage);
            }
            List records = pageData.getRecords().stream().map(attachmentVO -> {
                CommonResponse userResp;
                UserVO userVO = null;
                if (StringUtils.isNotEmpty((String)attachmentVO.getCreateUserCode()) && (userResp = this.userApi.queryUserByUserCode(attachmentVO.getCreateUserCode())).isSuccess()) {
                    userVO = (UserVO)userResp.getData();
                }
                ProjectDocVO projectDocVO = new ProjectDocVO();
                projectDocVO.setId(attachmentVO.getId());
                projectDocVO.setFileId(attachmentVO.getId());
                projectDocVO.setFileName(attachmentVO.getFileName());
                projectDocVO.setFilePath(attachmentVO.getFilePath());
                projectDocVO.setFileSize(attachmentVO.getFileSize());
                if (attachmentVO.getFileName().lastIndexOf(".") != -1) {
                    String type = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf("."));
                    projectDocVO.setFileType(type);
                }
                projectDocVO.setTenantId(attachmentVO.getTenantId());
                projectDocVO.setCreateUserCode(attachmentVO.getCreateUserCode());
                projectDocVO.setCreateTime(attachmentVO.getCreateTime());
                projectDocVO.setUpdateUserCode(attachmentVO.getUpdateUserCode());
                projectDocVO.setUpdateTime(attachmentVO.getUpdateTime());
                projectDocVO.setDr(attachmentVO.getDr());
                projectDocVO.setRowState(attachmentVO.getRowState());
                projectDocVO.setCustomField(attachmentVO.getCustomField());
                projectDocVO.setDocCategoryId(categoryId);
                projectDocVO.setDocCategoryName((String)categoryIdNameMap.get(categoryId));
                projectDocVO.setOnlinePath(attachmentVO.getOnlinePath());
                projectDocVO.setSourceId(attachmentVO.getSourceId());
                projectDocVO.setBillType(attachmentVO.getBillType());
                projectDocVO.setOrgId(attachmentVO.getOrgId());
                projectDocVO.setOrgName(orgVOList.stream().filter(orgVO -> orgVO.getId().equals(attachmentVO.getOrgId())).findFirst().get().getName());
                projectDocVO.setSuperviseUserName(attachmentVO.getUploadUserName());
                if (userVO != null) {
                    projectDocVO.setSuperviseUserId(userVO.getId());
                    projectDocVO.setSuperviseUserName(userVO.getUserName());
                }
                projectDocVO.setSuperviseTime(attachmentVO.getCreateTime());
                if (ListUtil.isNotEmpty((List)finalProjectDocEntities)) {
                    boolean has = false;
                    for (ProjectDocEntity docEntity : finalProjectDocEntities) {
                        if (!docEntity.getFileId().equals(attachmentVO.getId())) continue;
                        projectDocVO.setId(docEntity.getId());
                        projectDocVO.setSuperviseUserName(docEntity.getSuperviseUserName());
                        projectDocVO.setSuperviseUserId(docEntity.getSuperviseUserId());
                        projectDocVO.setOrgId(docEntity.getOrgId());
                        projectDocVO.setOrgName(docEntity.getOrgName());
                        projectDocVO.setProjectId(docEntity.getProjectId());
                        projectDocVO.setProjectName(docEntity.getProjectName());
                        has = true;
                    }
                    if (has) {
                        projectDocVO.setDocSource("1");
                    } else {
                        projectDocVO.setDocSource("0");
                    }
                } else {
                    projectDocVO.setDocSource("0");
                }
                return projectDocVO;
            }).collect(Collectors.toList());
            respPage.setRecords(records);
            respPage.setCurrent(pageData.getCurrent());
            respPage.setSize(pageData.getSize());
            respPage.setTotal(pageData.getTotal());
            respPage.setPages(pageData.getPages());
            return CommonResponse.success((Object)respPage);
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getFuzzyFields().add("fileName");
        queryParam.getFuzzyFields().add("superviseUserName");
        queryParam.getOrderMap().put("superviseTime", "desc");
        queryParam.getParams().put("docCategoryId", new Parameter("in", categoryIds));
        IPage<ProjectDocEntity> pageData = this.projectDocService.queryPageList(pageSize, pageIndex, InvocationInfoProxy.getTenantid(), categoryIds, StringUtils.isBlank((String)searchText) ? null : searchText, superviseTimeOrder, orgVOList.stream().map(org -> org.getId()).collect(Collectors.toList()));
        List records = BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectDocVO.class);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(doc -> doc.setDocCategoryName((String)categoryIdNameMap.get(doc.getDocCategoryId())));
        }
        respPage.setRecords(records);
        respPage.setCurrent(pageData.getCurrent());
        respPage.setSize(pageData.getSize());
        respPage.setTotal(pageData.getTotal());
        respPage.setPages(pageData.getPages());
        return CommonResponse.success((Object)respPage);
    }

    @PostMapping(value={"saveProjectDoc"})
    public CommonResponse<String> saveOrUpdate(@RequestBody List<ProjectDocVO> projectDocVOs) {
        List saveEntitys = BeanMapper.mapList(projectDocVOs, ProjectDocEntity.class);
        this.projectDocService.saveOrUpdateBatch(saveEntitys, saveEntitys.size());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"beachMove"})
    public CommonResponse<String> beachMove(@RequestBody List<Long> ids, @RequestParam(value="docCategoryId") Long docCategoryId) {
        List moveEntitys;
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        CommonResponse archiveConfig = this.configApi.getByCode("P-b14fSX0318");
        if (archiveConfig.isSuccess() && "\u5f00\u542f".equals(((ParamRegisterSetVO)archiveConfig.getData()).getValueData())) {
            param.getParams().put("docSource", new Parameter("eq", (Object)"1"));
        }
        if (ListUtil.isEmpty((List)(moveEntitys = this.projectDocService.queryList(param)))) {
            return CommonResponse.error((String)"\u79fb\u52a8\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        DocCategoryEntity categoryEntity = (DocCategoryEntity)((Object)this.iDocCategoryService.selectById(docCategoryId));
        if (categoryEntity == null) {
            return CommonResponse.error((String)"\u79fb\u52a8\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff01");
        }
        for (ProjectDocEntity moveEntity : moveEntitys) {
            moveEntity.setDocCategoryId(docCategoryId);
        }
        this.projectDocService.saveOrUpdateBatch(moveEntitys, moveEntitys.size());
        return CommonResponse.success((String)"\u79fb\u52a8\u6210\u529f\uff01");
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        List docEntityList;
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        CommonResponse archiveConfig = this.configApi.getByCode("P-b14fSX0318");
        if (archiveConfig.isSuccess() && "\u5f00\u542f".equals(((ParamRegisterSetVO)archiveConfig.getData()).getValueData())) {
            param.getParams().put("docSource", new Parameter("eq", (Object)"1"));
        }
        if (ListUtil.isEmpty((List)(docEntityList = this.projectDocService.queryList(param)))) {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u5220\u9664\u7684\u6587\u4ef6\uff01");
        }
        ids = docEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.projectDocService.delArchiveDocs(ids, true);
        if (archiveConfig.isSuccess() && "\u5f00\u542f".equals(((ParamRegisterSetVO)archiveConfig.getData()).getValueData())) {
            String fileIds = docEntityList.stream().map(ProjectDocEntity::getFileId).map(Object::toString).collect(Collectors.joining(","));
            this.attachmentApi.delete(fileIds);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ProjectDocVO> queryDetail(@RequestParam(value="id") Long id) {
        ProjectDocEntity projectDocEntity = (ProjectDocEntity)((Object)this.projectDocService.selectById(id));
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)projectDocEntity), ProjectDocVO.class));
    }

    @PostMapping(value={"archiveFiles"})
    public CommonResponse<String> archiveFiles(@RequestBody List<ProjectDocVO> projectDocVOs) {
        ProjectDocVO tmpVo = projectDocVOs.get(0);
        String billType = tmpVo.getBillType();
        String orgIdField = tmpVo.getOrgIdField();
        String projectField = tmpVo.getProjectIdField();
        String billCodeField = tmpVo.getBillCodeField();
        Long sourceId = tmpVo.getSourceId();
        Long orgId = null;
        Long projectId = null;
        String orgName = null;
        String projectName = null;
        String billCode = null;
        String billTypeName = null;
        CommonResponse billTypeResp = this.billTypeApi.getByCode(billType);
        if (!billTypeResp.isSuccess()) {
            return CommonResponse.error((String)("\u5f52\u6863\u5931\u8d25\uff0c\u67e5\u8be2\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff1a" + billTypeResp.getMsg()));
        }
        billTypeName = ((BillTypeVO)billTypeResp.getData()).getBillName();
        CommonResponse mdReferResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdReferResp.isSuccess()) {
            return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        MdReferVO mdReferVO = (MdReferVO)mdReferResp.getData();
        JSONObject detail = this.reqResult(mdReferVO.getProjectName(), mdReferVO.getTableName(), sourceId, mdReferVO.getMetadataId());
        orgId = null != detail.get((Object)orgIdField) ? Long.valueOf(detail.get((Object)orgIdField).toString()) : null;
        projectId = null != detail.get((Object)projectField) ? Long.valueOf(detail.get((Object)projectField).toString()) : null;
        String string = billCode = null != detail.get((Object)billCodeField) ? detail.get((Object)billCodeField).toString() : "";
        if (null == orgId && null == projectId) {
            return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u4ece\u4e1a\u52a1\u5355\u636e\u4e2d\u83b7\u53d6\u7ec4\u7ec7\u3001\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List<ProjectRegisterVO> projects = new ArrayList();
        if (null != projectId) {
            ArrayList<Long> proIds = new ArrayList<Long>();
            proIds.add(projectId);
            CommonResponse projectResp = this.projectApi.queryProjectByIds(proIds);
            if (CollectionUtils.isEmpty((Collection)((Collection)projectResp.getData()))) {
                CommonResponse setProjectResp = this.projectSetApi.getProjectId(projectId);
                if (!setProjectResp.isSuccess()) {
                    this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u6839\u636e\u9879\u76eeId{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)projectId, (Object)projectResp.getMsg());
                    return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)setProjectResp.getData();
                ProjectRegisterVO project = new ProjectRegisterVO();
                project.setProjectDepartmentId(projectPoolSetVO.getProjectDepartmentId());
                project.setName(projectPoolSetVO.getName());
                project.setId(projectPoolSetVO.getId());
                projects.add(project);
            } else {
                projects = (List)projectResp.getData();
            }
            if (CollectionUtils.isEmpty(projects)) {
                this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\uff1a\u6839\u636e\u9879\u76eeId{}\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u9879\u76ee\u4fe1\u606f", (Object)projectId);
                CommonResponse setProject = this.projectSetApi.getProjectId(projectId);
                return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5339\u914d\u7684\u9879\u76ee\u4fe1\u606f\uff01");
            }
            ProjectRegisterVO project = (ProjectRegisterVO)projects.get(0);
            orgId = project.getProjectDepartmentId();
            orgName = project.getName();
            projectId = project.getId();
            projectName = project.getName();
        } else {
            CommonResponse orgResp = this.orgApi.getOneById(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u6839\u636e\u7ec4\u7ec7Id{}\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)orgId, (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            OrgVO orgvo = (OrgVO)orgResp.getData();
            orgId = orgvo.getId();
            orgName = orgvo.getName();
        }
        ArrayList<Long> attachIds = new ArrayList<Long>();
        for (ProjectDocVO doc : projectDocVOs) {
            doc.setOrgId(orgId);
            doc.setOrgName(orgName);
            doc.setProjectId(projectId);
            doc.setProjectName(projectName);
            doc.setBillSymbol(billTypeName + (StringUtils.isNotBlank((String)billCode) ? "-" + billCode : ""));
            attachIds.add(doc.getFileId());
        }
        this.projectDocService.archiveFiles(projectDocVOs, attachIds);
        return CommonResponse.success((String)"\u5f52\u6863\u6210\u529f\uff01");
    }

    private JSONObject reqResult(String projectName, String tableName, Long dataId, Long metaDataId) {
        Gson gson = new Gson();
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", dataId);
        paramterMap.put("tableName", tableName);
        paramterMap.put("metadataId", metaDataId);
        String paramterStr = gson.toJson(paramterMap);
        String url = this.BASE_HOST + projectName + "/commonstate/queryBillDetail";
        this.logger.info("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\uff1a\u3010url-{}\u3011, \u3010param-{}\u3011", (Object)url, (Object)paramterStr);
        try {
            String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
            this.logger.info("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
            if (null == ((Map)JSONObject.parseObject((String)result, Map.class)).get("code")) {
                throw new BusinessException("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a" + result);
            }
            CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)result, CommonResponse.class);
            if (!resp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a" + resp.getMsg());
            }
            return (JSONObject)resp.getData();
        }
        catch (Exception e) {
            this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @GetMapping(value={"checkBill"})
    public CommonResponse<String> checkBill(@RequestParam(value="fileId") Long fileId) {
        CommonResponse fileResp = this.attachmentApi.queryAttachmentDetail(fileId);
        if (!fileResp.isSuccess()) {
            return CommonResponse.error((String)fileResp.getMsg());
        }
        AttachmentVO attach = (AttachmentVO)fileResp.getData();
        CommonResponse mdReferResp = this.billTypeApi.queryMetadataByBillType(attach.getBillType());
        if (!mdReferResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        MdReferVO mdReferVO = (MdReferVO)mdReferResp.getData();
        JSONObject detail = this.reqResult(mdReferVO.getProjectName(), mdReferVO.getTableName(), attach.getSourceId(), mdReferVO.getMetadataId());
        if (null == detail) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        return CommonResponse.success((String)"\u6587\u6863\u5bf9\u5e94\u5355\u636e\u8be6\u60c5\u53ef\u67e5\u770b\uff01");
    }
}

