package com.ejianc.business.ecard.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecard.bean.UserInfoEntity;
import com.ejianc.business.ecard.service.IUserInfoService;
import com.ejianc.business.ecard.vo.UserInfoVO;
import com.ejianc.business.ecard.vo.WxConfigResponse;
import com.ejianc.business.ecard.vo.WxShareResponse;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.util.fst.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 用户名片信息录入
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("ecard")
public class EcardController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${wx.config.token}")
    private String TOKEN;//
    @Value("${wx.config.appid}")
    private String appid;//
    @Value("${wx.config.secret}")
    private String secret;//
    @Resource
    private RestTemplate restTemplate;
    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @GetMapping(value = "/getWxConfig",produces = "text/html;charset=utf-8")
    @ResponseBody
    public String getWxConfig(@RequestParam("signature") String signature,@RequestParam("timestamp") String timestamp,
                              @RequestParam("nonce") String nonce,@RequestParam("echostr") String echostr) {
        //排序
        String[] arr = {TOKEN, timestamp, nonce};
        Arrays.sort(arr);

        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; i++) {
            content.append(arr[i]);
        }

        //sha1Hex 加密
        MessageDigest md = null;
        String temp = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            temp = byteToStr(digest);
            logger.info("加密后的token:"+temp);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if ((temp.toLowerCase()).equals(signature)){
            return echostr;
        }
        return null;
    }

    @RequestMapping(value = "/share",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WxShareResponse> checkWx(String url){
        logger.info("/share输入的数据：{}",url);
        WxShareResponse wxShareResponse = queryWxShare(url);
      logger.info("/share即将输出的数据：{}",JSON.toJSON(wxShareResponse));
        return CommonResponse.success("保存或修改单据成功！",wxShareResponse);
    }



    public WxShareResponse queryWxShare(String url) {
        WxShareResponse wxShareResponse =new WxShareResponse();
        //从缓存中获取ticket
        String ticket;
        String accessToken;

        //调用微信api接口获取accessToken
        String getTokenUrl="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid="+appid+"&secret="+secret;
        WxConfigResponse wxToken = restTemplate.getForObject(getTokenUrl, WxConfigResponse.class);


        accessToken=wxToken.getAccess_token();
        if (wxToken.getErrcode()!=null&&wxToken.getErrcode()!=0){
            wxShareResponse.setErrcode(wxToken.getErrcode());
            wxShareResponse.setErrmsg(wxToken.getErrmsg());
            return wxShareResponse;
        }

        String getTicketUrl="https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token="+accessToken+"&type=jsapi";
        WxConfigResponse wxTicket = restTemplate.getForObject(getTicketUrl, WxConfigResponse.class);

        ticket=wxTicket.getTicket();
        System.out.println(wxTicket);
        if (wxTicket.getErrcode()!=null&&wxTicket.getErrcode()!=0){
            wxShareResponse.setErrcode(wxTicket.getErrcode());
            wxShareResponse.setErrmsg(wxTicket.getErrmsg());
            return wxShareResponse;
        }

        //结合url、ticket等生成加密签名
        String noncestr= UUID.randomUUID().toString();
        String timestamp= Long.toString(System.currentTimeMillis()/1000);

        String getSign="jsapi_ticket="+ticket+"&noncestr="+noncestr+"&timestamp="+timestamp+"&url="+url;
        String signature=getSha1(getSign);
        wxShareResponse.setNoncestr(noncestr);
        wxShareResponse.setTimestamp(timestamp);
        wxShareResponse.setSignature(signature);
        wxShareResponse.setAppid(appid);

        return wxShareResponse;
    }


    private static String byteToStr(byte[] byteArray){
        String strDigest = "";
        for (int i = 0; i < byteArray.length; i++) {
            strDigest += byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte){
        char[] Digit = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A','B', 'C', 'D', 'E', 'F' };
        char[] tempArr = new char[2];
        tempArr[0] = Digit[(mByte >>> 4)& 0X0F];
        tempArr[1] = Digit[mByte & 0X0F];
        String s = new String(tempArr);
        return s;
    }


    //sha1加密方法
    public static String getSha1(String inStr)  {
        MessageDigest sha = null;
        byte[] byteArray;
        try {
            sha = MessageDigest.getInstance("SHA");
            byteArray= inStr.getBytes("UTF-8");
        } catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }


        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; i++) {
            int val = ((int) md5Bytes[i]) & 0xff;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

}
