package com.ejianc.business.bi.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.bi.bean.IndustrialDistributionDetailEntity;
/**
 * BI集团产业分布
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bi_industrial_distribution")
public class IndustrialDistributionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码

    @TableField(value="unit_id")
    private Long unitId; // 组织id

    @TableField(value="unit_name")
    private String unitName; // 组织名称


    @TableField(value="unit_code")
    private String unitCode; // 组织编号

    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）

    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="parent_id")
    private Long parentId; // 上级ID
    @TableField(value="name")
    private String name; // 名称
    @TableField(value="count")
    private Integer count; // 数量
    @TableField(value="parent_name")
    private String parentName; // 上级name

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="industrialDistributionDetailService",pidName = "zhuId")
    private List<IndustrialDistributionDetailEntity> industrialDistributionDetailList = new ArrayList<>(); // BI集团产业分布子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitCode() {
        return unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public List<IndustrialDistributionDetailEntity> getIndustrialDistributionDetailList() {
        return industrialDistributionDetailList;
    }

    public void setIndustrialDistributionDetailList(List<IndustrialDistributionDetailEntity> industrialDistributionDetailList) {
        this.industrialDistributionDetailList = industrialDistributionDetailList;
    }
}
