package com.ejianc.business.ecard.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecard.bean.UserInfoEntity;
import com.ejianc.business.ecard.service.IUserInfoService;
import com.ejianc.business.ecard.vo.UserInfoVO;
import com.ejianc.business.ecard.vo.WxConfigResponse;
import com.ejianc.business.ecard.vo.WxShareResponse;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.util.fst.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 用户名片信息录入
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("ecard")
public class EcardController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${wx.config.token}")
    private String TOKEN;//
    @Value("${wx.config.appid}")
    private String appid;//
    @Value("${wx.config.secret}")
    private String secret;//
    @Resource
    private RestTemplate restTemplate;
    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }
    @Autowired
    private IThirdSystemApi thirdSystemService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @GetMapping(value = "/getWxConfig",produces = "text/html;charset=utf-8")
    @ResponseBody
    public String getWxConfig(@RequestParam("signature") String signature,@RequestParam("timestamp") String timestamp,
                              @RequestParam("nonce") String nonce,@RequestParam("echostr") String echostr) {
       //timestamp = String.valueOf(System.currentTimeMillis()/1000);

        //排序
        String[] arr = {TOKEN, timestamp, nonce};
        Arrays.sort(arr);

        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; i++) {
            content.append(arr[i]);
        }

        //sha1Hex 加密
        MessageDigest md = null;
        String temp = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            temp = byteToStr(digest);
            logger.info("加密后的token:"+temp);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if ((temp.toLowerCase()).equals(signature)){
            return echostr;
        }
        return null;
    }

    @RequestMapping(value = "/share",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WxShareResponse> checkWx(String url){
        logger.info("/share输入的数据：{}",url);
        WxShareResponse wxShareResponse = queryWxShare(url);
      logger.info("/share即将输出的数据：{}",JSON.toJSON(wxShareResponse));
        return CommonResponse.success("保存或修改单据成功！",wxShareResponse);
    }



    public WxShareResponse queryWxShare(String url) {
        WxShareResponse wxShareResponse =new WxShareResponse();
        //从缓存中获取ticket
        String ticket;
        String accessToken;

        //调用微信api接口获取accessToken
        String getTokenUrl="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid="+appid+"&secret="+secret;
        WxConfigResponse wxToken = restTemplate.getForObject(getTokenUrl, WxConfigResponse.class);


        accessToken=wxToken.getAccess_token();
        if (wxToken.getErrcode()!=null&&wxToken.getErrcode()!=0){
            wxShareResponse.setErrcode(wxToken.getErrcode());
            wxShareResponse.setErrmsg(wxToken.getErrmsg());
            return wxShareResponse;
        }

        String getTicketUrl="https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token="+accessToken+"&type=jsapi";
        WxConfigResponse wxTicket = restTemplate.getForObject(getTicketUrl, WxConfigResponse.class);

        ticket=wxTicket.getTicket();
        System.out.println(wxTicket);
        if (wxTicket.getErrcode()!=null&&wxTicket.getErrcode()!=0){
            wxShareResponse.setErrcode(wxTicket.getErrcode());
            wxShareResponse.setErrmsg(wxTicket.getErrmsg());
            return wxShareResponse;
        }

        //结合url、ticket等生成加密签名
        String noncestr= UUID.randomUUID().toString();
        String timestamp= Long.toString(System.currentTimeMillis()/1000);

        String getSign="jsapi_ticket="+ticket+"&noncestr="+noncestr+"&timestamp="+timestamp+"&url="+url;
        String signature=getSha1(getSign);
        wxShareResponse.setNoncestr(noncestr);
        wxShareResponse.setTimestamp(timestamp);
        wxShareResponse.setSignature(signature);
        wxShareResponse.setAppid(appid);

        return wxShareResponse;
    }

    public WxShareResponse queryWorkWxShare(String url) {
        //url = url+"?debug=1";
        WxShareResponse wxShareResponse =new WxShareResponse();
        //从缓存中获取ticket
        String ticket;
        String accessToken = null;
//        CommonResponse<String> wxcc9a690e5c66855c = thirdSystemService.getWXEEThirdAppAccessToken("wxcc9a690e5c66855c");
//        if (wxcc9a690e5c66855c.getCode()==0){
//            accessToken = wxcc9a690e5c66855c.getData();
//        }
       
        String key1 = "wxcc9a690e5c66855c_accessToken";
        String key2 = "wxcc9a690e5c66855c_ticket";

        accessToken = (String) redisTemplate.opsForValue().get(key1);
        logger.info("redis----accessToken="+accessToken);
        if(StringUtils.isBlank(accessToken)) {
            //调用微信api接口获取accessToken
            String getTokenUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + "wxcc9a690e5c66855c" + "&corpsecret=" + "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40&debug=1";
            WxConfigResponse wxToken = restTemplate.getForObject(getTokenUrl, WxConfigResponse.class);

            accessToken = wxToken.getAccess_token();
            logger.info("accessToken: " + accessToken);
            if (wxToken.getErrcode() != null && wxToken.getErrcode() != 0) {
                wxShareResponse.setErrcode(wxToken.getErrcode());
                wxShareResponse.setErrmsg(wxToken.getErrmsg());
                return wxShareResponse;
            }else {
                if(StringUtils.isNotBlank(accessToken)) {
                    redisTemplate.opsForValue().set(key1, accessToken, 7000, TimeUnit.SECONDS);
                }
            }
        }

        ticket= (String) redisTemplate.opsForValue().get(key2);
        logger.info("redis----ticket="+ticket);
        if(StringUtils.isBlank(ticket)) {
            String getTicketUrl = "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=" + accessToken + "&type=agent_config&debug=1";
            WxConfigResponse wxTicket = restTemplate.getForObject(getTicketUrl, WxConfigResponse.class);

            ticket = wxTicket.getTicket();
            logger.info("ticket: " + ticket);
            if (wxTicket.getErrcode() != null && wxTicket.getErrcode() != 0) {
                wxShareResponse.setErrcode(wxTicket.getErrcode());
                wxShareResponse.setErrmsg(wxTicket.getErrmsg());
                return wxShareResponse;
            }else {
                if(StringUtils.isNotBlank(ticket)) {
                    redisTemplate.opsForValue().set(key2, ticket, 7000, TimeUnit.SECONDS);
                }
            }
        }
        //结合url、ticket等生成加密签名
        String noncestr= UUID.randomUUID().toString();
        String timestamp= Long.toString(System.currentTimeMillis()/1000);

        String getSign="jsapi_ticket="+ticket+"&noncestr="+noncestr+"&timestamp="+timestamp+"&url="+url;


        String signature=getSha1(getSign);
        wxShareResponse.setNoncestr(noncestr);
        wxShareResponse.setTimestamp(timestamp);
        wxShareResponse.setSignature(signature);
        wxShareResponse.setAppid("wxcc9a690e5c66855c");

        return wxShareResponse;
    }
    private static String byteToStr(byte[] byteArray){
        String strDigest = "";
        for (int i = 0; i < byteArray.length; i++) {
            strDigest += byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte){
        char[] Digit = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A','B', 'C', 'D', 'E', 'F' };
        char[] tempArr = new char[2];
        tempArr[0] = Digit[(mByte >>> 4)& 0X0F];
        tempArr[1] = Digit[mByte & 0X0F];
        String s = new String(tempArr);
        return s;
    }


    //sha1加密方法
    public static String getSha1(String inStr)  {
        MessageDigest sha = null;
        byte[] byteArray;
        try {
            sha = MessageDigest.getInstance("SHA");
            byteArray= inStr.getBytes("UTF-8");
        } catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }


        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; i++) {
            int val = ((int) md5Bytes[i]) & 0xff;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }



    @RequestMapping(value = "/shareWork",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WxShareResponse> shareWork(String url){
        logger.info("/share输入的数据：{}",url);
        WxShareResponse wxShareResponse = queryWorkWxShare(url);
        logger.info("/share即将输出的数据：{}",JSON.toJSON(wxShareResponse));
        return CommonResponse.success("保存或修改单据成功！",wxShareResponse);
    }


    public static void main(String[] args) {
        String l = String.valueOf(System.currentTimeMillis()/1000);
        System.out.println(l);
    }

@Autowired
private RedisTemplate redisTemplate;

//    public String getWeixinCorpAccessToken(String corpAppId, String corpSecret, boolean reload) {
//        String key = corpAppId+"_"+corpSecret;
//        String accessToken = (String) redisTemplate.opsForValue().get(key);
//        logger.info("redis----accessToken="+accessToken);
//        System.out.println("redis----accessToken="+accessToken);
//        if(StringUtils.isBlank(accessToken) || reload) {
//            String accessResult = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid="+corpAppId+"&corpsecret="+corpSecret, null);
//            logger.info("accessResult="+accessResult);
//            System.out.println("accessResult="+accessResult);
//            if(StringUtils.isNotBlank(accessResult)) {
//                JSONObject accessJson = JSON.parseObject(accessResult);
//                accessToken = accessJson.getString("access_token");
//                if(StringUtils.isNotBlank(accessToken)) {
//                    redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
//                }
//            }
//        }
//        return accessToken;
//    }


    public  String get(String url) throws Exception {
        String content = null;
        URLConnection urlConnection = new URL(url).openConnection();
        HttpURLConnection connection = (HttpURLConnection) urlConnection;
        connection.setRequestMethod("GET");
        //连接
        connection.connect();
        //得到响应码
        int responseCode = connection.getResponseCode();
        if (responseCode == HttpURLConnection.HTTP_OK) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader
                    (connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder bs = new StringBuilder();
            String l;
            while ((l = bufferedReader.readLine()) != null) {
                bs.append(l).append("\n");
            }
            content = bs.toString();
        }
        return content;
    }

}
