package com.ejianc.business.ecard.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecard.vo.ProjTargetcostVO;
import com.ejianc.business.ecard.vo.TargetLrlReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.*;

/**
 * @Author sunxy
 * @Date 22/7/14 11:37
 */
@RestController
@RequestMapping("/es/")
public class TestController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 1L;

    private final static Integer QUERY_TIMEOUT = 60;

    @Autowired
    private IOrgApi orgApi;

    @Autowired(required = false)
    private RestHighLevelClient client;

    /**
     * 目标成本利润台账
     *
     * @return
     */
    @RequestMapping(value = "targetLrlPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TargetLrlReportVO>> targetLrlPage(@RequestBody QueryParam param) {
        logger.info("请求参数   param------------------：" + JSON.toJSONString(param));
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<TargetLrlReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("target_xmmblrtz");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchPhraseQuery("porName", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("pName", param.getSearchText());

            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2));
        }

        if (params != null && params.size() > 0) {

            String xfllv = getParamValue(params, "xfllv");
            if (StringUtils.isNotBlank(xfllv)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("xfllv", xfllv));
                params.remove("xfllv");

            }
            String cTime = getParamValue(params, "cTime");
            if (StringUtils.isNotBlank(cTime)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("cTime", cTime));
                params.remove("cTime");

            }

            String zhijiefeizhanshigonghetonge = getParamValue(params, "zhijiefeizhanshigonghetonge");
            if (StringUtils.isNotBlank(zhijiefeizhanshigonghetonge)) {

                RangeQueryBuilder zhijiefeizhanshigonghetonge1 = QueryBuilders.rangeQuery("zhijiefeizhanshigonghetonge");
                //zhijiefeizhanshigonghetonge1.boost(0.01f);
                //按指定项目id查询
                //boolQuery.must(QueryBuilders.termQuery("zhijiefeizhanshigonghetonge", zhijiefeizhanshigonghetonge));
                params.remove("zhijiefeizhanshigonghetonge");
                if ( "1".equals(zhijiefeizhanshigonghetonge)) {//90以上

                    zhijiefeizhanshigonghetonge1.gte(90);
                    zhijiefeizhanshigonghetonge1.lte(100000);
                    boolQuery.must(zhijiefeizhanshigonghetonge1);
                }else  if ( "2".equals(zhijiefeizhanshigonghetonge)) {//80以上,90一下
                    zhijiefeizhanshigonghetonge1.gte(80);
                    zhijiefeizhanshigonghetonge1.lte(89.999);
                    boolQuery.must(zhijiefeizhanshigonghetonge1);
                }else {
                    zhijiefeizhanshigonghetonge1.gte(0.0);
                    zhijiefeizhanshigonghetonge1.lte(79.999);
                    boolQuery.must(zhijiefeizhanshigonghetonge1);
                }
            }
            String engineeringTypeName = getParamValue(params, "engineeringTypeName");
            if (StringUtils.isNotBlank(engineeringTypeName)) {

                List<String> orgIdS = new ArrayList<>();
                if("房建".equals(engineeringTypeName)){
                    orgIdS.add("1543799043577856001");
                    orgIdS.add("1508279975020908545");
                    orgIdS.add("1508280161793265665");
                    orgIdS.add("1508280244257476610");
                }else if("市政".equals(engineeringTypeName)){
                    orgIdS.add("1506579865592565761");
                    orgIdS.add("1508280612022439938");
                    orgIdS.add("1508280815651704833");
                    orgIdS.add("1508280877136007170");
                    orgIdS.add("1508280929900351489");
                }else {
                    orgIdS.add("1506580163417509890");
                    orgIdS.add("1506580227888156674");
                    orgIdS.add("1506580278014283778");
                    orgIdS.add("1506580325225369602");
                    orgIdS.add("1506580379570966530");
                    orgIdS.add("1506580435753668610");
                    orgIdS.add("1506580495430225922");
                    orgIdS.add("1678193025898856449");
                    orgIdS.add("1506517642809184257");
                }

                //in搜索
                boolQuery.must(QueryBuilders.termsQuery("engineering_type_id", orgIdS));

                params.remove("engineeringTypeName");
            }



            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchPhraseQuery(key, value));
            }
        } else {
            List<String> orgIdS = new ArrayList<>();
            List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                for (OrgVO vo : orgVOS) {
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        logger.info("打印查询参数   boolQuery------------------：" + JSON.toJSONString(boolQuery));
        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<TargetLrlReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("----------------response获取数据为--------------：{}", JSON.toJSONString(response));
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, TargetLrlReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理


//            for (int i = 0; i < list.size() - 1; i++) {
//                for (int j = list.size() - 1; j > i; j--) {
//                    if (list.get(j).getBillid().equals(list.get(i).getBillid())) {
//                        list.remove(j);// 删除重复元素
//                    }
//                }
//            }
            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
//        /**
//         * 本地测试无es环境
//         */
//        //测试
//        page.setCurrent(pageNumber);
//        page.setSize(pageSize);
//        //查询结果
//        page.setRecords(null);
//        //总条数
//        page.setTotal(0);
//        /**
//         * 测试结束
//         */
        return CommonResponse.success("查询成功！", page);
    }
    /**
     * 目标执行情况台账
     *
     * @return
     */
    @RequestMapping(value = "projTargetcostPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjTargetcostVO>> projTargetcostPage(@RequestBody QueryParam param) {
        logger.info("请求参数   param------------------：" + JSON.toJSONString(param));
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<ProjTargetcostVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("proj_targetcost");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchPhraseQuery("parentOrgName", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("name", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchPhraseQuery("statusName", param.getSearchText());
            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3));
        }
        //目标金额不为空
        boolQuery.must(QueryBuilders.existsQuery("targetCostTotalMny"));
        if (params != null && params.size() > 0) {

            String zongzhichubizongmubiao = getParamValue(params, "zongzhichubizongmubiao");
            if (StringUtils.isNotBlank(zongzhichubizongmubiao)) {

                RangeQueryBuilder zongzhichubizongmubiao1 = QueryBuilders.rangeQuery("zongzhichubizongmubiao");
                //zhijiefeizhanshigonghetonge1.boost(0.01f);
                //按指定项目id查询
                //boolQuery.must(QueryBuilders.termQuery("zhijiefeizhanshigonghetonge", zhijiefeizhanshigonghetonge));
                params.remove("zongzhichubizongmubiao");
                if ( "1".equals(zongzhichubizongmubiao)) {//80以上

                    zongzhichubizongmubiao1.gte(80);
                    zongzhichubizongmubiao1.lte(100000);
                    boolQuery.must(zongzhichubizongmubiao1);
                }else  if ( "2".equals(zongzhichubizongmubiao)) {//60以上,80一下
                    zongzhichubizongmubiao1.gte(60);
                    zongzhichubizongmubiao1.lte(79.999);
                    boolQuery.must(zongzhichubizongmubiao1);
                }else  if ( "3".equals(zongzhichubizongmubiao)) {//40以上,60一下
                    zongzhichubizongmubiao1.gte(40);
                    zongzhichubizongmubiao1.lte(59.999);
                    boolQuery.must(zongzhichubizongmubiao1);
                }else {
                    zongzhichubizongmubiao1.gte(-1000.0);
                    zongzhichubizongmubiao1.lte(39.999);
                    boolQuery.must(zongzhichubizongmubiao1);
                }
            }

            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchPhraseQuery(key, value));
            }
        } else {
            List<String> orgIdS = new ArrayList<>();
            List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                for (OrgVO vo : orgVOS) {
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        logger.info("打印查询参数   boolQuery------------------：" + JSON.toJSONString(boolQuery));
        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<ProjTargetcostVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("----------------response获取数据为--------------：{}", JSON.toJSONString(response));
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, ProjTargetcostVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理


//            for (int i = 0; i < list.size() - 1; i++) {
//                for (int j = list.size() - 1; j > i; j--) {
//                    if (list.get(j).getBillid().equals(list.get(i).getBillid())) {
//                        list.remove(j);// 删除重复元素
//                    }
//                }
//            }
            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
//        /**
//         * 本地测试无es环境
//         */
//        //测试
//        page.setCurrent(pageNumber);
//        page.setSize(pageSize);
//        //查询结果
//        page.setRecords(null);
//        //总条数
//        page.setTotal(0);
//        /**
//         * 测试结束
//         */
        return CommonResponse.success("查询成功！", page);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

