package com.ejianc.business.ecard.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.desktop.api.IAllProjectSetPoolApi;
import com.ejianc.business.desktop.api.IIdmUserApi;
import com.ejianc.business.desktop.vo.WeixineeUserVO;
import com.ejianc.business.ecard.bean.UserInfoEntity;
import com.ejianc.business.ecard.enums.SpTypeEnum;
import com.ejianc.business.ecard.service.IWorkWxService;
import com.ejianc.business.ecard.vo.UserInfoVO;
import com.ejianc.business.ecard.vo.workWx.ContentsDTO;
import com.ejianc.business.ecard.vo.workWx.LeaveRequestDTO;
import com.ejianc.business.weixinee.bean.CheckinEntity;
import com.ejianc.business.weixinee.bean.LeaveRequestEntity;
import com.ejianc.business.weixinee.service.ICheckinService;
import com.ejianc.business.weixinee.service.ILeaveRequestService;
import com.ejianc.business.weixinee.vo.CheckinLeaveDTO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.springframework.data.redis.core.RedisTemplate;

import javax.net.ssl.*;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author sunxy
 * @Date 22/7/14 11:37
 */
@RestController
@RequestMapping("/workWx/")
public class WorkWxController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IWorkWxService workWxService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ILeaveRequestService leaveRequestService;
    @Autowired
    private IAllProjectSetPoolApi allProjectSetPoolApi;
    private static final long serialVersionUID = 1L;

    @Autowired
    private IIdmUserApi idmUserApi;

    @Autowired
    private ICheckinService checkinService;
    /**
     * @Description 同步微信请假数据
     * @param
     */
    @RequestMapping(value = "/queryLeaveRequestData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryLeaveRequestData(HttpServletRequest request) {
        long time = System.currentTimeMillis();

        //获取AccessToken
        String accessToken = workWxService.getAccessToken("dqeBQs_XyhYBjBibJrovaqW87pvNofHr5wYqYMC3wXo",null);
        //批量获取审批单号
        String startTime =  String.valueOf((time-1000*60*60) / 1000);
        String endTime = String.valueOf(time / 1000);
        if (redisTemplate.opsForValue().get("leave_data_last_time") != null) {
            startTime =  redisTemplate.opsForValue().get("leave_data_last_time").toString();
            redisTemplate.opsForValue().set("leave_data_last_time",endTime);
        }else {
            redisTemplate.opsForValue().set("leave_data_last_time",endTime);
        }
        JSONObject getBillCodes = doPost("https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovalinfo?access_token=" + accessToken,
                "{\"starttime\" : "+startTime+",\"endtime\" : "+endTime+",\"new_cursor\" : \"\" ,\"size\" : 100 ,\"filters\" : [{\"key\": \"template_id\",\"value\": \"1970325056025175_1688851392291681_98642968_1501744141\"}]}");

        //先将JsonArray转为String
        String newIds = getBillCodes.getJSONArray("sp_no_list").toString();
        //再将String转为List<String>
        List<String> spNoList = JSONObject.parseArray(newIds,String.class);


        //JSONArray spNoList = getBillCodes.getJSONArray("sp_no_list");
        if (!spNoList.isEmpty()){
            //List<String> stringList = BeanMapper.mapList(spNoList, String.class);

            for (String s : spNoList) {
                //获取审批申请详情
                JSONObject jsonObject = doPost("https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovaldetail?access_token=" + accessToken, "{\"sp_no\" : "+s+"}");
                LeaveRequestDTO map = BeanMapper.map(jsonObject, LeaveRequestDTO.class);
                if (map.getErrcode() == 0 && map.getInfo() != null){
                    LeaveRequestEntity leaveRequestEntity = new LeaveRequestEntity();
                    leaveRequestEntity.setSpNo(map.getInfo().getSp_no());//企微编号
                    leaveRequestEntity.setSpStatus(map.getInfo().getSp_status());//审批状态
                    leaveRequestEntity.setApplyTime(map.getInfo().getApply_time());//提交时间
                    leaveRequestEntity.setWeixineeUsercode(map.getInfo().getApplyer().getUserid());//企微人员id

                    CommonResponse<WeixineeUserVO> weixineeUserVOCommonResponse = allProjectSetPoolApi.queryUserByWeixineeId(map.getInfo().getApplyer().getUserid());
                    if (weixineeUserVOCommonResponse.getCode() == 0){
                        WeixineeUserVO data = weixineeUserVOCommonResponse.getData();
                        leaveRequestEntity.setUserId(data.getId());//用户id
                        leaveRequestEntity.setUserName(data.getUserName());//
                        leaveRequestEntity.setDeptId(data.getDeptId());//部门
                        leaveRequestEntity.setDeptName(data.getName());//
                        leaveRequestEntity.setUserCode(data.getUserCode());
                    }
                    List<ContentsDTO> contents = map.getInfo().getApply_data().getContents();
                    for (ContentsDTO content : contents) {
                        if ("Vacation".equals(content.getControl())){
                            leaveRequestEntity.setLeaveType(content.getValue().getVacation().getSelector().getOptions().get(0).getValue().get(0).getText());//
                            leaveRequestEntity.setNewBegin(content.getValue().getVacation().getAttendance().getDate_range().getNew_begin());//开始时间
                            leaveRequestEntity.setNewEnd(content.getValue().getVacation().getAttendance().getDate_range().getNew_end());//结束时间
                            leaveRequestEntity.setNewDuration(content.getValue().getVacation().getAttendance().getDate_range().getNew_duration());//
                        }else if ("Textarea".equals(content.getControl())){
                            leaveRequestEntity.setMemo(content.getValue().getText());//
                        }
                    }
                    leaveRequestService.saveOrUpdate(leaveRequestEntity);
                }
                //暂停0.1秒
                try {
                    Thread.sleep (150);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        //获取近六天审批中的单据
        String yesterday =  String.valueOf((time-1000*60*60*24*6) / 1000);
        QueryWrapper<LeaveRequestEntity> wrapper = new QueryWrapper<>();
        wrapper.between("apply_time",yesterday,startTime);
        wrapper.eq("sp_status",1);
        List<LeaveRequestEntity> list = leaveRequestService.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)){
            for (LeaveRequestEntity leaveRequestEntity : list) {
                //获取审批申请详情
                JSONObject jsonObject = doPost("https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovaldetail?access_token=" + accessToken, "{\"sp_no\" : "+leaveRequestEntity.getSpNo()+"}");
                LeaveRequestDTO map = BeanMapper.map(jsonObject, LeaveRequestDTO.class);
                if (map.getErrcode() == 0 && map.getInfo() != null){
                    leaveRequestEntity.setSpStatus(map.getInfo().getSp_status());//
                    leaveRequestService.saveOrUpdate(leaveRequestEntity);
                }
                //暂停0.1秒
                try {
                    Thread.sleep (150);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！");
    }


    /**
     * @Description 同步微信考勤数据
     * @param
     */
    @RequestMapping(value = "/queryCheckinData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryCheckinData(HttpServletRequest request) {
        logger.info("同步微信考勤数据---开始------------");
        //获取AccessToken
        String accessToken = workWxService.getAccessToken("h3Ivvvr2RPHPaJ767ymaLYcsNspYLyzBwgfjhLNPX9U",null);
        //获取上月的开始和结束时间戳
        String startTime = String.valueOf(getLastMonthStartTime());
        String endTime = String.valueOf(getLastMonthEndTime());
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM");
        String startTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochSecond(getLastMonthStartTime()), ZoneId.systemDefault()));


        //获取人员的weixineeids
        CommonResponse<List<UserVO>> weixineeIdList = idmUserApi.getWeixineeIdList();
        if  (weixineeIdList.getCode() == 0){
            logger.info("获取人员weixineeids成功！");
            List<UserVO> weixineeIdListData = weixineeIdList.getData();
            logger.info("人员weixineeids数量："+weixineeIdListData.size());
            if (CollectionUtils.isNotEmpty(weixineeIdListData)){
                List<List<UserVO>> newList = Lists.partition(weixineeIdListData, 100);

                for (List<UserVO> strings : newList) {
                    List<String> wixineeIds = strings.stream().map(UserVO::getWeixineeId).collect(Collectors.toList());
                    String ids = "\""+StringUtils.join(wixineeIds, "\",\"")+"\"";
                    Map<String, UserVO> collect = strings.stream().collect(Collectors.toMap(user -> user.getWeixineeId() + user.getUserName(), Function.identity(), (v1, v2) -> v2));

                    JSONObject getBillCodes = doPost("https://qyapi.weixin.qq.com/cgi-bin/checkin/getcheckin_monthdata?access_token=" + accessToken,
                            "{\"starttime\" : "+startTime+",\"endtime\" : "+endTime+",\"useridlist\" : ["+ids+"]}");
                    //先将JsonArray转为String
                    String datas = getBillCodes.getJSONArray("datas").toString();
//                    logger.info(datas);
                    String errmsg = getBillCodes.getString("errmsg").toString();
                    logger.info(errmsg);

                    ArrayList<CheckinEntity> checkinEntityList = new ArrayList<>();
                    //再将String转为List<String>
                    List<JSONObject> spNoList = JSONObject.parseArray(datas,JSONObject.class);
                    if (CollectionUtils.isNotEmpty(spNoList)){
                        for (JSONObject spNo : spNoList) {

                            //基础数据解析
                            JSONObject baseInfo = spNo.getJSONObject("base_info");
                            String acctid = baseInfo.getString("acctid");
                            String name = baseInfo.getString("name");
                            if (collect.containsKey(acctid+name)) {
                                CheckinEntity checkinEntity;
                                UserVO userVO = collect.get(acctid + name);
                                QueryParam param = new QueryParam();
                                param.getParams().put("usercode",new Parameter(QueryParam.EQ,userVO.getUserCode()));
                                param.getParams().put("yearmonth",new Parameter(QueryParam.EQ,startTimeStr));
                                List<CheckinEntity> checkinEntities = checkinService.queryList(param);
                                if (CollectionUtils.isEmpty(checkinEntities)){
                                    checkinEntity = new CheckinEntity();
                                }else {
                                    checkinEntity = checkinEntities.get(0);
                                }
                                //汇总数据解析
                                JSONObject summaryInfo = spNo.getJSONObject("summary_info");
                                BigDecimal restDays = summaryInfo.getBigDecimal("rest_days");
                                BigDecimal regularDays = summaryInfo.getBigDecimal("regular_days");
                                BigDecimal workDays = summaryInfo.getBigDecimal("work_days");

                                checkinEntity.setWeixineeUsercode(acctid);//微信员工编号
                                checkinEntity.setUsercode(userVO.getUserCode());//员工编号
                                checkinEntity.setUserName(userVO.getUserName());//
                                checkinEntity.setYearmonth(startTimeStr);
                                checkinEntity.setRestDays(restDays);
                                checkinEntity.setRegularDays(regularDays);
                                checkinEntity.setWorkDays(workDays);
                                checkinEntity.setBillState(1);

                                //请假汇总信息解析
                                //先将JsonArray转为String
                                String newIds = spNo.getJSONArray("sp_items").toString();
                                //再将String转为List<String>
                                List<CheckinLeaveDTO> spItems = JSONObject.parseArray(newIds, CheckinLeaveDTO.class);
                                if(CollectionUtils.isNotEmpty(spItems)){
                                    Long totalSpDays = 0L;
                                    for (CheckinLeaveDTO checkinLeaveDTO : spItems) {
                                        if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.本地公出.getCode()) {
                                            // 处理本地公出的逻辑
                                            checkinEntity.setBdgc(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.外地出差.getCode()) {
                                            checkinEntity.setWdcc(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.事假.getCode()) {
                                            checkinEntity.setShijia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.病假.getCode()) {
                                            checkinEntity.setBingjia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.婚假.getCode()) {
                                            checkinEntity.setHunjia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.产假.getCode()) {
                                            checkinEntity.setChanjia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.丧假.getCode()) {
                                            checkinEntity.setSangjia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.护理假.getCode()) {
                                            checkinEntity.setHulijia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        } else if (checkinLeaveDTO.getVacation_id() == SpTypeEnum.年休假.getCode()) {
                                            checkinEntity.setNianxiujia(new BigDecimal(checkinLeaveDTO.getDuration()/60/60/8).setScale(2, RoundingMode.HALF_UP));
                                            totalSpDays = totalSpDays + checkinLeaveDTO.getDuration();
                                        }

                                    }
                                    BigDecimal spDays = new BigDecimal(totalSpDays / 60 / 60 / 8).setScale(2, RoundingMode.HALF_UP);
                                    //实际出勤天数没算完
                                }

                                checkinEntityList.add(checkinEntity);
                            }
                        }
                    }

                    if (CollectionUtils.isNotEmpty(checkinEntityList)){
                        checkinService.saveOrUpdateBatch(checkinEntityList);
                    }

                    //休眠，接口限制一秒钟一次
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }

                }
            }
        }else {
            logger.info("获取人员weixineeids失败！");
        }



        logger.info("同步微信考勤数据---结束------------");
        return CommonResponse.success("查询详情数据成功！");
    }

    public static JSONObject doPost(String url, String json) {
        HttpResponse jsonResponse = null;
        try {
            JsonNode jsonNode = new JsonNode(json);
            jsonResponse = Unirest.post(url)
                    .body(jsonNode)
                    .asJson();
        } catch (UnirestException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject(jsonResponse.getBody().toString());
    }
    public static JSONObject doGet(String url) {
        HttpResponse jsonResponse = null;
        try {

            jsonResponse = Unirest.get(url)
                    .asJson();
        } catch (UnirestException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject(jsonResponse.getBody().toString());
    }

    public static void main(String[] args) {
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM");
        String startTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochSecond(getLastMonthStartTime()), ZoneId.systemDefault()));
        System.out.println(startTimeStr);
    }

    //获取上月开始的时间戳
    public static long getLastMonthStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(Calendar.YEAR),calendar.get(Calendar.MONTH)-1,1,0,0,0);
        long tt = calendar.getTime().getTime()/1000;
        return tt;
    }
    //获取上月结束的时间戳
    public  long getLastMonthEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(Calendar.YEAR),calendar.get(Calendar.MONTH)-1,calendar.get(Calendar.DAY_OF_MONTH),23,59,59);
        calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        long tt = calendar.getTime().getTime()/1000;
        return tt;
    }



    /**
     * @Description 推送企微应用消息
     * @param
     */
    @RequestMapping(value = "/pushMessage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> pushMessage(HttpServletRequest request) {
        logger.info("同步微信考勤数据---开始------------");
        //获取AccessToken
        String accessToken = workWxService.getAccessToken("4WbW9UiyDhE2VgRPHVkEqPtHTYVv5cdK0nt9-KdQ9Yo","ww36055c5dd2b132d8");

        JSONObject getBillCodes = doPost("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken,
                "{\n" +
                        "\t\"chatid\": \"123456\",\n" +
                        "\t\"msgtype\":\"textcard\",\n" +
                        "\t\"textcard\":{\n" +
                        "\t\t\"title\" : \"领奖通知\",\n" +
                        "\t\t\"description\" : \"<div class=\\\"gray\\\">2016年9月26日</div> <div class=\\\"normal\\\"> 恭喜你抽中iPhone 7一台，领奖码:520258</div><div class=\\\"highlight\\\">请于2016年10月10日前联系行 政同事领取</div>\",\n" +
                        "\t\t\"url\":\"https://work.weixin.qq.com/\",\n" +
                        "\t\t\"btntxt\":\"更多\"\n" +
                        "\t},\n" +
                        "\t\"safe\":0\n" +
                        "}");

        logger.info("推送企微消息---结束------------"+getBillCodes.toJSONString());
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @Description 推送企微应用消息
     * @param
     */
    @RequestMapping(value = "/getUserIdByWeixinCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getUserIdByWeixinCode(String token,String corpsecret,String corpid) {
        logger.info("获取userId通过企微token---开始------------"+token);
        //获取AccessToken
        String accessToken = workWxService.getAccessToken(corpsecret,corpid);

        JSONObject getBillCodes = doGet("https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token" + accessToken+"&code="+token);
        String userid = "";
        if (getBillCodes.getInteger("errcode") == 0) {
            String weixineeId = getBillCodes.getString("userid");
            CommonResponse<UserVO> userByWeixineeId = idmUserApi.getUserByWeixineeId(weixineeId);
            if (userByWeixineeId.isSuccess()) {
                userid = userByWeixineeId.getData().getId()+"";
            }else {
                return CommonResponse.error("根据企微id查询人员信息失败！"+weixineeId);
            }
        }else {
            return CommonResponse.error("获取企微id失败！");
        }
        logger.info("推送企微消息---结束------------"+getBillCodes.toJSONString());
        return CommonResponse.success("查询详情数据成功！",userid);
    }
}

