package com.ejianc.business.exam.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.exam.bean.PaperQuestionsEntity;
import com.ejianc.business.exam.bean.PaperUserEntity;
/**
 * 试卷
 * 
 * @author generator
 * 
 */
 @TableName("ejc_exam_paper")
public class PaperEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="paper_name")
    private String paperName; // 试卷名称
    @TableField(value="paper_type_id")
    private Long paperTypeId; // 试卷类型id
    @TableField(value="paper_type_name")
    private String paperTypeName; // 试卷类型
    @TableField(value="offer_paper_id")
    private Long offerPaperId; // 出题单位id
    @TableField(value="offer_paper_name")
    private String offerPaperName; // 出题单位
    @TableField(value="category_id")
    private Long categoryId; // 所属板块id
    @TableField(value="category_name")
    private String categoryName; // 所属板块
    @TableField(value="start_time")
    private Date startTime; // 开始时间
    @TableField(value="end_time")
    private Date endTime; // 结束时间
    @TableField(value="exam_time")
    private Date examTime; // 考试日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="paperQuestionsService")
    private List<PaperQuestionsEntity> paperQuestionsList = new ArrayList<>(); // 试卷-试题
    @TableField(exist=false)
    @SubEntity(serviceName="paperUserService")
    private List<PaperUserEntity> paperUserList = new ArrayList<>(); // 试卷-人员
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getPaperName() {
        return paperName;
    }

    public void setPaperName(String paperName) {
        this.paperName = paperName;
    }
    public Long getPaperTypeId() {
        return paperTypeId;
    }

    public void setPaperTypeId(Long paperTypeId) {
        this.paperTypeId = paperTypeId;
    }
    public String getPaperTypeName() {
        return paperTypeName;
    }

    public void setPaperTypeName(String paperTypeName) {
        this.paperTypeName = paperTypeName;
    }
    public Long getOfferPaperId() {
        return offerPaperId;
    }

    public void setOfferPaperId(Long offerPaperId) {
        this.offerPaperId = offerPaperId;
    }
    public String getOfferPaperName() {
        return offerPaperName;
    }

    public void setOfferPaperName(String offerPaperName) {
        this.offerPaperName = offerPaperName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public Date getExamTime() {
        return examTime;
    }

    public void setExamTime(Date examTime) {
        this.examTime = examTime;
    }
    

    public List<PaperQuestionsEntity> getPaperQuestionsList() {
        return paperQuestionsList;
    }

    public void setPaperQuestionsList(List<PaperQuestionsEntity> paperQuestionsList) {
        this.paperQuestionsList = paperQuestionsList;
    }

    public List<PaperUserEntity> getPaperUserList() {
        return paperUserList;
    }

    public void setPaperUserList(List<PaperUserEntity> paperUserList) {
        this.paperUserList = paperUserList;
    }
}
