package com.ejianc.business.exam.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.exam.bean.QuestionsOptionEntity;
/**
 * 试题
 * 
 * @author generator
 * 
 */
 @TableName("ejc_exam_questions")
public class QuestionsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="question_name")
    private String questionName; // 试题
    @TableField(value="question_score")
    private BigDecimal questionScore; // 分值
    @TableField(value="offer_paper_id")
    private Long offerPaperId; // 出题单位id
    @TableField(value="offer_paper_name")
    private String offerPaperName; // 出题单位
    @TableField(value="category_id")
    private Long categoryId; // 所属板块id
    @TableField(value="category_name")
    private String categoryName; // 所属板块
    @TableField(value="answer")
    private String answer; // 标准答案
    @TableField(value="question_type")
    private String questionType; // 试题类型
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="question_state")
    private Integer questionState; // 是否可用（1是0否）

    @TableField(value="answer_option_ids")
    private String answerOptionIds; // 标准答案子表id

    public String getAnswerOptionIds() {
        return answerOptionIds;
    }

    public void setAnswerOptionIds(String answerOptionIds) {
        this.answerOptionIds = answerOptionIds;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="questionsOptionService")
    private List<QuestionsOptionEntity> questionsOptionList = new ArrayList<>(); // 试题-选项
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getQuestionName() {
        return questionName;
    }

    public void setQuestionName(String questionName) {
        this.questionName = questionName;
    }
    public BigDecimal getQuestionScore() {
        return questionScore;
    }

    public void setQuestionScore(BigDecimal questionScore) {
        this.questionScore = questionScore;
    }
    public Long getOfferPaperId() {
        return offerPaperId;
    }

    public void setOfferPaperId(Long offerPaperId) {
        this.offerPaperId = offerPaperId;
    }
    public String getOfferPaperName() {
        return offerPaperName;
    }

    public void setOfferPaperName(String offerPaperName) {
        this.offerPaperName = offerPaperName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getAnswer() {
        return answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }
    public String getQuestionType() {
        return questionType;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getQuestionState() {
        return questionState;
    }

    public void setQuestionState(Integer questionState) {
        this.questionState = questionState;
    }
    

    public List<QuestionsOptionEntity> getQuestionsOptionList() {
        return questionsOptionList;
    }

    public void setQuestionsOptionList(List<QuestionsOptionEntity> questionsOptionList) {
        this.questionsOptionList = questionsOptionList;
    }
}
