package com.ejianc.business.exam.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.desktop.vo.TaskVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author:sunxy
 * @Description:超期待办预警
 * @date 2022/6/6 11:22
 */
@RestController
@RequestMapping(value = "/warn/")
public class MessageController {
//       * * * 26 * ?            {"dispatchCode":"WARNING000110"}
   //    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());





    static  String  PC_URL = "/ejc-ecard-mobile/#/exam";
    static  String  TEST_AGENTID = "1000038";
    static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static  String  PRO_AGENTID = "1000036";
    static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";


    @Autowired
    private IPushMessageApi pushMessageApi;
    //预警代办提醒
    public boolean sendSys(String receiverId){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {receiverId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("task");//预警消息
        parameter.setSubject("考试提醒！");// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl(PC_URL);// pc端url
        parameter.setMobileUrl(PC_URL);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", PRO_AGENTID);//企业微信应用id
        weixineeParams.put("secret", PRO_SECRET);//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "考试提醒");
        weixineeParams.put("description", "请您在规定时间内完成考试！");
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
                "&targeturl=https%3A%2F%2Fpms.zzyjjt.com%2Fejc-ecard-mobile%2F%23%2Fexam"));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.error("消息发送成功---------------->,接收人:{}," + result.getMsg(), Arrays.toString(receivers));

            return true;
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return false;
        }
    }

}