package com.ejianc.business.exam.controller;

import java.io.Serializable;

import com.ejianc.business.exam.bean.*;
import com.ejianc.business.exam.service.*;
import com.ejianc.business.exam.vo.QuestionsOptionVO;
import com.ejianc.business.exam.vo.QuestionsVO;
import com.ejianc.business.weixinee.bean.LeaveRequestEntity;
import com.ejianc.business.weixinee.vo.CheckinVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.exam.vo.PaperUserAnswerVO;

/**
 * 试卷-答卷
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("paperUserAnswer")
public class PaperUserAnswerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IQuestionsOptionService questionsOptionService;

    @Autowired
    private IQuestionsService questionsService;

    @Autowired
    private IPaperUserService paperUserService;
    @Autowired
    private IPaperService paperService;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPaperUserAnswerService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaperUserAnswerVO> saveOrUpdate(@RequestBody PaperUserAnswerVO saveOrUpdateVO) {
    	PaperUserAnswerEntity entity = BeanMapper.map(saveOrUpdateVO, PaperUserAnswerEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PaperUserAnswerVO vo = BeanMapper.map(entity, PaperUserAnswerVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PaperUserAnswerVO>> saveOrUpdateBatch(@RequestBody List<PaperUserAnswerVO> vos) {
    	List<PaperUserAnswerEntity> entity = BeanMapper.mapList(vos, PaperUserAnswerEntity.class);
        PaperEntity paperEntity = paperService.selectById(entity.get(0).getPid());
        //判断考试时间是否结束
        if (paperEntity.getEndTime().getTime() < System.currentTimeMillis()){
            return CommonResponse.error("考试时间已结束！");
        }

        Long paperId = entity.get(0).getPid();
        Long userId = entity.get(0).getUserId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,paperId));
        queryParam.getParams().put("userId",new Parameter(QueryParam.EQ,userId));

        //判断是否考试完成
        List<PaperUserEntity> paperUserEntities = paperUserService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(paperUserEntities) && paperUserEntities.size() == 1){
            if("已完成".equals(paperUserEntities.get(0).getExamState())){
                return CommonResponse.error("已经考试完成，不要重复提交试卷！");
            }
        }else {
            return CommonResponse.error("保存失败！获取人员失败！请联系系统管理员！");
        }

        service.saveOrUpdateBatch(entity);


        List<PaperUserAnswerEntity> paperUserAnswerEntities = service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(paperUserAnswerEntities)){
            for (PaperUserAnswerEntity paperUserAnswerEntity : paperUserAnswerEntities) {
                if (paperUserAnswerEntity.getUserAnswer() == null){
                    return CommonResponse.error("保存失败！存在为空的数据！请联系系统管理员！"+paperUserAnswerEntity.getId());
                }
            }
        }else {
            return CommonResponse.error("保存失败！获取试题失败！请联系系统管理员！");
        }

        //计算得分  先获取试题答案
        BigDecimal score = new  BigDecimal(0);
        Set<Long> questionsIds = paperUserAnswerEntities.stream().map(PaperUserAnswerEntity::getQuestionsId).collect(Collectors.toSet());
        QueryParam questionParam = new QueryParam();
        questionParam.getParams().put("id",new Parameter(QueryParam.IN,questionsIds));
        List<QuestionsEntity> questionsVOS = questionsService.queryList(questionParam);
        Map<Long,QuestionsEntity> questionMap = questionsVOS.stream().collect(Collectors.toMap(QuestionsEntity::getId, Function.identity()));
        for (PaperUserAnswerEntity paperUserAnswerEntity : paperUserAnswerEntities) {
            QuestionsEntity questionsEntity = questionMap.get(paperUserAnswerEntity.getQuestionsId());
            if (questionsEntity != null){
                List<String> answer = Arrays.asList(questionsEntity.getAnswerOptionIds().split(","));
                List<String> userAnswer = Arrays.asList(paperUserAnswerEntity.getUserAnswer().split(","));
                //答案长度需要一致，且完全相同
                if (answer.size() == userAnswer.size() && answer.containsAll(userAnswer)){
                    paperUserAnswerEntity.setScore(questionsEntity.getQuestionScore());
                    score = score.add(questionsEntity.getQuestionScore());
                }else {
                    paperUserAnswerEntity.setScore(BigDecimal.ZERO);
                }
            }
        }
        service.saveOrUpdateBatch(paperUserAnswerEntities);

        //修改考试状态
        //List<PaperUserEntity> paperUserEntities = paperUserService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(paperUserEntities) && paperUserEntities.size() == 1){
            if("已完成".equals(paperUserEntities.get(0).getExamState())){
                return CommonResponse.error("已经考试完成，不要重复提交试卷！");
            }
            paperUserEntities.get(0).setExamState("已完成");
            paperUserEntities.get(0).setScore(score);
            paperUserService.saveOrUpdate(paperUserEntities.get(0), false);
        }else {
            return CommonResponse.error("保存失败！获取人员失败！请联系系统管理员！");
        }

        List<PaperUserAnswerVO> vo = BeanMapper.mapList(entity, PaperUserAnswerVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaperUserAnswerVO> queryDetail(Long id) {
    	PaperUserAnswerEntity entity = service.selectById(id);
    	PaperUserAnswerVO vo = BeanMapper.map(entity, PaperUserAnswerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaperUserAnswerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PaperUserAnswerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PaperUserAnswerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PaperUserAnswerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<PaperUserAnswerEntity> page = service.queryPage(param,false);

        List<Long> questionsIds = page.getRecords().stream().map(PaperUserAnswerEntity::getQuestionsId).collect(Collectors.toList());


        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.IN, questionsIds));
        List<QuestionsOptionEntity> questionsOptionEntities = questionsOptionService.queryList(queryParam);
        Map<Long, List<QuestionsOptionEntity>> questionsOptionMap = questionsOptionEntities.stream().collect(Collectors.groupingBy(QuestionsOptionEntity::getPid));

        QueryParam queryParam1 = new QueryParam();
        queryParam1.getParams().put("id", new Parameter(QueryParam.IN, questionsIds));
        List<QuestionsEntity> questionsEntities = questionsService.queryList(queryParam1);
        Map<Long, QuestionsEntity> questionsMap = questionsEntities.stream().collect(Collectors.toMap(QuestionsEntity::getId, Function.identity(), (key1, key2) -> key2));


        IPage<PaperUserAnswerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaperUserAnswerVO.class));

        for (PaperUserAnswerVO record : pageData.getRecords()) {
            if (questionsMap.containsKey(record.getQuestionsId())){
                record.setQuestionType(questionsMap.get(record.getQuestionsId()).getQuestionType());
                record.setQuestionScore(questionsMap.get(record.getQuestionsId()).getQuestionScore());
            }

            if (questionsOptionMap.containsKey(record.getQuestionsId())) {
                record.setQuestionsOptionList(BeanMapper.mapList(questionsOptionMap.get(record.getQuestionsId()), QuestionsOptionVO.class));
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListWithAnswer", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PaperUserAnswerVO>> queryListWithAnswer(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<PaperUserAnswerEntity> page = service.queryPage(param,false);

        List<Long> questionsIds = page.getRecords().stream().map(PaperUserAnswerEntity::getQuestionsId).collect(Collectors.toList());


        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.IN, questionsIds));
        List<QuestionsOptionEntity> questionsOptionEntities = questionsOptionService.queryList(queryParam);
        Map<Long, List<QuestionsOptionEntity>> questionsOptionMap = questionsOptionEntities.stream().collect(Collectors.groupingBy(QuestionsOptionEntity::getPid));

        QueryParam queryParam1 = new QueryParam();
        queryParam1.getParams().put("id", new Parameter(QueryParam.IN, questionsIds));
        List<QuestionsEntity> questionsEntities = questionsService.queryList(queryParam1);
        Map<Long, QuestionsEntity> questionsMap = questionsEntities.stream().collect(Collectors.toMap(QuestionsEntity::getId, Function.identity(), (key1, key2) -> key2));


        IPage<PaperUserAnswerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaperUserAnswerVO.class));

        for (PaperUserAnswerVO record : pageData.getRecords()) {
            if (questionsMap.containsKey(record.getQuestionsId())){
                record.setQuestionType(questionsMap.get(record.getQuestionsId()).getQuestionType());
                record.setAnswer(questionsMap.get(record.getQuestionsId()).getAnswer());
                record.setMemo(questionsMap.get(record.getQuestionsId()).getMemo());
                record.setQuestionScore(questionsMap.get(record.getQuestionsId()).getQuestionScore());
            }

            if (questionsOptionMap.containsKey(record.getQuestionsId())) {
                record.setQuestionsOptionList(BeanMapper.mapList(questionsOptionMap.get(record.getQuestionsId()), QuestionsOptionVO.class));
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }




    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PaperUserAnswerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PaperUserAnswer-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPaperUserAnswerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PaperUserAnswerVO>> refPaperUserAnswerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PaperUserAnswerEntity> page = service.queryPage(param,false);
        IPage<PaperUserAnswerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaperUserAnswerVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
