package com.ejianc.business.exam.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.exam.bean.PaperEntity;
import com.ejianc.business.exam.bean.PaperQuestionsEntity;
import com.ejianc.business.exam.bean.PaperUserAnswerEntity;
import com.ejianc.business.exam.bean.PaperUserEntity;
import com.ejianc.business.exam.service.IPaperService;
import com.ejianc.business.exam.service.IPaperUserAnswerService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Service("paper") 
public class PaperBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IPaperService paperService;
	@Autowired
	private IPaperUserAnswerService userAnswerService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaperEntity paperEntity = paperService.selectById(billId);
		if (CollectionUtils.isNotEmpty(paperEntity.getPaperQuestionsList()) && CollectionUtils.isNotEmpty(paperEntity.getPaperUserList())){
			List<PaperUserAnswerEntity> paperUserAnswerEntities = new ArrayList<>();
			for (PaperQuestionsEntity paperQuestionsEntity : paperEntity.getPaperQuestionsList()) {
				for (PaperUserEntity paperUserEntity : paperEntity.getPaperUserList()) {
					PaperUserAnswerEntity paperUserAnswerEntity = BeanMapper.map(paperUserEntity, PaperUserAnswerEntity.class);
//					paperUserAnswerEntity.setUserId();
//					paperUserAnswerEntity.setUserName();
					paperUserAnswerEntity.setQuestionsId(paperQuestionsEntity.getQuestionsId());
					paperUserAnswerEntity.setQuestionsName(paperQuestionsEntity.getQuestionsName());
					paperUserAnswerEntity.setQuestionsScore(paperQuestionsEntity.getQuestionsScore());//分值
					paperUserAnswerEntity.setQuestionsNumber(paperQuestionsEntity.getQuestionsNumber());//排序
					paperUserAnswerEntity.setPid(billId);//试卷id
					paperUserAnswerEntity.setId(null);
					paperUserAnswerEntity.setCreateUserCode(null);
					paperUserAnswerEntity.setCreateTime(null);
					paperUserAnswerEntity.setUpdateUserName(null);
					paperUserAnswerEntity.setUpdateUserCode(null);
					paperUserAnswerEntity.setUpdateTime(null);
					paperUserAnswerEntities.add(paperUserAnswerEntity);
				}
			}

			userAnswerService.saveOrUpdateBatch(paperUserAnswerEntities);
		}else {
			return CommonResponse.error("获取试题清单和用户清单失败！");
		}
		//给用户发送消息提醒
		for (PaperUserEntity paperUserEntity : paperEntity.getPaperUserList()) {
			sendSys(paperUserEntity.getUserId()+"");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, billId));
		List<PaperUserAnswerEntity> paperUserAnswerEntities = userAnswerService.queryList(queryParam);
		userAnswerService.removeByIds(paperUserAnswerEntities.stream().map(PaperUserAnswerEntity::getId).collect(Collectors.toList()));
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}



	static  String  PC_URL = "/ejc-ecard-mobile/#/exam";
	static  String  TEST_AGENTID = "1000038";
	static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
	static  String  PRO_AGENTID = "1000036";
	static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";


	@Autowired
	private IPushMessageApi pushMessageApi;
	//预警代办提醒
	public boolean sendSys(String receiverId){

		PushMsgParameter parameter = new PushMsgParameter();
		List<String> channel = new ArrayList<>();
		channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
		channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
		String[] receivers = {receiverId};
		parameter.setReceivers(receivers);// 收信人
		parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
		parameter.setMsgType("task");//预警消息
		parameter.setSubject("考试提醒！");// 标题
		parameter.setContent("内容");// 内容
		parameter.setPcUrl(PC_URL);// pc端url
		parameter.setMobileUrl(PC_URL);// 移动端url
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setSendUserId(InvocationInfoProxy.getUserid());
		JSONObject weixineeParams = new JSONObject();
		weixineeParams.put("agentid", PRO_AGENTID);//企业微信应用id
		weixineeParams.put("secret", PRO_SECRET);//企业微信secret
		weixineeParams.put("msgtype", "textcard");
		weixineeParams.put("title", "考试提醒");
		weixineeParams.put("description", "请您在规定时间内完成考试！");
		weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
				"&targeturl=https%3A%2F%2Fpms.zzyjjt.com%2Fejc-ecard-mobile%2F%23%2Fexam%3Fuserid%3D"+receiverId));//移动端点击的url
		weixineeParams.put("btntxt", "点击查看");
		parameter.setWeixineeParams(weixineeParams);

		CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
		if (result.isSuccess()) {
			logger.info("消息发送成功---------------->,接收人:{}," + result.getMsg(), Arrays.toString(receivers));

			return true;
		} else {
			logger.error("消息发送失败---------------->" + result.getMsg());
			return false;
		}
	}
}
