package com.ejianc.business.news.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.Date;

/**
 * 新闻bean
 * 
 * @author guominga
 */
@TableName("ejc_idm_news")
public class NewsEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "title")
	private String title; // 新闻标题

	@TableField(value = "org_id")
	private Long orgId; // 发布组织ID

	@TableField(value = "publish_flag")
	private Integer publishFlag; // 是否发布 ， 1：发布 ， 0：未发布

	@TableField(value = "publish_user")
	private String publishUser; // 发布人

	@TableField(value = "publish_time")
	private Date publishTime; // 发布时间

	@TableField(value = "introduce")
	private String introduce; // 简介

	@TableField(value = "top_flag")
	private Integer topFlag; // 是否置顶, 1:置顶 ， 0： 取消置顶

	@TableField(value = "file_path")
	private String filePath; // 封面图片

	@TableField(value = "rotation_flag")
	private Integer rotationFlag; // 是否加入轮播, 1: 是， 0： 否

	@TableField(value = "content")
	private String content; // 内容

	@TableField(value = "author")
	private String author; // 作者
	@TableField(value = "news_type") //新闻类型 1--新闻动态，2--客户案例，3--行业观点,4--解决方案,5--视频课程
	private Long newsType;
	@TableField(value = "news_url") //外部链接地址
	private String newsUrl;

	@TableField(value = "enclosure_path")  //附件url地址
	private String enclosurePath;

	@TableField(value = "user_ids")
	private String userIds;//
	@TableField(value = "user_names")
	private String userNames;//
	@TableField(value = "news_type_name")
	private String newsTypeName;//


	public Long getNewsType() {
		return newsType;
	}

	public void setNewsType(Long newsType) {
		this.newsType = newsType;
	}

	public String getUserIds() {
		return userIds;
	}

	public void setUserIds(String userIds) {
		this.userIds = userIds;
	}

	public String getUserNames() {
		return userNames;
	}

	public void setUserNames(String userNames) {
		this.userNames = userNames;
	}

	public String getNewsTypeName() {
		return newsTypeName;
	}

	public void setNewsTypeName(String newsTypeName) {
		this.newsTypeName = newsTypeName;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getPublishFlag() {
		return publishFlag;
	}

	public void setPublishFlag(Integer publishFlag) {
		this.publishFlag = publishFlag;
	}

	public String getPublishUser() {
		return publishUser;
	}

	public void setPublishUser(String publishUser) {
		this.publishUser = publishUser;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public Integer getTopFlag() {
		return topFlag;
	}

	public void setTopFlag(Integer topFlag) {
		this.topFlag = topFlag;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Integer getRotationFlag() {
		return rotationFlag;
	}

	public void setRotationFlag(Integer rotationFlag) {
		this.rotationFlag = rotationFlag;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}


	public String getNewsUrl() {
		return newsUrl;
	}

	public void setNewsUrl(String newsUrl) {
		this.newsUrl = newsUrl;
	}

	public String getEnclosurePath() {
		return enclosurePath;
	}

	public void setEnclosurePath(String enclosurePath) {
		this.enclosurePath = enclosurePath;
	}
}
