package com.ejianc.business.news.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecard.vo.NewsVO;
import com.ejianc.business.news.bean.NewsEntity;
import com.ejianc.business.news.service.INewsService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;


@Controller
@RequestMapping("news")
public class NewsController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
	@Autowired
	private INewsService newsService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IOrgApi iOrgApi;
	/**
	 * 查询首页轮播图片
	 * @return
	 */
	@RequestMapping(value = "/queryImageList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<NewsVO>> queryImageList() {
		try {
			Long tenantId = InvocationInfoProxy.getTenantid();
			List<NewsEntity> entityList = newsService.queryImageList(tenantId);
			return CommonResponse.success(BeanMapper.mapList(entityList, NewsVO.class));
		} catch (Exception e) {
			logger.error("查询新闻信息异常: ", e);
            return CommonResponse.error("查询新闻信息异常");
		}
	}
	
	/**
	 * 查询首页新闻列表
	 * @return
	 */
	@RequestMapping(value = "/queryNewsList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<NewsVO>> queryNewsList() {
		try {
			Long tenantId = InvocationInfoProxy.getTenantid();
			List<NewsEntity> entityList = newsService.queryNewsList(tenantId);
			return CommonResponse.success(BeanMapper.mapList(entityList, NewsVO.class));
		} catch (Exception e) {
			logger.error("查询新闻信息异常: ", e);
            return CommonResponse.error("查询新闻信息异常");
		}
	}

	
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        try {
        	LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        	orderMap.put("topFlag", "desc");
        	orderMap.put("createTime", "desc");
        	queryParam.setOrderMap(orderMap);
        	queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
			/** 数据隔离 本下 没有组织orgId的删除下面代码 */
			queryParam.getParams().put("org_id",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

			IPage<NewsVO> backDataa = newsService.queryPageByParams(queryParam, false);
    		JSONObject jsonObject = new JSONObject();
    		jsonObject.put("data", backDataa);
			return CommonResponse.success(jsonObject);
        } catch (Exception e) {
            logger.error("查询新闻信息异常: ", e);
            return CommonResponse.error("查询新闻信息异常");
        }
    }

    /***
     * @Author mrsir_wxp
     * @Date 2021/8/11
     * @Description  微信公众号 查询过往新闻文章
     * @Param
     * @Return
     */
	@RequestMapping(value = "/queryListForWX", method = RequestMethod.POST)
	@ResponseBody
    public CommonResponse<JSONObject> queryListForWX(@RequestBody QueryParam queryParam) {
        try {
        	LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        	orderMap.put("topFlag", "desc");
        	orderMap.put("createTime", "desc");
        	queryParam.setOrderMap(orderMap);
        	queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ,999999));
        	queryParam.getParams().put("publishFlag", new Parameter(QueryParam.EQ,1));//已发布
            IPage<NewsVO> backDataa = newsService.queryPageByParams(queryParam, false);
    		JSONObject jsonObject = new JSONObject();
    		jsonObject.put("data", backDataa);
			return CommonResponse.success(jsonObject);
        } catch (Exception e) {
            logger.error("查询新闻信息异常: ", e);
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("data", new Page<NewsVO>());
			/** 异常保证前端不报错 */
            return CommonResponse.success(jsonObject);
        }
    }
	
	/**
	 * 查询详情
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<NewsVO> queryDetail(@RequestParam Long id) {
		try{
			
			NewsVO newsVo = newsService.queryDetail(id);
			
			CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryNoAuthListBySourceId(newsVo.getId(), "baiduu", "baiduu", "asc");
			if(attachmentResponse.isSuccess()) {
				List<AttachmentVO> attachmentList = attachmentResponse.getData();
				newsVo.setAttachmentVos(attachmentList);
			}
			
			return CommonResponse.success(newsVo);
		}catch (Exception e){
			return CommonResponse.error("查询详情失败,"+e.getMessage());
		}
	}
	
	/**
	 * 新增或者修改
	 * 
	 * @param orgVO
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> save(@RequestBody NewsVO newsVo) {
		if(newsVo.getId() != null &&newsVo.getId() > 0) {
			NewsVO newsVO = newsService.queryDetail(newsVo.getId());
			newsVO.setContent(newsVo.getContent());
			newsVO.setFilePath(newsVo.getFilePath());
			newsVO.setIntroduce(newsVo.getIntroduce());
			newsVO.setOrgId(newsVo.getOrgId());
			newsVO.setPublishFlag(newsVo.getPublishFlag());
			newsVO.setPublishTime(newsVo.getPublishTime());
			newsVO.setPublishUser(newsVo.getPublishUser());
			newsVO.setTopFlag(newsVo.getTopFlag());
			newsVO.setRotationFlag(newsVo.getRotationFlag());
			newsVO.setTitle(newsVo.getTitle());
			newsVO.setAuthor(newsVo.getAuthor());
			newsVO.setNewsType(newsVo.getNewsType());
			newsVO.setEnclosurePath(newsVo.getEnclosurePath());
			newsVO.setNewsUrl(newsVo.getNewsUrl());
			newsVO.setUserIds(newsVo.getUserIds());
			newsVO.setUserNames(newsVo.getUserNames());
			NewsEntity newsEntity = BeanMapper.map(newsVO, NewsEntity.class);
			newsService.saveOrUpdate(newsEntity, false);
			
			return CommonResponse.success("修改成功");
		}else{
			NewsEntity newsEntity = BeanMapper.map(newsVo, NewsEntity.class);
			newsEntity.setId(IdWorker.getId());
//			newsEntity.setOrgId(InvocationInfoProxy.getOrgId());
			newsService.saveOrUpdate(newsEntity, false);
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam List<Long> ids) {
		try{
			for(Long id : ids){
				newsService.delete(id);
			}
			return CommonResponse.success("删除成功");
		}catch (Exception e){
			return CommonResponse.error("删除失败,"+e.getMessage());
		}
	}

	/**
	 * 改变状态信息（是否发布/是否置顶/是否加入轮播）
	 * 
	 * @param orgVO
	 * @return
	 */
	@RequestMapping(value = "/changeNews", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> changeState(@RequestParam Long id,@RequestParam Integer newState, @RequestParam String field) {
		String msg = "";
		NewsVO newsVO = newsService.queryDetail(id);
		NewsEntity newsEntity = BeanMapper.map(newsVO, NewsEntity.class);
		if(field.equals("publishFlag")){
			if(newState==1){
				msg = "发布";
				//newsEntity.setOrgId(InvocationInfoProxy.getOrgId());
				newsEntity.setPublishTime(new Date());
				try {
					JSONArray jArray = ReferObjectUtil.getReferEntityValue(InvocationInfoProxy.getUserid().toString(), "idm-user");
					if(jArray!=null&&jArray.size()>0){
						JSONObject json = (JSONObject) jArray.get(0);
						newsEntity.setPublishUser(json.get("name").toString());
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}else{
				msg = "取消发布";
				newsEntity.setPublishTime(null);
				newsEntity.setPublishUser(null);
				//newsEntity.setOrgId(null);
			}
			newsEntity.setPublishFlag(newState);
		}else if(field.equals("topFlag")){
			if(newState==1){
				msg = "置顶";
			}else{
				msg = "取消置顶";
			}
			newsEntity.setTopFlag(newState);
		}else if(field.equals("rotationFlag")){
			if(newState==1){
				msg = "加入轮播";
			}else{
				msg = "取消加入轮播";
			}
			newsEntity.setRotationFlag(newState);
		}
		newsService.saveOrUpdate(newsEntity, false);
		return CommonResponse.success(msg+"成功");
	}
	
}
