package com.ejianc.business.news.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.ecard.vo.NewsVO;
import com.ejianc.business.news.bean.NewsEntity;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface INewsService extends IBaseService<NewsEntity> {

	NewsVO queryDetail(Long id);

	void delete(Long id);
	
	IPage<NewsVO> queryPageByParams(QueryParam queryParam, boolean isEs);

	List<NewsEntity> queryImageList(Long tenantId);

	List<NewsEntity> queryNewsList(Long tenantId);

	/**
	 * 小程序首页新闻列表查询，只查询新闻标题，简介，缩略图，不查询详情
	 * @param tenantId
	 * @return
	 */
    List<NewsEntity> queryIndexNewsList(Long tenantId);
}
