package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author sunyj
 * @Date 2020/5/27 设备明细
 * @Description PurchaseDetailsVO
 */

public class PurchaseContractDetailVO extends BaseVO {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 设备档案主键
     */
    private Long equipmentId;

    /**
     * 设备申请主键
     */
    private Long applyId;

    /**
     * 设备申请子表主键
     */
    private Long applyDetailId;

    /**
     * 来源类型 1-设备档案，2-申请单
     */
    private Integer source;

    /**
     * 设备编码
     */
    private String code;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * 计量单位名称
     */
    private String unitName;

    /**
     * 到货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arrivalDate;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 备注
     */
    private String memo;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更子表主键
     */
    private Long changeBid;

    /**
     * 变更类型
     */
    private String changeType;

    private java.lang.Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    private java.lang.Long srcSupplementId; // 来源补充协议主表ID
    private java.lang.Long srcSupplementDetailId; // 来源补充协议明细ID

    /**
     * 单价(含税)
     */
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    private BigDecimal detaiTaxRate;

    /**
     * 金额（含税）
     */
    private BigDecimal taxMoney;

    /**
     * 税额
     */
    private BigDecimal tax;

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetaiTaxRate() {
        return detaiTaxRate;
    }

    public void setDetaiTaxRate(BigDecimal detaiTaxRate) {
        this.detaiTaxRate = detaiTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Long getApplyDetailId() {
        return applyDetailId;
    }

    public void setApplyDetailId(Long applyDetailId) {
        this.applyDetailId = applyDetailId;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Date getArrivalDate() {
        return arrivalDate;
    }

    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
}
