package com.ejianc.business.equipment.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.hystrix.ContractInvoiceReceiveHystrix;
import com.ejianc.business.equipment.hystrix.EquipmentContractHystrix;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = ContractInvoiceReceiveHystrix.class)
public interface IContractInvoiceReceiveApi{
	/**
	 * 根据条件查询不同合同类型的合同
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getRentContractById")
	public CommonResponse<ContractResVO> getContractById(@RequestParam(value="settleId", required=true)Long contractId);
}
