package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备合同表
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
public class RentChangeVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同编码
     */
    private String billCode;

    /**
     * 组织主键
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 所属组织(采购组织)
     */
    private Long purchaseOrgId;

    /**
     * 所属组织名称(采购组织)
     */
    private String purchaseOrgName;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 总包企业主键
     */
    private Long customerId;

    /**
     * 总包企业名称
     */
    private String customerName;

    /**
     * 设备供应商主键
     */
    private Long supplierId;

    /**
     * 设备供应商名称
     */
    private String supplierName;

    /**
     * 变更日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 编制时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date makeTime;

    /**
     * 生效时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeTime;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private String contractStatus;

    /**
     * 备注
     */
    private String memo;

    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 初始版本金额（不含税）
     */
    private BigDecimal baseMoney;

    /**
     * 初始版本金额
     */
    private BigDecimal baseTaxMoney;

    /**
     * 变更前金额（不含税）
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    private Integer changeStatus;

    /**
     * 变更前合同名称
     */
    private String beforeContractName;
    private Long contractId;
    /**
     * 本次变更金额
     */
    private BigDecimal bb;
    // 设备明细子表
    private List<RentChangeDetailVO> rentdetail = new ArrayList<RentChangeDetailVO>();

    // 合同条款子表
    private List<RentChangeClauseVO> rentclause = new ArrayList<RentChangeClauseVO>();

    // 其他费用子表
    private List<RentChangeFeeVO> rentfee = new ArrayList<RentChangeFeeVO>();

    // 付款阶段子表
    private List<RentChangeStageVO> rentstage = new ArrayList<>();

    private Integer settlementType;

    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private String mainContractName; // 主合同编码
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private Integer replaceSignFlag; // 是否代签：0-否，1-是
    
    //历史版本编号
    private String historyBillCode;
    
    

    public String getHistoryBillCode() {
		return historyBillCode;
	}

	public void setHistoryBillCode(String historyBillCode) {
		this.historyBillCode = historyBillCode;
	}

	public Integer getReplaceSignFlag() {
        return replaceSignFlag;
    }

    public void setReplaceSignFlag(Integer replaceSignFlag) {
        this.replaceSignFlag = replaceSignFlag;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public List<RentChangeStageVO> getRentstage() {
        return rentstage;
    }

    public void setRentstage(List<RentChangeStageVO> rentstage) {
        this.rentstage = rentstage;
    }

    /**
     * 经办人名称
     */
    private String employeeName;
    /**
     * 本次变更占原合同比例
     */
    private BigDecimal scale;
    /**
     * 变更原因
     */
    private String changeReason;

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public BigDecimal getBb() {
        return bb;
    }

    public void setBb(BigDecimal bb) {
        this.bb = bb;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Date getMakeTime() {
        return makeTime;
    }

    public void setMakeTime(Date makeTime) {
        this.makeTime = makeTime;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public List<RentChangeDetailVO> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<RentChangeDetailVO> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<RentChangeClauseVO> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<RentChangeClauseVO> rentclause) {
        this.rentclause = rentclause;
    }

    public List<RentChangeFeeVO> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<RentChangeFeeVO> rentfee) {
        this.rentfee = rentfee;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getPurchaseOrgId() {
        return purchaseOrgId;
    }

    @ReferDeserialTransfer
    public void setPurchaseOrgId(Long purchaseOrgId) {
        this.purchaseOrgId = purchaseOrgId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
