package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@TableName("ejc_equipment_rent_use_record_detail")
public class RentUseRecordDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 使用记录主表主键
     */
    private Long useId;

    /**
     * 设备档案主键
     */
    private Long equipmentId;

    /**
     * 合同子表主键
     */
    private Long contractDetailId;

    /**
     * 来源
     */
    private Integer source;
    private String sourceName;

    /**
     * 设备编码
     */
    private String code;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * 计费方式
     */
    private String chargeType;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 使用时长
     */
    private BigDecimal useTime;

    /**
     * 租赁单价
     */
    private BigDecimal price;

    /**
     * 设备数量
     */
    private BigDecimal num;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 备注
     */
    private String memo;
    private String useCode;
    
    /**
     * 租赁单价含税
     */
    private BigDecimal priceTax;
    
    /**
     * 金额含税
     */
    private BigDecimal moneyTax;
    
    /**
     * 税金
     */
    private BigDecimal tax;
    
    /**
     * 税率
     */
    private BigDecimal taxRate;
    
    /**
     * 成本科目主键
     */
    private Long subjectId;

    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    private Long orgSubjectId;

    /**
     * 核算对象主键
     */
    private Long accountingId;

    /**
     * 核算对象名称
     */
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    private Long orgAccountingId;

    @ReferSerialTransfer(referCode="subject-project-ref")
    public Long getSubjectId() {
		return subjectId;
	}
    @ReferDeserialTransfer
	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}
	
	public Long getOrgSubjectId() {
		return orgSubjectId;
	}
	
	public void setOrgSubjectId(Long orgSubjectId) {
		this.orgSubjectId = orgSubjectId;
	}
	@ReferSerialTransfer(referCode="accounting-project-ref")
	public Long getAccountingId() {
		return accountingId;
	}
	@ReferDeserialTransfer
	public void setAccountingId(Long accountingId) {
		this.accountingId = accountingId;
	}

	public String getAccountingName() {
		return accountingName;
	}

	public void setAccountingName(String accountingName) {
		this.accountingName = accountingName;
	}

	public Long getOrgAccountingId() {
		return orgAccountingId;
	}

	public void setOrgAccountingId(Long orgAccountingId) {
		this.orgAccountingId = orgAccountingId;
	}

	public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getChargeType() {
        return chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getUseTime() {
        return useTime;
    }

    public void setUseTime(BigDecimal useTime) {
        this.useTime = useTime;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

	public BigDecimal getPriceTax() {
		return priceTax;
	}

	public void setPriceTax(BigDecimal priceTax) {
		this.priceTax = priceTax;
	}

	public BigDecimal getMoneyTax() {
		return moneyTax;
	}

	public void setMoneyTax(BigDecimal moneyTax) {
		this.moneyTax = moneyTax;
	}

	public BigDecimal getTax() {
		return tax;
	}

	public void setTax(BigDecimal tax) {
		this.tax = tax;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}


}
