package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author sunyj
 * @Date 2020/5/27 设备采购合同
 * @Description RentContractVO
 */

public class RentContractVO extends BaseVO {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同编码
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;


    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private Integer contractStatus;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 总包企业名称
     */
    private Long customerId;

    /**
     * 设备供应商
     */
    private Long supplierId;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;


    /**
     * 备注
     */
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    // 设备明细子表
    private List<RentDetailsVO> rentdetails = new ArrayList<RentDetailsVO>();

    // 合同条款子表
    private List<RentClauseVO> rentclause = new ArrayList<RentClauseVO>();

    // 其他费用子表
    private List<RentCostVO> rentcost = new ArrayList<RentCostVO>();

    public List<RentDetailsVO> getRentdetails() {
        return rentdetails;
    }

    public void setRentdetails(List<RentDetailsVO> rentdetails) {
        this.rentdetails = rentdetails;
    }

    public List<RentClauseVO> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<RentClauseVO> rentclause) {
        this.rentclause = rentclause;
    }

    public List<RentCostVO> getRentcost() {
        return rentcost;
    }

    public void setRentcost(List<RentCostVO> rentcost) {
        this.rentcost = rentcost;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }



    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
