package com.ejianc.business.equipment.vo;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.io.Serializable;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@TableName("ejc_equipment_purchase_settlement_detail")
public class PurchaseSettlementDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    private Long settlementId;

    /**
     * 设备档案主键
     */
    private Long equipmentId;

    /**
     * 合同明细主键
     */
    private Long contractDetailId;

    /**
     * 来源类型 1-设备档案，2-合同
     */
    private Integer source;

    /**
     * 设备编码
     */
    private String code;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * 计量单位名称
     */
    private String unitName;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    private String memo;

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
