package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author sunyj
 * @Date 2020/5/27 设备采购合同
 * @Description PurchaseContractVO
 */

public class PurchaseRecordVO extends BaseVO {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 原合同主键
     */
    private Long contractId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同编码
     */
    private String billCode;

    /**
     * 采购类型 1-自采，2-集采
     */
    private Integer purchaseType;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private Integer contractStatus;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 总包名称
     */
    private Long customerId;

    /**
     * 总包名称
     */
    private String customerName;

    /**
     * 设备供应商
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 备注
     */
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更编号
     */
    private String changeCode;

    /**
     * 初始版本金额（不含税）
     */
    private BigDecimal baseMoney;

    /**
     * 初始版本金额
     */
    private BigDecimal baseTaxMoney;

    /**
     * 变更前金额（不含税）
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更中金额(不含税)
     */
    private BigDecimal changingMny;

    /**
     * 变更中金额
     */
    private BigDecimal changingTaxMny;

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    private Integer changeStatus;

    /**
     * 累计预付款金额
     */
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    private BigDecimal sumOffsetMny;

    /**
     * 累计结算金额(不含税)
     */
    private BigDecimal sumSettlementMny;

    /**
     * 累计结算金额
     */
    private BigDecimal sumSettlementTaxMny;

    /**
     * 累计收票金额(不含税)
     */
    private BigDecimal sumInvoiceMny;

    /**
     * 累计收票金额
     */
    private BigDecimal sumInvoiceTaxMny;

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }

    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }
}
