package com.ejianc.business.equipment.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.hystrix.EquipmentContractHystrix;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.business.finance.pub.vo.PubContractQueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = EquipmentContractHystrix.class)
//@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", configuration = {KeepErrMsgConfiguration.class})
public interface IEquipmentContractApi extends IPubContractApi {

	/**
	 * 根据条件查询不同合同类型的合同
	 * @param queryVO
	 * @return
	 */
	@Override
	@GetMapping(value = "/api/equipment/getContract")
	public CommonResponse<JSONObject> getContract(@SpringQueryMap PubContractQueryVO queryVO);
	
}
